/*
 * Decompiled with CFR 0.152.
 */
package scimat.gui.commands.task;

import java.util.ArrayList;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import scimat.api.preprocessing.deduplicate.FindSimilarItemsByPlurals;
import scimat.gui.commands.NoUndoableTask;
import scimat.gui.components.ErrorDialogManager;
import scimat.gui.components.cursor.CursorManager;
import scimat.gui.components.movetogroup.MoveSimilarWordsToNewGroupDialog;
import scimat.model.knowledgebase.dao.WordDAO;
import scimat.model.knowledgebase.entity.Word;
import scimat.model.knowledgebase.exception.KnowledgeBaseException;
import scimat.project.CurrentProject;

public class FindSimilarWordsWithoutGroupByPluralsTask
implements NoUndoableTask {
    private JFrame receiver;

    public FindSimilarWordsWithoutGroupByPluralsTask(JFrame receiver) {
        this.receiver = receiver;
    }

    public void execute() {
        ArrayList<Word> vWordsFounded = new ArrayList<Word>();
        FindSimilarItemsByPlurals findSimilarItemsByPlurals = new FindSimilarItemsByPlurals();
        MoveSimilarWordsToNewGroupDialog matchDialog = new MoveSimilarWordsToNewGroupDialog(this.receiver);
        WordDAO wordDAO = CurrentProject.getInstance().getFactoryDAO().getWordDAO();
        try {
            ArrayList<Word> words = wordDAO.getWordsWithoutGroup();
            boolean cancelled = false;
            for (int i = 0; i < words.size() && !cancelled; ++i) {
                System.out.println("Finding keywords by plurals: " + i + " of " + words.size());
                CursorManager.getInstance().setWaitCursor();
                vWordsFounded.clear();
                boolean found = false;
                Word word1 = words.get(i);
                String wordName1 = word1.getWordName();
                for (int j = i + 1; j < words.size(); ++j) {
                    Word word2 = words.get(j);
                    String wordName2 = word2.getWordName();
                    if (!findSimilarItemsByPlurals.execute(wordName1, wordName2)) continue;
                    if (!found) {
                        vWordsFounded.add(word1);
                    }
                    vWordsFounded.add(word2);
                    found = true;
                }
                if (!found) continue;
                CursorManager.getInstance().setNormalCursor();
                matchDialog.refreshData(vWordsFounded);
                matchDialog.setVisible(true);
                cancelled = matchDialog.isCancelled();
                if (cancelled) {
                    int opt = JOptionPane.showConfirmDialog(this.receiver, "Are you sure you want to finish the search?", "Finding similar keywords", 1);
                    if (opt == 0) continue;
                    cancelled = false;
                    continue;
                }
                words.removeAll(matchDialog.getItems());
                if (word1.equals(words.get(i))) continue;
                --i;
            }
        }
        catch (KnowledgeBaseException e) {
            ErrorDialogManager.getInstance().showException(e);
        }
        CursorManager.getInstance().setNormalCursor();
        JOptionPane.showMessageDialog(this.receiver, "The search has finished", "Task finish", 1);
    }
}

