/*
 * Decompiled with CFR 0.152.
 */
package scimat.gui.commands.task;

import java.util.ArrayList;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import org.apache.commons.lang.StringUtils;
import scimat.gui.commands.NoUndoableTask;
import scimat.gui.components.ChooseLevenshteinDistanceDialog;
import scimat.gui.components.ErrorDialogManager;
import scimat.gui.components.cursor.CursorManager;
import scimat.gui.components.movetogroup.MoveSimilarWordsToNewGroupDialog;
import scimat.model.knowledgebase.dao.WordDAO;
import scimat.model.knowledgebase.entity.Word;
import scimat.model.knowledgebase.exception.KnowledgeBaseException;
import scimat.project.CurrentProject;

public class FindSimilarWordsWithoutGroupByDistanceTask
implements NoUndoableTask {
    private JFrame receiver;

    public FindSimilarWordsWithoutGroupByDistanceTask(JFrame receiver) {
        this.receiver = receiver;
    }

    public void execute() {
        ArrayList<Word> vWordsFounded = new ArrayList<Word>();
        MoveSimilarWordsToNewGroupDialog matchDialog = new MoveSimilarWordsToNewGroupDialog(this.receiver);
        WordDAO wordDAO = CurrentProject.getInstance().getFactoryDAO().getWordDAO();
        int maxDistance = this.getMaxDistance();
        matchDialog.reset();
        try {
            ArrayList<Word> words = wordDAO.getWordsWithoutGroup();
            boolean cancelled = false;
            for (int i = 0; i < words.size() && !cancelled; ++i) {
                System.out.println("Finding keywords by distance: " + i + " of " + words.size());
                CursorManager.getInstance().setWaitCursor();
                vWordsFounded.clear();
                boolean found = false;
                Word word1 = words.get(i);
                for (int j = i + 1; j < words.size(); ++j) {
                    Word word2 = words.get(j);
                    int distance = StringUtils.getLevenshteinDistance((String)word1.getWordName(), (String)word2.getWordName());
                    if (distance > maxDistance) continue;
                    if (word1.getWordName().length() != word2.getWordName().length()) {
                        if (!found) {
                            vWordsFounded.add(word1);
                        }
                        vWordsFounded.add(word2);
                        found = true;
                        continue;
                    }
                    if (word1.getWordName().length() <= distance) continue;
                    if (!found) {
                        vWordsFounded.add(word1);
                    }
                    vWordsFounded.add(word2);
                    found = true;
                }
                if (!found) continue;
                CursorManager.getInstance().setNormalCursor();
                matchDialog.reset();
                matchDialog.refreshData(vWordsFounded);
                matchDialog.setVisible(true);
                cancelled = matchDialog.isCancelled();
                if (cancelled) {
                    int opt = JOptionPane.showConfirmDialog(this.receiver, "Are you sure you want to finish the search?", "Finding similar keywords", 1);
                    if (opt == 0) continue;
                    cancelled = false;
                    continue;
                }
                words.removeAll(matchDialog.getItems());
                if (word1.equals(words.get(i))) continue;
                --i;
            }
        }
        catch (KnowledgeBaseException e) {
            ErrorDialogManager.getInstance().showException(e);
        }
        CursorManager.getInstance().setNormalCursor();
        JOptionPane.showMessageDialog(this.receiver, "The search has finished", "Task finish", 1);
    }

    private int getMaxDistance() {
        ChooseLevenshteinDistanceDialog distanceDialog = new ChooseLevenshteinDistanceDialog(this.receiver);
        distanceDialog.setVisible(true);
        return distanceDialog.getMaxDistance();
    }
}

