/*
 * Decompiled with CFR 0.152.
 */
package scimat.gui.commands.task;

import java.util.ArrayList;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import org.apache.commons.lang.StringUtils;
import scimat.gui.commands.NoUndoableTask;
import scimat.gui.components.ChooseLevenshteinDistanceDialog;
import scimat.gui.components.ErrorDialogManager;
import scimat.gui.components.cursor.CursorManager;
import scimat.gui.components.movetogroup.MoveSimilarReferencesToNewGroupDialog;
import scimat.model.knowledgebase.dao.ReferenceDAO;
import scimat.model.knowledgebase.entity.Reference;
import scimat.model.knowledgebase.exception.KnowledgeBaseException;
import scimat.project.CurrentProject;

public class FindSimilarReferencesWithoutGroupByDistanceTask
implements NoUndoableTask {
    private JFrame receiver;

    public FindSimilarReferencesWithoutGroupByDistanceTask(JFrame receiver) {
        this.receiver = receiver;
    }

    public void execute() {
        ArrayList<Reference> vReferencesFounded = new ArrayList<Reference>();
        MoveSimilarReferencesToNewGroupDialog matchDialog = new MoveSimilarReferencesToNewGroupDialog(this.receiver);
        ReferenceDAO referenceDAO = CurrentProject.getInstance().getFactoryDAO().getReferenceDAO();
        int maxDistance = this.getMaxDistance();
        matchDialog.reset();
        try {
            ArrayList<Reference> references = referenceDAO.getReferencesWithoutGroup();
            boolean cancelled = false;
            for (int i = 0; i < references.size() && !cancelled; ++i) {
                System.out.println("Finding keyreferences by distance: " + i + " of " + references.size());
                CursorManager.getInstance().setWaitCursor();
                vReferencesFounded.clear();
                boolean found = false;
                Reference reference1 = references.get(i);
                for (int j = i + 1; j < references.size(); ++j) {
                    Reference reference2 = references.get(j);
                    int distance = StringUtils.getLevenshteinDistance((String)reference1.getFullReference(), (String)reference2.getFullReference());
                    if (distance > maxDistance) continue;
                    if (reference1.getFullReference().length() != reference2.getFullReference().length()) {
                        if (!found) {
                            vReferencesFounded.add(reference1);
                        }
                        vReferencesFounded.add(reference2);
                        found = true;
                        continue;
                    }
                    if (reference1.getFullReference().length() <= distance) continue;
                    if (!found) {
                        vReferencesFounded.add(reference1);
                    }
                    vReferencesFounded.add(reference2);
                    found = true;
                }
                if (!found) continue;
                CursorManager.getInstance().setNormalCursor();
                matchDialog.reset();
                matchDialog.refreshData(vReferencesFounded);
                matchDialog.setVisible(true);
                cancelled = matchDialog.isCancelled();
                if (cancelled) {
                    int opt = JOptionPane.showConfirmDialog(this.receiver, "Are you sure you want to finish the search?", "Finding similar keyreferences", 1);
                    if (opt == 0) continue;
                    cancelled = false;
                    continue;
                }
                references.removeAll(matchDialog.getItems());
                if (reference1.equals(references.get(i))) continue;
                --i;
            }
        }
        catch (KnowledgeBaseException e) {
            ErrorDialogManager.getInstance().showException(e);
        }
        CursorManager.getInstance().setNormalCursor();
        JOptionPane.showMessageDialog(this.receiver, "The search has finished", "Task finish", 1);
    }

    private int getMaxDistance() {
        ChooseLevenshteinDistanceDialog distanceDialog = new ChooseLevenshteinDistanceDialog(this.receiver);
        distanceDialog.setVisible(true);
        return distanceDialog.getMaxDistance();
    }
}

