/*
 * Decompiled with CFR 0.152.
 */
package scimat.gui.commands.task;

import java.util.ArrayList;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import org.apache.commons.lang.StringUtils;
import scimat.gui.commands.NoUndoableTask;
import scimat.gui.components.ChooseLevenshteinDistanceDialog;
import scimat.gui.components.ErrorDialogManager;
import scimat.gui.components.cursor.CursorManager;
import scimat.gui.components.movetogroup.MoveSimilarReferenceSourcesToNewGroupDialog;
import scimat.model.knowledgebase.dao.ReferenceSourceDAO;
import scimat.model.knowledgebase.entity.ReferenceSource;
import scimat.model.knowledgebase.exception.KnowledgeBaseException;
import scimat.project.CurrentProject;

public class FindSimilarReferenceSourcesWithoutGroupByDistanceTask
implements NoUndoableTask {
    private JFrame receiver;

    public FindSimilarReferenceSourcesWithoutGroupByDistanceTask(JFrame receiver) {
        this.receiver = receiver;
    }

    public void execute() {
        ArrayList<ReferenceSource> vReferenceSourcesFounded = new ArrayList<ReferenceSource>();
        MoveSimilarReferenceSourcesToNewGroupDialog matchDialog = new MoveSimilarReferenceSourcesToNewGroupDialog(this.receiver);
        ReferenceSourceDAO referenceSourceDAO = CurrentProject.getInstance().getFactoryDAO().getReferenceSourceDAO();
        int maxDistance = this.getMaxDistance();
        matchDialog.reset();
        try {
            ArrayList<ReferenceSource> referenceSources = referenceSourceDAO.getReferenceSourcesWithoutGroup();
            boolean cancelled = false;
            for (int i = 0; i < referenceSources.size() && !cancelled; ++i) {
                System.out.println("Finding keyreferenceSources by distance: " + i + " of " + referenceSources.size());
                CursorManager.getInstance().setWaitCursor();
                vReferenceSourcesFounded.clear();
                boolean found = false;
                ReferenceSource referenceSource1 = referenceSources.get(i);
                for (int j = i + 1; j < referenceSources.size(); ++j) {
                    ReferenceSource referenceSource2 = referenceSources.get(j);
                    int distance = StringUtils.getLevenshteinDistance((String)referenceSource1.getSource(), (String)referenceSource2.getSource());
                    if (distance > maxDistance) continue;
                    if (referenceSource1.getSource().length() != referenceSource2.getSource().length()) {
                        if (!found) {
                            vReferenceSourcesFounded.add(referenceSource1);
                        }
                        vReferenceSourcesFounded.add(referenceSource2);
                        found = true;
                        continue;
                    }
                    if (referenceSource1.getSource().length() <= distance) continue;
                    if (!found) {
                        vReferenceSourcesFounded.add(referenceSource1);
                    }
                    vReferenceSourcesFounded.add(referenceSource2);
                    found = true;
                }
                if (!found) continue;
                CursorManager.getInstance().setNormalCursor();
                matchDialog.reset();
                matchDialog.refreshData(vReferenceSourcesFounded);
                matchDialog.setVisible(true);
                cancelled = matchDialog.isCancelled();
                if (cancelled) {
                    int opt = JOptionPane.showConfirmDialog(this.receiver, "Are you sure you want to finish the search?", "Finding similar keyreferenceSources", 1);
                    if (opt == 0) continue;
                    cancelled = false;
                    continue;
                }
                referenceSources.removeAll(matchDialog.getItems());
                if (referenceSource1.equals(referenceSources.get(i))) continue;
                --i;
            }
        }
        catch (KnowledgeBaseException e) {
            ErrorDialogManager.getInstance().showException(e);
        }
        CursorManager.getInstance().setNormalCursor();
        JOptionPane.showMessageDialog(this.receiver, "The search has finished", "Task finish", 1);
    }

    private int getMaxDistance() {
        ChooseLevenshteinDistanceDialog distanceDialog = new ChooseLevenshteinDistanceDialog(this.receiver);
        distanceDialog.setVisible(true);
        return distanceDialog.getMaxDistance();
    }
}

