/*
 * Decompiled with CFR 0.152.
 */
package scimat.gui.commands.task;

import java.util.ArrayList;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import org.apache.commons.lang.StringUtils;
import scimat.gui.commands.NoUndoableTask;
import scimat.gui.components.ChooseLevenshteinDistanceDialog;
import scimat.gui.components.ErrorDialogManager;
import scimat.gui.components.cursor.CursorManager;
import scimat.gui.components.movetogroup.MoveSimilarAuthorsToNewGroupDialog;
import scimat.model.knowledgebase.dao.AuthorDAO;
import scimat.model.knowledgebase.entity.Author;
import scimat.model.knowledgebase.exception.KnowledgeBaseException;
import scimat.project.CurrentProject;

public class FindSimilarAuthorsWithoutGroupByDistanceTask
implements NoUndoableTask {
    private JFrame receiver;

    public FindSimilarAuthorsWithoutGroupByDistanceTask(JFrame receiver) {
        this.receiver = receiver;
    }

    public void execute() {
        ArrayList<Author> vAuthorsFounded = new ArrayList<Author>();
        MoveSimilarAuthorsToNewGroupDialog matchDialog = new MoveSimilarAuthorsToNewGroupDialog(this.receiver);
        AuthorDAO authorDAO = CurrentProject.getInstance().getFactoryDAO().getAuthorDAO();
        int maxDistance = this.getMaxDistance();
        matchDialog.reset();
        try {
            ArrayList<Author> authors = authorDAO.getAuthorsWithoutGroup();
            boolean cancelled = false;
            for (int i = 0; i < authors.size() && !cancelled; ++i) {
                System.out.println("Finding keyauthors by distance: " + i + " of " + authors.size());
                CursorManager.getInstance().setWaitCursor();
                vAuthorsFounded.clear();
                boolean found = false;
                Author author1 = authors.get(i);
                for (int j = i + 1; j < authors.size(); ++j) {
                    Author author2 = authors.get(j);
                    int distance = StringUtils.getLevenshteinDistance((String)author1.getAuthorName(), (String)author2.getAuthorName());
                    if (distance > maxDistance) continue;
                    if (author1.getAuthorName().length() != author2.getAuthorName().length()) {
                        if (!found) {
                            vAuthorsFounded.add(author1);
                        }
                        vAuthorsFounded.add(author2);
                        found = true;
                        continue;
                    }
                    if (author1.getAuthorName().length() <= distance) continue;
                    if (!found) {
                        vAuthorsFounded.add(author1);
                    }
                    vAuthorsFounded.add(author2);
                    found = true;
                }
                if (!found) continue;
                CursorManager.getInstance().setNormalCursor();
                matchDialog.reset();
                matchDialog.refreshData(vAuthorsFounded);
                matchDialog.setVisible(true);
                cancelled = matchDialog.isCancelled();
                if (cancelled) {
                    int opt = JOptionPane.showConfirmDialog(this.receiver, "Are you sure you want to finish the search?", "Finding similar keyauthors", 1);
                    if (opt == 0) continue;
                    cancelled = false;
                    continue;
                }
                authors.removeAll(matchDialog.getItems());
                if (author1.equals(authors.get(i))) continue;
                --i;
            }
        }
        catch (KnowledgeBaseException e) {
            ErrorDialogManager.getInstance().showException(e);
        }
        CursorManager.getInstance().setNormalCursor();
        JOptionPane.showMessageDialog(this.receiver, "The search has finished", "Task finish", 1);
    }

    private int getMaxDistance() {
        ChooseLevenshteinDistanceDialog distanceDialog = new ChooseLevenshteinDistanceDialog(this.receiver);
        distanceDialog.setVisible(true);
        return distanceDialog.getMaxDistance();
    }
}

