/*
 * Decompiled with CFR 0.152.
 */
package scimat.gui.commands.task;

import java.util.ArrayList;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import org.apache.commons.lang.StringUtils;
import scimat.gui.commands.NoUndoableTask;
import scimat.gui.components.ChooseLevenshteinDistanceDialog;
import scimat.gui.components.ErrorDialogManager;
import scimat.gui.components.cursor.CursorManager;
import scimat.gui.components.movetogroup.MoveSimilarAuthorReferencesToNewGroupDialog;
import scimat.model.knowledgebase.dao.AuthorReferenceDAO;
import scimat.model.knowledgebase.entity.AuthorReference;
import scimat.model.knowledgebase.exception.KnowledgeBaseException;
import scimat.project.CurrentProject;

public class FindSimilarAuthorReferencesWithoutGroupByDistanceTask
implements NoUndoableTask {
    private JFrame receiver;

    public FindSimilarAuthorReferencesWithoutGroupByDistanceTask(JFrame receiver) {
        this.receiver = receiver;
    }

    public void execute() {
        ArrayList<AuthorReference> vAuthorReferencesFounded = new ArrayList<AuthorReference>();
        MoveSimilarAuthorReferencesToNewGroupDialog matchDialog = new MoveSimilarAuthorReferencesToNewGroupDialog(this.receiver);
        AuthorReferenceDAO authorReferenceDAO = CurrentProject.getInstance().getFactoryDAO().getAuthorReferenceDAO();
        int maxDistance = this.getMaxDistance();
        matchDialog.reset();
        try {
            ArrayList<AuthorReference> authorReferences = authorReferenceDAO.getAuthorReferencesWithoutGroup();
            boolean cancelled = false;
            for (int i = 0; i < authorReferences.size() && !cancelled; ++i) {
                System.out.println("Finding keyauthorReferences by distance: " + i + " of " + authorReferences.size());
                CursorManager.getInstance().setWaitCursor();
                vAuthorReferencesFounded.clear();
                boolean found = false;
                AuthorReference authorReference1 = authorReferences.get(i);
                for (int j = i + 1; j < authorReferences.size(); ++j) {
                    AuthorReference authorReference2 = authorReferences.get(j);
                    int distance = StringUtils.getLevenshteinDistance((String)authorReference1.getAuthorName(), (String)authorReference2.getAuthorName());
                    if (distance > maxDistance) continue;
                    if (authorReference1.getAuthorName().length() != authorReference2.getAuthorName().length()) {
                        if (!found) {
                            vAuthorReferencesFounded.add(authorReference1);
                        }
                        vAuthorReferencesFounded.add(authorReference2);
                        found = true;
                        continue;
                    }
                    if (authorReference1.getAuthorName().length() <= distance) continue;
                    if (!found) {
                        vAuthorReferencesFounded.add(authorReference1);
                    }
                    vAuthorReferencesFounded.add(authorReference2);
                    found = true;
                }
                if (!found) continue;
                CursorManager.getInstance().setNormalCursor();
                matchDialog.reset();
                matchDialog.refreshData(vAuthorReferencesFounded);
                matchDialog.setVisible(true);
                cancelled = matchDialog.isCancelled();
                if (cancelled) {
                    int opt = JOptionPane.showConfirmDialog(this.receiver, "Are you sure you want to finish the search?", "Finding similar keyauthorReferences", 1);
                    if (opt == 0) continue;
                    cancelled = false;
                    continue;
                }
                authorReferences.removeAll(matchDialog.getItems());
                if (authorReference1.equals(authorReferences.get(i))) continue;
                --i;
            }
        }
        catch (KnowledgeBaseException e) {
            ErrorDialogManager.getInstance().showException(e);
        }
        CursorManager.getInstance().setNormalCursor();
        JOptionPane.showMessageDialog(this.receiver, "The search has finished", "Task finish", 1);
    }

    private int getMaxDistance() {
        ChooseLevenshteinDistanceDialog distanceDialog = new ChooseLevenshteinDistanceDialog(this.receiver);
        distanceDialog.setVisible(true);
        return distanceDialog.getMaxDistance();
    }
}

