/*
 * Decompiled with CFR 0.152.
 */
package scimat.gui.commands.task;

import java.io.File;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import scimat.api.export.ExportException;
import scimat.api.export.ExportGroupsXML;
import scimat.gui.commands.NoUndoableTask;
import scimat.gui.components.ErrorDialogManager;
import scimat.gui.components.cursor.CursorManager;
import scimat.project.CurrentProject;

public class ExportGroupTask
implements NoUndoableTask {
    private JComponent receiver;

    public ExportGroupTask(JComponent component) {
        this.receiver = component;
    }

    public void execute() {
        JFileChooser fileChooser = new JFileChooser();
        fileChooser.setFileSelectionMode(0);
        fileChooser.setMultiSelectionEnabled(false);
        fileChooser.setCurrentDirectory(new File(CurrentProject.getInstance().getCurrentProjectPath()));
        int returnVal = fileChooser.showSaveDialog(this.receiver);
        if (returnVal == 0) {
            String path = fileChooser.getSelectedFile().getAbsolutePath();
            try {
                CursorManager.getInstance().setWaitCursor();
                new ExportGroupsXML(path).execute();
                CursorManager.getInstance().setNormalCursor();
            }
            catch (ExportException e) {
                CursorManager.getInstance().setNormalCursor();
                e.printStackTrace(System.err);
                ErrorDialogManager.getInstance().showError("An error happens.");
            }
        }
    }
}

