/*
 * Decompiled with CFR 0.152.
 */
package scimat.gui.commands.edit.update;

import javax.swing.undo.CannotUndoException;
import scimat.gui.commands.edit.KnowledgeBaseEdit;
import scimat.gui.undostack.UndoStack;
import scimat.knowledgebaseevents.KnowledgeBaseEventsReceiver;
import scimat.model.knowledgebase.entity.WordGroup;
import scimat.model.knowledgebase.exception.KnowledgeBaseException;
import scimat.project.CurrentProject;

public class UpdateWordGroupEdit
extends KnowledgeBaseEdit {
    private Integer wordGroupID;
    private String groupName;
    private boolean stopGroup;
    private WordGroup wordGroupOld;
    private WordGroup wordGroupUpdated;

    public UpdateWordGroupEdit(Integer wordGroupID, String groupName, boolean stopGroup) {
        this.wordGroupID = wordGroupID;
        this.groupName = groupName;
        this.stopGroup = stopGroup;
    }

    public boolean execute() throws KnowledgeBaseException {
        boolean successful = false;
        try {
            this.wordGroupOld = CurrentProject.getInstance().getFactoryDAO().getWordGroupDAO().getWordGroup(this.wordGroupID);
            if (this.wordGroupOld.getGroupName().equals(this.groupName)) {
                successful = CurrentProject.getInstance().getFactoryDAO().getWordGroupDAO().setStopGroup(this.wordGroupID, this.stopGroup, true);
                this.wordGroupUpdated = CurrentProject.getInstance().getFactoryDAO().getWordGroupDAO().getWordGroup(this.wordGroupID);
            } else if (this.groupName == null) {
                successful = false;
                this.errorMessage = "The name can not be null.";
            } else if (CurrentProject.getInstance().getFactoryDAO().getWordGroupDAO().checkWordGroup(this.groupName)) {
                successful = false;
                this.errorMessage = "A word group yet exists with this name.";
            } else {
                successful = CurrentProject.getInstance().getFactoryDAO().getWordGroupDAO().updateWordGroup(this.wordGroupID, this.groupName, this.stopGroup, true);
                this.wordGroupUpdated = CurrentProject.getInstance().getFactoryDAO().getWordGroupDAO().getWordGroup(this.wordGroupID);
            }
            if (successful) {
                CurrentProject.getInstance().getKnowledgeBase().commit();
                KnowledgeBaseEventsReceiver.getInstance().fireEvents();
                successful = true;
                UndoStack.addEdit(this);
            } else {
                CurrentProject.getInstance().getKnowledgeBase().rollback();
            }
        }
        catch (KnowledgeBaseException e) {
            CurrentProject.getInstance().getKnowledgeBase().rollback();
            successful = false;
            this.errorMessage = "An exception happened.";
            throw e;
        }
        return successful;
    }

    public void undo() throws CannotUndoException {
        super.undo();
        try {
            boolean flag = this.wordGroupOld.getGroupName().equals(this.wordGroupUpdated.getGroupName()) ? CurrentProject.getInstance().getFactoryDAO().getWordGroupDAO().setStopGroup(this.wordGroupOld.getWordGroupID(), this.wordGroupOld.isStopGroup(), true) : CurrentProject.getInstance().getFactoryDAO().getWordGroupDAO().updateWordGroup(this.wordGroupOld.getWordGroupID(), this.wordGroupOld.getGroupName(), this.wordGroupOld.isStopGroup(), true);
            if (flag) {
                CurrentProject.getInstance().getKnowledgeBase().commit();
                KnowledgeBaseEventsReceiver.getInstance().fireEvents();
            } else {
                CurrentProject.getInstance().getKnowledgeBase().rollback();
            }
        }
        catch (KnowledgeBaseException e) {
            e.printStackTrace(System.err);
            try {
                CurrentProject.getInstance().getKnowledgeBase().rollback();
            }
            catch (KnowledgeBaseException e2) {
                e2.printStackTrace(System.err);
            }
        }
    }

    public void redo() throws CannotUndoException {
        super.redo();
        try {
            boolean flag = this.wordGroupOld.getGroupName().equals(this.groupName) ? CurrentProject.getInstance().getFactoryDAO().getWordGroupDAO().setStopGroup(this.wordGroupID, this.stopGroup, true) : CurrentProject.getInstance().getFactoryDAO().getWordGroupDAO().updateWordGroup(this.wordGroupID, this.groupName, this.stopGroup, true);
            if (flag) {
                CurrentProject.getInstance().getKnowledgeBase().commit();
                KnowledgeBaseEventsReceiver.getInstance().fireEvents();
            } else {
                CurrentProject.getInstance().getKnowledgeBase().rollback();
            }
        }
        catch (KnowledgeBaseException e) {
            e.printStackTrace(System.err);
            try {
                CurrentProject.getInstance().getKnowledgeBase().rollback();
            }
            catch (KnowledgeBaseException e2) {
                e2.printStackTrace(System.err);
            }
        }
    }
}

