/*
 * Decompiled with CFR 0.152.
 */
package scimat.gui.commands.edit.update;

import java.util.ArrayList;
import javax.swing.undo.CannotUndoException;
import scimat.gui.commands.edit.KnowledgeBaseEdit;
import scimat.gui.undostack.UndoStack;
import scimat.knowledgebaseevents.KnowledgeBaseEventsReceiver;
import scimat.model.knowledgebase.entity.Word;
import scimat.model.knowledgebase.exception.KnowledgeBaseException;
import scimat.project.CurrentProject;

public class UpdateWordEdit
extends KnowledgeBaseEdit {
    private Integer wordID;
    private String wordName;
    private ArrayList<Word> wordsOld;
    private ArrayList<Word> wordsUpdated;

    public UpdateWordEdit(Integer wordID, String wordName) {
        this.wordID = wordID;
        this.wordName = wordName;
        this.wordsOld = new ArrayList();
        this.wordsUpdated = new ArrayList();
    }

    public boolean execute() throws KnowledgeBaseException {
        boolean successful = false;
        try {
            if (this.wordName == null) {
                successful = false;
                this.errorMessage = "The name can not be null.";
            } else if (CurrentProject.getInstance().getFactoryDAO().getWordDAO().checkWord(this.wordName)) {
                successful = false;
                this.errorMessage = "A word yet exists with this name.";
            } else {
                this.wordsOld.add(CurrentProject.getInstance().getFactoryDAO().getWordDAO().getWord(this.wordID));
                successful = CurrentProject.getInstance().getFactoryDAO().getWordDAO().setWordName(this.wordID, this.wordName, true);
                this.wordsUpdated.add(CurrentProject.getInstance().getFactoryDAO().getWordDAO().getWord(this.wordID));
                if (successful) {
                    CurrentProject.getInstance().getKnowledgeBase().commit();
                    KnowledgeBaseEventsReceiver.getInstance().fireEvents();
                    successful = true;
                    UndoStack.addEdit(this);
                } else {
                    CurrentProject.getInstance().getKnowledgeBase().rollback();
                    successful = false;
                    this.errorMessage = "An error happened.";
                }
            }
        }
        catch (KnowledgeBaseException e) {
            CurrentProject.getInstance().getKnowledgeBase().rollback();
            successful = false;
            this.errorMessage = "An exception happened.";
            throw e;
        }
        return successful;
    }

    public void undo() throws CannotUndoException {
        super.undo();
        try {
            Word word = this.wordsOld.get(0);
            boolean flag = CurrentProject.getInstance().getFactoryDAO().getWordDAO().setWordName(word.getWordID(), word.getWordName(), true);
            if (flag) {
                CurrentProject.getInstance().getKnowledgeBase().commit();
                KnowledgeBaseEventsReceiver.getInstance().fireEvents();
            } else {
                CurrentProject.getInstance().getKnowledgeBase().rollback();
            }
        }
        catch (KnowledgeBaseException e) {
            e.printStackTrace(System.err);
            try {
                CurrentProject.getInstance().getKnowledgeBase().rollback();
            }
            catch (KnowledgeBaseException e2) {
                e2.printStackTrace(System.err);
            }
        }
    }

    public void redo() throws CannotUndoException {
        super.redo();
        try {
            boolean flag = CurrentProject.getInstance().getFactoryDAO().getWordDAO().setWordName(this.wordID, this.wordName, true);
            if (flag) {
                CurrentProject.getInstance().getKnowledgeBase().commit();
                KnowledgeBaseEventsReceiver.getInstance().fireEvents();
            } else {
                CurrentProject.getInstance().getKnowledgeBase().rollback();
            }
        }
        catch (KnowledgeBaseException e) {
            e.printStackTrace(System.err);
            try {
                CurrentProject.getInstance().getKnowledgeBase().rollback();
            }
            catch (KnowledgeBaseException e2) {
                e2.printStackTrace(System.err);
            }
        }
    }
}

