/*
 * Decompiled with CFR 0.152.
 */
package scimat.gui.commands.edit.update;

import java.util.ArrayList;
import javax.swing.undo.CannotUndoException;
import scimat.gui.commands.edit.KnowledgeBaseEdit;
import scimat.gui.undostack.UndoStack;
import scimat.knowledgebaseevents.KnowledgeBaseEventsReceiver;
import scimat.model.knowledgebase.entity.SubjectCategory;
import scimat.model.knowledgebase.exception.KnowledgeBaseException;
import scimat.project.CurrentProject;

public class UpdateSubjectCategoryEdit
extends KnowledgeBaseEdit {
    private Integer subjectCategoryID;
    private String subjectCategoryName;
    private ArrayList<SubjectCategory> subjectCategoriesOld;
    private ArrayList<SubjectCategory> subjectCategoriesUpdated;

    public UpdateSubjectCategoryEdit(Integer subjectCategoryID, String subjectCategoryName) {
        this.subjectCategoryID = subjectCategoryID;
        this.subjectCategoryName = subjectCategoryName;
        this.subjectCategoriesOld = new ArrayList();
        this.subjectCategoriesUpdated = new ArrayList();
    }

    public boolean execute() throws KnowledgeBaseException {
        boolean successful = false;
        try {
            if (this.subjectCategoryName == null) {
                successful = false;
                this.errorMessage = "The name can not be null.";
            } else if (CurrentProject.getInstance().getFactoryDAO().getSubjectCategoryDAO().checkSubjectCategory(this.subjectCategoryName)) {
                successful = false;
                this.errorMessage = "A Subject categoty yet exists with this name.";
            } else {
                this.subjectCategoriesOld.add(CurrentProject.getInstance().getFactoryDAO().getSubjectCategoryDAO().getSubjectCategory(this.subjectCategoryID));
                successful = CurrentProject.getInstance().getFactoryDAO().getSubjectCategoryDAO().setSubjectCategoryName(this.subjectCategoryID, this.subjectCategoryName, true);
                this.subjectCategoriesUpdated.add(CurrentProject.getInstance().getFactoryDAO().getSubjectCategoryDAO().getSubjectCategory(this.subjectCategoryID));
                if (successful) {
                    CurrentProject.getInstance().getKnowledgeBase().commit();
                    KnowledgeBaseEventsReceiver.getInstance().fireEvents();
                    successful = true;
                    UndoStack.addEdit(this);
                } else {
                    CurrentProject.getInstance().getKnowledgeBase().rollback();
                    successful = false;
                    this.errorMessage = "An error happened.";
                }
            }
        }
        catch (KnowledgeBaseException e) {
            CurrentProject.getInstance().getKnowledgeBase().rollback();
            successful = false;
            this.errorMessage = "An exception happened.";
            throw e;
        }
        return successful;
    }

    public void undo() throws CannotUndoException {
        super.undo();
        try {
            SubjectCategory subjectCategory = this.subjectCategoriesOld.get(0);
            boolean flag = CurrentProject.getInstance().getFactoryDAO().getSubjectCategoryDAO().setSubjectCategoryName(subjectCategory.getSubjectCategoryID(), subjectCategory.getSubjectCategoryName(), true);
            if (flag) {
                CurrentProject.getInstance().getKnowledgeBase().commit();
                KnowledgeBaseEventsReceiver.getInstance().fireEvents();
            } else {
                CurrentProject.getInstance().getKnowledgeBase().rollback();
            }
        }
        catch (KnowledgeBaseException e) {
            e.printStackTrace(System.err);
            try {
                CurrentProject.getInstance().getKnowledgeBase().rollback();
            }
            catch (KnowledgeBaseException e2) {
                e2.printStackTrace(System.err);
            }
        }
    }

    public void redo() throws CannotUndoException {
        super.redo();
        try {
            boolean flag = CurrentProject.getInstance().getFactoryDAO().getSubjectCategoryDAO().setSubjectCategoryName(this.subjectCategoryID, this.subjectCategoryName, true);
            if (flag) {
                CurrentProject.getInstance().getKnowledgeBase().commit();
                KnowledgeBaseEventsReceiver.getInstance().fireEvents();
            } else {
                CurrentProject.getInstance().getKnowledgeBase().rollback();
            }
        }
        catch (KnowledgeBaseException e) {
            e.printStackTrace(System.err);
            try {
                CurrentProject.getInstance().getKnowledgeBase().rollback();
            }
            catch (KnowledgeBaseException e2) {
                e2.printStackTrace(System.err);
            }
        }
    }
}

