/*
 * Decompiled with CFR 0.152.
 */
package scimat.gui.commands.edit.update;

import javax.swing.undo.CannotUndoException;
import scimat.gui.commands.edit.KnowledgeBaseEdit;
import scimat.gui.undostack.UndoStack;
import scimat.knowledgebaseevents.KnowledgeBaseEventsReceiver;
import scimat.model.knowledgebase.entity.ReferenceSourceGroup;
import scimat.model.knowledgebase.exception.KnowledgeBaseException;
import scimat.project.CurrentProject;

public class UpdateReferenceSourceGroupEdit
extends KnowledgeBaseEdit {
    private Integer referenceSourceGroupID;
    private String groupName;
    private boolean stopGroup;
    private ReferenceSourceGroup referenceSourceGroupOld;
    private ReferenceSourceGroup referenceSourceGroupUpdated;

    public UpdateReferenceSourceGroupEdit(Integer referenceSourceGroupID, String groupName, boolean stopGroup) {
        this.referenceSourceGroupID = referenceSourceGroupID;
        this.groupName = groupName;
        this.stopGroup = stopGroup;
    }

    public boolean execute() throws KnowledgeBaseException {
        boolean successful = false;
        try {
            this.referenceSourceGroupOld = CurrentProject.getInstance().getFactoryDAO().getReferenceSourceGroupDAO().getReferenceSourceGroup(this.referenceSourceGroupID);
            if (this.referenceSourceGroupOld.getGroupName().equals(this.groupName)) {
                successful = CurrentProject.getInstance().getFactoryDAO().getReferenceSourceGroupDAO().setStopGroup(this.referenceSourceGroupID, this.stopGroup, true);
                this.referenceSourceGroupUpdated = CurrentProject.getInstance().getFactoryDAO().getReferenceSourceGroupDAO().getReferenceSourceGroup(this.referenceSourceGroupID);
            } else if (this.groupName == null) {
                successful = false;
                this.errorMessage = "The name can not be null.";
            } else if (CurrentProject.getInstance().getFactoryDAO().getReferenceSourceGroupDAO().checkReferenceSourceGroup(this.groupName)) {
                successful = false;
                this.errorMessage = "A Reference source group yet exists with this name.";
            } else {
                successful = CurrentProject.getInstance().getFactoryDAO().getReferenceSourceGroupDAO().updateReferenceSourceGroup(this.referenceSourceGroupID, this.groupName, this.stopGroup, true);
                this.referenceSourceGroupUpdated = CurrentProject.getInstance().getFactoryDAO().getReferenceSourceGroupDAO().getReferenceSourceGroup(this.referenceSourceGroupID);
            }
            if (successful) {
                CurrentProject.getInstance().getKnowledgeBase().commit();
                KnowledgeBaseEventsReceiver.getInstance().fireEvents();
                successful = true;
                UndoStack.addEdit(this);
            } else {
                CurrentProject.getInstance().getKnowledgeBase().rollback();
            }
        }
        catch (KnowledgeBaseException e) {
            CurrentProject.getInstance().getKnowledgeBase().rollback();
            successful = false;
            this.errorMessage = "An exception happened.";
            throw e;
        }
        return successful;
    }

    public void undo() throws CannotUndoException {
        super.undo();
        try {
            boolean flag = this.referenceSourceGroupOld.getGroupName().equals(this.referenceSourceGroupUpdated.getGroupName()) ? CurrentProject.getInstance().getFactoryDAO().getReferenceSourceGroupDAO().setStopGroup(this.referenceSourceGroupOld.getReferenceSourceGroupID(), this.referenceSourceGroupOld.isStopGroup(), true) : CurrentProject.getInstance().getFactoryDAO().getReferenceSourceGroupDAO().updateReferenceSourceGroup(this.referenceSourceGroupOld.getReferenceSourceGroupID(), this.referenceSourceGroupOld.getGroupName(), this.referenceSourceGroupOld.isStopGroup(), true);
            if (flag) {
                CurrentProject.getInstance().getKnowledgeBase().commit();
                KnowledgeBaseEventsReceiver.getInstance().fireEvents();
            } else {
                CurrentProject.getInstance().getKnowledgeBase().rollback();
            }
        }
        catch (KnowledgeBaseException e) {
            e.printStackTrace(System.err);
            try {
                CurrentProject.getInstance().getKnowledgeBase().rollback();
            }
            catch (KnowledgeBaseException e2) {
                e2.printStackTrace(System.err);
            }
        }
    }

    public void redo() throws CannotUndoException {
        super.redo();
        try {
            boolean flag = this.referenceSourceGroupOld.getGroupName().equals(this.groupName) ? CurrentProject.getInstance().getFactoryDAO().getReferenceSourceGroupDAO().setStopGroup(this.referenceSourceGroupID, this.stopGroup, true) : CurrentProject.getInstance().getFactoryDAO().getReferenceSourceGroupDAO().updateReferenceSourceGroup(this.referenceSourceGroupID, this.groupName, this.stopGroup, true);
            if (flag) {
                CurrentProject.getInstance().getKnowledgeBase().commit();
                KnowledgeBaseEventsReceiver.getInstance().fireEvents();
            } else {
                CurrentProject.getInstance().getKnowledgeBase().rollback();
            }
        }
        catch (KnowledgeBaseException e) {
            e.printStackTrace(System.err);
            try {
                CurrentProject.getInstance().getKnowledgeBase().rollback();
            }
            catch (KnowledgeBaseException e2) {
                e2.printStackTrace(System.err);
            }
        }
    }
}

