/*
 * Decompiled with CFR 0.152.
 */
package scimat.gui.commands.edit.update;

import java.util.ArrayList;
import javax.swing.undo.CannotUndoException;
import scimat.gui.commands.edit.KnowledgeBaseEdit;
import scimat.gui.undostack.UndoStack;
import scimat.knowledgebaseevents.KnowledgeBaseEventsReceiver;
import scimat.model.knowledgebase.entity.ReferenceSource;
import scimat.model.knowledgebase.exception.KnowledgeBaseException;
import scimat.project.CurrentProject;

public class UpdateReferenceSourceEdit
extends KnowledgeBaseEdit {
    private Integer referenceSourceID;
    private String source;
    private ArrayList<ReferenceSource> referenceSourcesOld;
    private ArrayList<ReferenceSource> referenceSourcesUpdated;

    public UpdateReferenceSourceEdit(Integer referenceSourceID, String source) {
        this.referenceSourceID = referenceSourceID;
        this.source = source;
        this.referenceSourcesOld = new ArrayList();
        this.referenceSourcesUpdated = new ArrayList();
    }

    public boolean execute() throws KnowledgeBaseException {
        boolean successful = false;
        try {
            if (this.source == null) {
                successful = false;
                this.errorMessage = "The source can not be null.";
            } else if (CurrentProject.getInstance().getFactoryDAO().getReferenceSourceDAO().checkReferenceSource(this.source)) {
                successful = false;
                this.errorMessage = "A reference source yet exists with this source.";
            } else {
                this.referenceSourcesOld.add(CurrentProject.getInstance().getFactoryDAO().getReferenceSourceDAO().getReferenceSource(this.referenceSourceID));
                successful = CurrentProject.getInstance().getFactoryDAO().getReferenceSourceDAO().setSource(this.referenceSourceID, this.source, true);
                this.referenceSourcesUpdated.add(CurrentProject.getInstance().getFactoryDAO().getReferenceSourceDAO().getReferenceSource(this.referenceSourceID));
                if (successful) {
                    CurrentProject.getInstance().getKnowledgeBase().commit();
                    KnowledgeBaseEventsReceiver.getInstance().fireEvents();
                    successful = true;
                    UndoStack.addEdit(this);
                } else {
                    CurrentProject.getInstance().getKnowledgeBase().rollback();
                    successful = false;
                    this.errorMessage = "An error happened.";
                }
            }
        }
        catch (KnowledgeBaseException e) {
            CurrentProject.getInstance().getKnowledgeBase().rollback();
            successful = false;
            this.errorMessage = "An exception happened.";
            throw e;
        }
        return successful;
    }

    public void undo() throws CannotUndoException {
        super.undo();
        try {
            ReferenceSource referenceSource = this.referenceSourcesOld.get(0);
            boolean flag = CurrentProject.getInstance().getFactoryDAO().getReferenceSourceDAO().setSource(referenceSource.getReferenceSourceID(), referenceSource.getSource(), true);
            if (flag) {
                CurrentProject.getInstance().getKnowledgeBase().commit();
                KnowledgeBaseEventsReceiver.getInstance().fireEvents();
            } else {
                CurrentProject.getInstance().getKnowledgeBase().rollback();
            }
        }
        catch (KnowledgeBaseException e) {
            e.printStackTrace(System.err);
            try {
                CurrentProject.getInstance().getKnowledgeBase().rollback();
            }
            catch (KnowledgeBaseException e2) {
                e2.printStackTrace(System.err);
            }
        }
    }

    public void redo() throws CannotUndoException {
        super.redo();
        try {
            boolean flag = CurrentProject.getInstance().getFactoryDAO().getReferenceSourceDAO().setSource(this.referenceSourceID, this.source, true);
            if (flag) {
                CurrentProject.getInstance().getKnowledgeBase().commit();
                KnowledgeBaseEventsReceiver.getInstance().fireEvents();
            } else {
                CurrentProject.getInstance().getKnowledgeBase().rollback();
            }
        }
        catch (KnowledgeBaseException e) {
            e.printStackTrace(System.err);
            try {
                CurrentProject.getInstance().getKnowledgeBase().rollback();
            }
            catch (KnowledgeBaseException e2) {
                e2.printStackTrace(System.err);
            }
        }
    }
}

