/*
 * Decompiled with CFR 0.152.
 */
package scimat.gui.commands.edit.update;

import javax.swing.undo.CannotUndoException;
import scimat.gui.commands.edit.KnowledgeBaseEdit;
import scimat.gui.undostack.UndoStack;
import scimat.knowledgebaseevents.KnowledgeBaseEventsReceiver;
import scimat.model.knowledgebase.entity.ReferenceGroup;
import scimat.model.knowledgebase.exception.KnowledgeBaseException;
import scimat.project.CurrentProject;

public class UpdateReferenceGroupEdit
extends KnowledgeBaseEdit {
    private Integer referenceGroupID;
    private String groupName;
    private boolean stopGroup;
    private ReferenceGroup referenceGroupOld;
    private ReferenceGroup referenceGroupUpdated;

    public UpdateReferenceGroupEdit(Integer referenceGroupID, String groupName, boolean stopGroup) {
        this.referenceGroupID = referenceGroupID;
        this.groupName = groupName;
        this.stopGroup = stopGroup;
    }

    public boolean execute() throws KnowledgeBaseException {
        boolean successful = false;
        try {
            this.referenceGroupOld = CurrentProject.getInstance().getFactoryDAO().getReferenceGroupDAO().getReferenceGroup(this.referenceGroupID);
            if (this.referenceGroupOld.getGroupName().equals(this.groupName)) {
                successful = CurrentProject.getInstance().getFactoryDAO().getReferenceGroupDAO().setStopGroup(this.referenceGroupID, this.stopGroup, true);
                this.referenceGroupUpdated = CurrentProject.getInstance().getFactoryDAO().getReferenceGroupDAO().getReferenceGroup(this.referenceGroupID);
            } else if (this.groupName == null) {
                successful = false;
                this.errorMessage = "The name can not be null.";
            } else if (CurrentProject.getInstance().getFactoryDAO().getReferenceGroupDAO().checkReferenceGroup(this.groupName)) {
                successful = false;
                this.errorMessage = "A reference group yet exists with this name.";
            } else {
                successful = CurrentProject.getInstance().getFactoryDAO().getReferenceGroupDAO().updateReferenceGroup(this.referenceGroupID, this.groupName, this.stopGroup, true);
                this.referenceGroupUpdated = CurrentProject.getInstance().getFactoryDAO().getReferenceGroupDAO().getReferenceGroup(this.referenceGroupID);
            }
            if (successful) {
                CurrentProject.getInstance().getKnowledgeBase().commit();
                KnowledgeBaseEventsReceiver.getInstance().fireEvents();
                successful = true;
                UndoStack.addEdit(this);
            } else {
                CurrentProject.getInstance().getKnowledgeBase().rollback();
            }
        }
        catch (KnowledgeBaseException e) {
            CurrentProject.getInstance().getKnowledgeBase().rollback();
            successful = false;
            this.errorMessage = "An exception happened.";
            throw e;
        }
        return successful;
    }

    public void undo() throws CannotUndoException {
        super.undo();
        try {
            boolean flag = this.referenceGroupOld.getGroupName().equals(this.referenceGroupUpdated.getGroupName()) ? CurrentProject.getInstance().getFactoryDAO().getReferenceGroupDAO().setStopGroup(this.referenceGroupOld.getReferenceGroupID(), this.referenceGroupOld.isStopGroup(), true) : CurrentProject.getInstance().getFactoryDAO().getReferenceGroupDAO().updateReferenceGroup(this.referenceGroupOld.getReferenceGroupID(), this.referenceGroupOld.getGroupName(), this.referenceGroupOld.isStopGroup(), true);
            if (flag) {
                CurrentProject.getInstance().getKnowledgeBase().commit();
                KnowledgeBaseEventsReceiver.getInstance().fireEvents();
            } else {
                CurrentProject.getInstance().getKnowledgeBase().rollback();
            }
        }
        catch (KnowledgeBaseException e) {
            e.printStackTrace(System.err);
            try {
                CurrentProject.getInstance().getKnowledgeBase().rollback();
            }
            catch (KnowledgeBaseException e2) {
                e2.printStackTrace(System.err);
            }
        }
    }

    public void redo() throws CannotUndoException {
        super.redo();
        try {
            boolean flag = this.referenceGroupOld.getGroupName().equals(this.groupName) ? CurrentProject.getInstance().getFactoryDAO().getReferenceGroupDAO().setStopGroup(this.referenceGroupID, this.stopGroup, true) : CurrentProject.getInstance().getFactoryDAO().getReferenceGroupDAO().updateReferenceGroup(this.referenceGroupID, this.groupName, this.stopGroup, true);
            if (flag) {
                CurrentProject.getInstance().getKnowledgeBase().commit();
                KnowledgeBaseEventsReceiver.getInstance().fireEvents();
            } else {
                CurrentProject.getInstance().getKnowledgeBase().rollback();
            }
        }
        catch (KnowledgeBaseException e) {
            e.printStackTrace(System.err);
            try {
                CurrentProject.getInstance().getKnowledgeBase().rollback();
            }
            catch (KnowledgeBaseException e2) {
                e2.printStackTrace(System.err);
            }
        }
    }
}

