/*
 * Decompiled with CFR 0.152.
 */
package scimat.gui.commands.edit.update;

import javax.swing.undo.CannotUndoException;
import scimat.gui.commands.edit.KnowledgeBaseEdit;
import scimat.gui.undostack.UndoStack;
import scimat.knowledgebaseevents.KnowledgeBaseEventsReceiver;
import scimat.model.knowledgebase.entity.Reference;
import scimat.model.knowledgebase.exception.KnowledgeBaseException;
import scimat.project.CurrentProject;

public class UpdateReferenceEdit
extends KnowledgeBaseEdit {
    private Integer referenceID;
    private String fullReference;
    private String volume;
    private String issue;
    private String page;
    private String year;
    private String doi;
    private String format;
    private Reference referenceOld;
    private Reference referenceUpdated;

    public UpdateReferenceEdit(Integer referenceID, String fullReference, String volume, String issue, String page, String year, String doi, String format) {
        this.referenceID = referenceID;
        this.fullReference = fullReference;
        this.volume = volume;
        this.issue = issue;
        this.page = page;
        this.year = year;
        this.doi = doi;
        this.format = format;
    }

    public boolean execute() throws KnowledgeBaseException {
        boolean successful = false;
        try {
            this.referenceOld = CurrentProject.getInstance().getFactoryDAO().getReferenceDAO().getReference(this.referenceID);
            if (this.referenceOld.getFullReference().equals(this.fullReference)) {
                successful = CurrentProject.getInstance().getFactoryDAO().getReferenceDAO().updateReference(this.referenceID, this.fullReference, this.volume, this.issue, this.page, this.year, this.doi, this.format, true);
                this.referenceUpdated = CurrentProject.getInstance().getFactoryDAO().getReferenceDAO().getReference(this.referenceID);
            } else if (this.fullReference == null) {
                successful = false;
                this.errorMessage = "The full reference can not be null.";
            } else if (CurrentProject.getInstance().getFactoryDAO().getReferenceDAO().checkReference(this.fullReference)) {
                successful = false;
                this.errorMessage = "A reference yet exists with this full reference.";
            } else {
                successful = CurrentProject.getInstance().getFactoryDAO().getReferenceDAO().updateReference(this.referenceID, this.fullReference, this.volume, this.issue, this.page, this.year, this.doi, this.format, true);
                this.referenceUpdated = CurrentProject.getInstance().getFactoryDAO().getReferenceDAO().getReference(this.referenceID);
            }
            if (successful) {
                CurrentProject.getInstance().getKnowledgeBase().commit();
                KnowledgeBaseEventsReceiver.getInstance().fireEvents();
                successful = true;
                UndoStack.addEdit(this);
            } else {
                CurrentProject.getInstance().getKnowledgeBase().rollback();
            }
        }
        catch (KnowledgeBaseException e) {
            CurrentProject.getInstance().getKnowledgeBase().rollback();
            successful = false;
            this.errorMessage = "An exception happened.";
            throw e;
        }
        return successful;
    }

    public void undo() throws CannotUndoException {
        super.undo();
        try {
            boolean flag = CurrentProject.getInstance().getFactoryDAO().getReferenceDAO().updateReference(this.referenceOld.getReferenceID(), this.referenceOld.getFullReference(), this.referenceOld.getVolume(), this.referenceOld.getIssue(), this.referenceOld.getPage(), this.referenceOld.getYear(), this.referenceOld.getDoi(), this.referenceOld.getFormat(), true);
            if (flag) {
                CurrentProject.getInstance().getKnowledgeBase().commit();
                KnowledgeBaseEventsReceiver.getInstance().fireEvents();
            } else {
                CurrentProject.getInstance().getKnowledgeBase().rollback();
            }
        }
        catch (KnowledgeBaseException e) {
            e.printStackTrace(System.err);
            try {
                CurrentProject.getInstance().getKnowledgeBase().rollback();
            }
            catch (KnowledgeBaseException e2) {
                e2.printStackTrace(System.err);
            }
        }
    }

    public void redo() throws CannotUndoException {
        super.redo();
        try {
            boolean flag = CurrentProject.getInstance().getFactoryDAO().getReferenceDAO().updateReference(this.referenceID, this.fullReference, this.volume, this.issue, this.page, this.year, this.doi, this.format, true);
            if (flag) {
                CurrentProject.getInstance().getKnowledgeBase().commit();
                KnowledgeBaseEventsReceiver.getInstance().fireEvents();
            } else {
                CurrentProject.getInstance().getKnowledgeBase().rollback();
            }
        }
        catch (KnowledgeBaseException e) {
            e.printStackTrace(System.err);
            try {
                CurrentProject.getInstance().getKnowledgeBase().rollback();
            }
            catch (KnowledgeBaseException e2) {
                e2.printStackTrace(System.err);
            }
        }
    }
}

