/*
 * Decompiled with CFR 0.152.
 */
package scimat.gui.commands.edit.update;

import javax.swing.undo.CannotUndoException;
import scimat.gui.commands.edit.KnowledgeBaseEdit;
import scimat.gui.undostack.UndoStack;
import scimat.knowledgebaseevents.KnowledgeBaseEventsReceiver;
import scimat.model.knowledgebase.entity.PublishDate;
import scimat.model.knowledgebase.exception.KnowledgeBaseException;
import scimat.project.CurrentProject;

public class UpdatePublishDateEdit
extends KnowledgeBaseEdit {
    private Integer publishDateID;
    private String year;
    private String date;
    private PublishDate publishDateOld;
    private PublishDate publishDateUpdated;

    public UpdatePublishDateEdit(Integer publishDateID, String year, String date) {
        this.publishDateID = publishDateID;
        this.year = year;
        this.date = date;
    }

    public boolean execute() throws KnowledgeBaseException {
        boolean successful = false;
        try {
            if (this.year == null || this.date == null) {
                successful = false;
                this.errorMessage = "The year and date can not be null.";
            } else if (CurrentProject.getInstance().getFactoryDAO().getPublishDateDAO().checkPublishDate(this.year, this.date)) {
                successful = false;
                this.errorMessage = "A Publish date yet exists with this year.";
            } else {
                this.publishDateOld = CurrentProject.getInstance().getFactoryDAO().getPublishDateDAO().getPublishDate(this.publishDateID);
                successful = CurrentProject.getInstance().getFactoryDAO().getPublishDateDAO().updatePublishDate(this.publishDateID, this.year, this.date, true);
                this.publishDateUpdated = CurrentProject.getInstance().getFactoryDAO().getPublishDateDAO().getPublishDate(this.publishDateID);
                if (successful) {
                    CurrentProject.getInstance().getKnowledgeBase().commit();
                    KnowledgeBaseEventsReceiver.getInstance().fireEvents();
                    successful = true;
                    UndoStack.addEdit(this);
                } else {
                    CurrentProject.getInstance().getKnowledgeBase().rollback();
                }
            }
        }
        catch (KnowledgeBaseException e) {
            CurrentProject.getInstance().getKnowledgeBase().rollback();
            successful = false;
            this.errorMessage = "An exception happened.";
            throw e;
        }
        return successful;
    }

    public void undo() throws CannotUndoException {
        super.undo();
        try {
            boolean flag = CurrentProject.getInstance().getFactoryDAO().getPublishDateDAO().updatePublishDate(this.publishDateOld.getPublishDateID(), this.publishDateOld.getYear(), this.publishDateOld.getYear(), true);
            if (flag) {
                CurrentProject.getInstance().getKnowledgeBase().commit();
                KnowledgeBaseEventsReceiver.getInstance().fireEvents();
            } else {
                CurrentProject.getInstance().getKnowledgeBase().rollback();
            }
        }
        catch (KnowledgeBaseException e) {
            e.printStackTrace(System.err);
            try {
                CurrentProject.getInstance().getKnowledgeBase().rollback();
            }
            catch (KnowledgeBaseException e2) {
                e2.printStackTrace(System.err);
            }
        }
    }

    public void redo() throws CannotUndoException {
        super.redo();
        try {
            boolean flag = CurrentProject.getInstance().getFactoryDAO().getPublishDateDAO().updatePublishDate(this.publishDateID, this.year, this.date, true);
            if (flag) {
                CurrentProject.getInstance().getKnowledgeBase().commit();
                KnowledgeBaseEventsReceiver.getInstance().fireEvents();
            } else {
                CurrentProject.getInstance().getKnowledgeBase().rollback();
            }
        }
        catch (KnowledgeBaseException e) {
            e.printStackTrace(System.err);
            try {
                CurrentProject.getInstance().getKnowledgeBase().rollback();
            }
            catch (KnowledgeBaseException e2) {
                e2.printStackTrace(System.err);
            }
        }
    }
}

