/*
 * Decompiled with CFR 0.152.
 */
package scimat.gui.commands.edit.update;

import javax.swing.undo.CannotUndoException;
import scimat.gui.commands.edit.KnowledgeBaseEdit;
import scimat.gui.undostack.UndoStack;
import scimat.knowledgebaseevents.KnowledgeBaseEventsReceiver;
import scimat.model.knowledgebase.entity.Period;
import scimat.model.knowledgebase.exception.KnowledgeBaseException;
import scimat.project.CurrentProject;

public class UpdatePeriodEdit
extends KnowledgeBaseEdit {
    private Integer periodID;
    private String name;
    private int position;
    private Period periodOld;
    private Period periodUpdated;

    public UpdatePeriodEdit(Integer periodID, String name, int position) {
        this.periodID = periodID;
        this.name = name;
        this.position = position;
    }

    public boolean execute() throws KnowledgeBaseException {
        boolean successful = false;
        try {
            this.periodOld = CurrentProject.getInstance().getFactoryDAO().getPeriodDAO().getPeriod(this.periodID);
            if (this.periodOld.getName().equals(this.name)) {
                successful = CurrentProject.getInstance().getFactoryDAO().getPeriodDAO().setPosition(this.periodID, this.position, true);
                this.periodUpdated = CurrentProject.getInstance().getFactoryDAO().getPeriodDAO().getPeriod(this.periodID);
            } else if (this.name == null) {
                successful = false;
                this.errorMessage = "The name can not be null.";
            } else if (CurrentProject.getInstance().getFactoryDAO().getPeriodDAO().checkPeriod(this.name)) {
                successful = false;
                this.errorMessage = "A period yet exists with this name.";
            } else {
                successful = CurrentProject.getInstance().getFactoryDAO().getPeriodDAO().setName(this.periodID, this.name, true);
                successful = CurrentProject.getInstance().getFactoryDAO().getPeriodDAO().setPosition(this.periodID, this.position, true);
                this.periodUpdated = CurrentProject.getInstance().getFactoryDAO().getPeriodDAO().getPeriod(this.periodID);
            }
            if (successful) {
                CurrentProject.getInstance().getKnowledgeBase().commit();
                KnowledgeBaseEventsReceiver.getInstance().fireEvents();
                successful = true;
                UndoStack.addEdit(this);
            } else {
                CurrentProject.getInstance().getKnowledgeBase().rollback();
            }
        }
        catch (KnowledgeBaseException e) {
            CurrentProject.getInstance().getKnowledgeBase().rollback();
            successful = false;
            this.errorMessage = "An exception happened.";
            throw e;
        }
        return successful;
    }

    public void undo() throws CannotUndoException {
        super.undo();
        try {
            boolean flag;
            if (this.periodOld.getName().equals(this.periodUpdated.getName())) {
                flag = CurrentProject.getInstance().getFactoryDAO().getPeriodDAO().setPosition(this.periodOld.getPeriodID(), this.periodOld.getPosition(), true);
            } else {
                flag = CurrentProject.getInstance().getFactoryDAO().getPeriodDAO().setName(this.periodOld.getPeriodID(), this.periodOld.getName(), true);
                flag = CurrentProject.getInstance().getFactoryDAO().getPeriodDAO().setPosition(this.periodOld.getPeriodID(), this.periodOld.getPosition(), true);
            }
            if (flag) {
                CurrentProject.getInstance().getKnowledgeBase().commit();
                KnowledgeBaseEventsReceiver.getInstance().fireEvents();
            } else {
                CurrentProject.getInstance().getKnowledgeBase().rollback();
            }
        }
        catch (KnowledgeBaseException e) {
            e.printStackTrace(System.err);
            try {
                CurrentProject.getInstance().getKnowledgeBase().rollback();
            }
            catch (KnowledgeBaseException e2) {
                e2.printStackTrace(System.err);
            }
        }
    }

    public void redo() throws CannotUndoException {
        super.redo();
        try {
            boolean flag;
            if (this.periodOld.getName().equals(this.name)) {
                flag = CurrentProject.getInstance().getFactoryDAO().getPeriodDAO().setPosition(this.periodID, this.position, true);
            } else {
                flag = CurrentProject.getInstance().getFactoryDAO().getPeriodDAO().setName(this.periodID, this.name, true);
                flag = CurrentProject.getInstance().getFactoryDAO().getPeriodDAO().setPosition(this.periodID, this.position, true);
            }
            if (flag) {
                CurrentProject.getInstance().getKnowledgeBase().commit();
                KnowledgeBaseEventsReceiver.getInstance().fireEvents();
            } else {
                CurrentProject.getInstance().getKnowledgeBase().rollback();
            }
        }
        catch (KnowledgeBaseException e) {
            e.printStackTrace(System.err);
            try {
                CurrentProject.getInstance().getKnowledgeBase().rollback();
            }
            catch (KnowledgeBaseException e2) {
                e2.printStackTrace(System.err);
            }
        }
    }
}

