/*
 * Decompiled with CFR 0.152.
 */
package scimat.gui.commands.edit.update;

import javax.swing.undo.CannotUndoException;
import scimat.gui.commands.edit.KnowledgeBaseEdit;
import scimat.gui.undostack.UndoStack;
import scimat.knowledgebaseevents.KnowledgeBaseEventsReceiver;
import scimat.model.knowledgebase.entity.Journal;
import scimat.model.knowledgebase.exception.KnowledgeBaseException;
import scimat.project.CurrentProject;

public class UpdateJournalEdit
extends KnowledgeBaseEdit {
    private Integer journalID;
    private String source;
    private String conferenceInformation;
    private Journal journalsOld;
    private Journal journalsUpdated;

    public UpdateJournalEdit(Integer journalID, String source, String conferenceInformation) {
        this.journalID = journalID;
        this.source = source;
        this.conferenceInformation = conferenceInformation;
    }

    public boolean execute() throws KnowledgeBaseException {
        boolean successful = false;
        try {
            this.journalsOld = CurrentProject.getInstance().getFactoryDAO().getJournalDAO().getJournal(this.journalID);
            if (this.journalsOld.getSource().equals(this.source)) {
                successful = CurrentProject.getInstance().getFactoryDAO().getJournalDAO().setConferenceInformation(this.journalID, this.conferenceInformation, true);
                this.journalsUpdated = CurrentProject.getInstance().getFactoryDAO().getJournalDAO().getJournal(this.journalID);
            } else if (this.source == null) {
                successful = false;
                this.errorMessage = "The source can not be null.";
            } else if (CurrentProject.getInstance().getFactoryDAO().getJournalDAO().checkJournal(this.source)) {
                successful = false;
                this.errorMessage = "A journal yet exists with this source.";
            } else {
                successful = CurrentProject.getInstance().getFactoryDAO().getJournalDAO().updateJournal(this.journalID, this.source, this.conferenceInformation, true);
                this.journalsUpdated = CurrentProject.getInstance().getFactoryDAO().getJournalDAO().getJournal(this.journalID);
            }
            if (successful) {
                CurrentProject.getInstance().getKnowledgeBase().commit();
                KnowledgeBaseEventsReceiver.getInstance().fireEvents();
                successful = true;
                UndoStack.addEdit(this);
            } else {
                CurrentProject.getInstance().getKnowledgeBase().rollback();
            }
        }
        catch (KnowledgeBaseException e) {
            CurrentProject.getInstance().getKnowledgeBase().rollback();
            successful = false;
            this.errorMessage = "An exception happened.";
            throw e;
        }
        return successful;
    }

    public void undo() throws CannotUndoException {
        super.undo();
        try {
            boolean flag = this.journalsOld.getSource().equals(this.journalsUpdated.getSource()) ? CurrentProject.getInstance().getFactoryDAO().getJournalDAO().setConferenceInformation(this.journalsOld.getJournalID(), this.journalsOld.getConferenceInformation(), true) : CurrentProject.getInstance().getFactoryDAO().getJournalDAO().updateJournal(this.journalsOld.getJournalID(), this.journalsOld.getSource(), this.journalsOld.getConferenceInformation(), true);
            if (flag) {
                CurrentProject.getInstance().getKnowledgeBase().commit();
                KnowledgeBaseEventsReceiver.getInstance().fireEvents();
            } else {
                CurrentProject.getInstance().getKnowledgeBase().rollback();
            }
        }
        catch (KnowledgeBaseException e) {
            e.printStackTrace(System.err);
            try {
                CurrentProject.getInstance().getKnowledgeBase().rollback();
            }
            catch (KnowledgeBaseException e2) {
                e2.printStackTrace(System.err);
            }
        }
    }

    public void redo() throws CannotUndoException {
        super.redo();
        try {
            boolean flag = this.journalsOld.getSource().equals(this.source) ? CurrentProject.getInstance().getFactoryDAO().getJournalDAO().setConferenceInformation(this.journalID, this.conferenceInformation, true) : CurrentProject.getInstance().getFactoryDAO().getJournalDAO().updateJournal(this.journalID, this.source, this.conferenceInformation, true);
            if (flag) {
                CurrentProject.getInstance().getKnowledgeBase().commit();
                KnowledgeBaseEventsReceiver.getInstance().fireEvents();
            } else {
                CurrentProject.getInstance().getKnowledgeBase().rollback();
            }
        }
        catch (KnowledgeBaseException e) {
            e.printStackTrace(System.err);
            try {
                CurrentProject.getInstance().getKnowledgeBase().rollback();
            }
            catch (KnowledgeBaseException e2) {
                e2.printStackTrace(System.err);
            }
        }
    }
}

