/*
 * Decompiled with CFR 0.152.
 */
package scimat.gui.commands.edit.update;

import javax.swing.undo.CannotUndoException;
import scimat.gui.commands.edit.KnowledgeBaseEdit;
import scimat.gui.undostack.UndoStack;
import scimat.knowledgebaseevents.KnowledgeBaseEventsReceiver;
import scimat.model.knowledgebase.dao.DocumentWordDAO;
import scimat.model.knowledgebase.entity.DocumentWord;
import scimat.model.knowledgebase.exception.KnowledgeBaseException;
import scimat.project.CurrentProject;

public class UpdateDocumentWordRolEdit
extends KnowledgeBaseEdit {
    private Integer documentID;
    private Integer wordID;
    private boolean authorKeyword;
    private boolean sourceKeyword;
    private boolean addedKeyword;
    private DocumentWord oldDocumentWord;

    public UpdateDocumentWordRolEdit(Integer documentID, Integer wordID, boolean authorKeyword, boolean sourceKeyword, boolean addedKeyword) {
        this.documentID = documentID;
        this.wordID = wordID;
        this.authorKeyword = authorKeyword;
        this.sourceKeyword = sourceKeyword;
        this.addedKeyword = addedKeyword;
    }

    public boolean execute() throws KnowledgeBaseException {
        boolean successful = true;
        try {
            DocumentWordDAO documentWordDAO = CurrentProject.getInstance().getFactoryDAO().getDocumentWordDAO();
            this.oldDocumentWord = documentWordDAO.getDocumentWord(this.documentID, this.wordID);
            successful = documentWordDAO.setAuthorKeyword(this.documentID, this.wordID, this.authorKeyword, true);
            successful = documentWordDAO.setSourceKeyword(this.documentID, this.wordID, this.sourceKeyword, true);
            successful = documentWordDAO.setAddedKeyword(this.documentID, this.wordID, this.addedKeyword, true);
            if (successful) {
                CurrentProject.getInstance().getKnowledgeBase().commit();
                KnowledgeBaseEventsReceiver.getInstance().fireEvents();
                UndoStack.addEdit(this);
            } else {
                CurrentProject.getInstance().getKnowledgeBase().rollback();
                this.errorMessage = "An error happened";
            }
        }
        catch (KnowledgeBaseException e) {
            CurrentProject.getInstance().getKnowledgeBase().rollback();
            successful = false;
            this.errorMessage = "An exception happened.";
            throw e;
        }
        return successful;
    }

    public void undo() throws CannotUndoException {
        super.undo();
        boolean successful = true;
        try {
            DocumentWordDAO documentWordDAO = CurrentProject.getInstance().getFactoryDAO().getDocumentWordDAO();
            successful = documentWordDAO.setAuthorKeyword(this.documentID, this.wordID, this.oldDocumentWord.isAuthorKeyword(), true);
            successful = documentWordDAO.setSourceKeyword(this.documentID, this.wordID, this.oldDocumentWord.isSourceKeyword(), true);
            successful = documentWordDAO.setAddedKeyword(this.documentID, this.wordID, this.oldDocumentWord.isAddedKeyword(), true);
            if (successful) {
                CurrentProject.getInstance().getKnowledgeBase().commit();
                KnowledgeBaseEventsReceiver.getInstance().fireEvents();
            } else {
                CurrentProject.getInstance().getKnowledgeBase().rollback();
            }
        }
        catch (KnowledgeBaseException e) {
            e.printStackTrace(System.err);
            try {
                CurrentProject.getInstance().getKnowledgeBase().rollback();
            }
            catch (KnowledgeBaseException e2) {
                e2.printStackTrace(System.err);
            }
        }
    }

    public void redo() throws CannotUndoException {
        super.redo();
        boolean successful = true;
        try {
            DocumentWordDAO documentWordDAO = CurrentProject.getInstance().getFactoryDAO().getDocumentWordDAO();
            successful = documentWordDAO.setAuthorKeyword(this.documentID, this.wordID, this.authorKeyword, true);
            successful = documentWordDAO.setSourceKeyword(this.documentID, this.wordID, this.sourceKeyword, true);
            successful = documentWordDAO.setAddedKeyword(this.documentID, this.wordID, this.addedKeyword, true);
            if (successful) {
                CurrentProject.getInstance().getKnowledgeBase().commit();
                KnowledgeBaseEventsReceiver.getInstance().fireEvents();
            } else {
                CurrentProject.getInstance().getKnowledgeBase().rollback();
            }
        }
        catch (KnowledgeBaseException e) {
            e.printStackTrace(System.err);
            try {
                CurrentProject.getInstance().getKnowledgeBase().rollback();
            }
            catch (KnowledgeBaseException e2) {
                e2.printStackTrace(System.err);
            }
        }
    }
}

