/*
 * Decompiled with CFR 0.152.
 */
package scimat.gui.commands.edit.update;

import javax.swing.undo.CannotUndoException;
import scimat.gui.commands.edit.KnowledgeBaseEdit;
import scimat.gui.undostack.UndoStack;
import scimat.knowledgebaseevents.KnowledgeBaseEventsReceiver;
import scimat.model.knowledgebase.entity.AuthorGroup;
import scimat.model.knowledgebase.exception.KnowledgeBaseException;
import scimat.project.CurrentProject;

public class UpdateAuthorGroupEdit
extends KnowledgeBaseEdit {
    private Integer authorGroupID;
    private String groupName;
    private boolean stopGroup;
    private AuthorGroup authorGroupOld;
    private AuthorGroup authorGroupUpdated;

    public UpdateAuthorGroupEdit(Integer authorGroupID, String groupName, boolean stopGroup) {
        this.authorGroupID = authorGroupID;
        this.groupName = groupName;
        this.stopGroup = stopGroup;
    }

    public boolean execute() throws KnowledgeBaseException {
        boolean successful = false;
        try {
            this.authorGroupOld = CurrentProject.getInstance().getFactoryDAO().getAuthorGroupDAO().getAuthorGroup(this.authorGroupID);
            if (this.authorGroupOld.getGroupName().equals(this.groupName)) {
                successful = CurrentProject.getInstance().getFactoryDAO().getAuthorGroupDAO().setStopGroup(this.authorGroupID, this.stopGroup, true);
                this.authorGroupUpdated = CurrentProject.getInstance().getFactoryDAO().getAuthorGroupDAO().getAuthorGroup(this.authorGroupID);
            } else if (this.groupName == null) {
                successful = false;
                this.errorMessage = "The name can not be null.";
            } else if (CurrentProject.getInstance().getFactoryDAO().getAuthorGroupDAO().checkAuthorGroup(this.groupName)) {
                successful = false;
                this.errorMessage = "An Author group yet exists with this name.";
            } else {
                successful = CurrentProject.getInstance().getFactoryDAO().getAuthorGroupDAO().updateAuthorGroup(this.authorGroupID, this.groupName, this.stopGroup, true);
                this.authorGroupUpdated = CurrentProject.getInstance().getFactoryDAO().getAuthorGroupDAO().getAuthorGroup(this.authorGroupID);
            }
            if (successful) {
                CurrentProject.getInstance().getKnowledgeBase().commit();
                KnowledgeBaseEventsReceiver.getInstance().fireEvents();
                successful = true;
                UndoStack.addEdit(this);
            } else {
                CurrentProject.getInstance().getKnowledgeBase().rollback();
                successful = false;
                this.errorMessage = "An error happened.";
            }
        }
        catch (KnowledgeBaseException e) {
            CurrentProject.getInstance().getKnowledgeBase().rollback();
            successful = false;
            this.errorMessage = "An exception happened.";
            throw e;
        }
        return successful;
    }

    public void undo() throws CannotUndoException {
        super.undo();
        try {
            boolean flag = this.authorGroupOld.getGroupName().equals(this.authorGroupUpdated.getGroupName()) ? CurrentProject.getInstance().getFactoryDAO().getAuthorGroupDAO().setStopGroup(this.authorGroupOld.getAuthorGroupID(), this.authorGroupOld.isStopGroup(), true) : CurrentProject.getInstance().getFactoryDAO().getAuthorGroupDAO().updateAuthorGroup(this.authorGroupOld.getAuthorGroupID(), this.authorGroupOld.getGroupName(), this.authorGroupOld.isStopGroup(), true);
            if (flag) {
                CurrentProject.getInstance().getKnowledgeBase().commit();
                KnowledgeBaseEventsReceiver.getInstance().fireEvents();
            } else {
                CurrentProject.getInstance().getKnowledgeBase().rollback();
            }
        }
        catch (KnowledgeBaseException e) {
            e.printStackTrace(System.err);
            try {
                CurrentProject.getInstance().getKnowledgeBase().rollback();
            }
            catch (KnowledgeBaseException e2) {
                e2.printStackTrace(System.err);
            }
        }
    }

    public void redo() throws CannotUndoException {
        super.redo();
        try {
            boolean flag = this.authorGroupOld.getGroupName().equals(this.groupName) ? CurrentProject.getInstance().getFactoryDAO().getAuthorGroupDAO().setStopGroup(this.authorGroupID, this.stopGroup, true) : CurrentProject.getInstance().getFactoryDAO().getAuthorGroupDAO().updateAuthorGroup(this.authorGroupID, this.groupName, this.stopGroup, true);
            if (flag) {
                CurrentProject.getInstance().getKnowledgeBase().commit();
                KnowledgeBaseEventsReceiver.getInstance().fireEvents();
            } else {
                CurrentProject.getInstance().getKnowledgeBase().rollback();
            }
        }
        catch (KnowledgeBaseException e) {
            e.printStackTrace(System.err);
            try {
                CurrentProject.getInstance().getKnowledgeBase().rollback();
            }
            catch (KnowledgeBaseException e2) {
                e2.printStackTrace(System.err);
            }
        }
    }
}

