/*
 * Decompiled with CFR 0.152.
 */
package scimat.gui.commands.edit.update;

import java.util.ArrayList;
import javax.swing.undo.CannotUndoException;
import scimat.gui.commands.edit.KnowledgeBaseEdit;
import scimat.gui.undostack.UndoStack;
import scimat.knowledgebaseevents.KnowledgeBaseEventsReceiver;
import scimat.model.knowledgebase.entity.Author;
import scimat.model.knowledgebase.exception.KnowledgeBaseException;
import scimat.project.CurrentProject;

public class UpdateAuthorEdit
extends KnowledgeBaseEdit {
    private Integer authorID;
    private String authorName;
    private String fullAuthorName;
    private ArrayList<Author> authorsUpdated;

    public UpdateAuthorEdit(Integer authorID, String authorName, String fullAuthorName) {
        this.authorID = authorID;
        this.authorName = authorName;
        this.fullAuthorName = fullAuthorName;
        this.authorsUpdated = new ArrayList();
    }

    public boolean execute() throws KnowledgeBaseException {
        boolean successful = false;
        try {
            if (this.authorName == null || this.fullAuthorName == null) {
                successful = false;
                this.errorMessage = "The name and full name can not be null.";
            } else if (CurrentProject.getInstance().getFactoryDAO().getAuthorDAO().checkAuthor(this.authorName, this.fullAuthorName)) {
                successful = false;
                this.errorMessage = "An Author yet exists with this name and full name.";
            } else {
                this.authorsUpdated.add(CurrentProject.getInstance().getFactoryDAO().getAuthorDAO().getAuthor(this.authorID));
                successful = CurrentProject.getInstance().getFactoryDAO().getAuthorDAO().updateAuthor(this.authorID, this.authorName, this.fullAuthorName, true);
                if (successful) {
                    CurrentProject.getInstance().getKnowledgeBase().commit();
                    KnowledgeBaseEventsReceiver.getInstance().fireEvents();
                    successful = true;
                    UndoStack.addEdit(this);
                } else {
                    CurrentProject.getInstance().getKnowledgeBase().rollback();
                    successful = false;
                    this.errorMessage = "An error happened.";
                }
            }
        }
        catch (KnowledgeBaseException e) {
            CurrentProject.getInstance().getKnowledgeBase().rollback();
            successful = false;
            this.errorMessage = "An exception happened.";
            throw e;
        }
        return successful;
    }

    public void undo() throws CannotUndoException {
        super.undo();
        try {
            Author author = this.authorsUpdated.get(0);
            boolean flag = CurrentProject.getInstance().getFactoryDAO().getAuthorDAO().updateAuthor(author.getAuthorID(), author.getAuthorName(), author.getFullAuthorName(), true);
            if (flag) {
                CurrentProject.getInstance().getKnowledgeBase().commit();
                KnowledgeBaseEventsReceiver.getInstance().fireEvents();
            } else {
                CurrentProject.getInstance().getKnowledgeBase().rollback();
            }
        }
        catch (KnowledgeBaseException e) {
            e.printStackTrace(System.err);
            try {
                CurrentProject.getInstance().getKnowledgeBase().rollback();
            }
            catch (KnowledgeBaseException e2) {
                e2.printStackTrace(System.err);
            }
        }
    }

    public void redo() throws CannotUndoException {
        super.redo();
        try {
            boolean flag = CurrentProject.getInstance().getFactoryDAO().getAuthorDAO().updateAuthor(this.authorID, this.authorName, this.fullAuthorName, true);
            if (flag) {
                CurrentProject.getInstance().getKnowledgeBase().commit();
                KnowledgeBaseEventsReceiver.getInstance().fireEvents();
            } else {
                CurrentProject.getInstance().getKnowledgeBase().rollback();
            }
        }
        catch (KnowledgeBaseException e) {
            e.printStackTrace(System.err);
            try {
                CurrentProject.getInstance().getKnowledgeBase().rollback();
            }
            catch (KnowledgeBaseException e2) {
                e2.printStackTrace(System.err);
            }
        }
    }
}

