/*
 * Decompiled with CFR 0.152.
 */
package scimat.gui.commands.edit.move;

import java.util.ArrayList;
import javax.swing.undo.CannotUndoException;
import scimat.gui.commands.edit.KnowledgeBaseEdit;
import scimat.gui.undostack.UndoStack;
import scimat.knowledgebaseevents.KnowledgeBaseEventsReceiver;
import scimat.model.knowledgebase.dao.WordDAO;
import scimat.model.knowledgebase.dao.WordGroupDAO;
import scimat.model.knowledgebase.entity.Word;
import scimat.model.knowledgebase.entity.WordGroup;
import scimat.model.knowledgebase.exception.KnowledgeBaseException;
import scimat.project.CurrentProject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MoveWordsToNewWordGroupEdit
extends KnowledgeBaseEdit {
    private ArrayList<Word> wordsToMove;
    private String groupName;
    private WordGroup wordGroup;
    private boolean groupNew;

    public MoveWordsToNewWordGroupEdit(ArrayList<Word> wordsToMove, String groupName) {
        this.wordsToMove = wordsToMove;
        this.groupName = groupName;
    }

    @Override
    public boolean execute() throws KnowledgeBaseException {
        boolean successful = true;
        try {
            WordGroupDAO wordGroupDAO = CurrentProject.getInstance().getFactoryDAO().getWordGroupDAO();
            WordDAO wordDAO = CurrentProject.getInstance().getFactoryDAO().getWordDAO();
            this.wordGroup = wordGroupDAO.getWordGroup(this.groupName);
            if (this.wordGroup == null) {
                this.groupNew = true;
                Integer wordGroupID = wordGroupDAO.addWordGroup(this.groupName, false, true);
                this.wordGroup = wordGroupDAO.getWordGroup(wordGroupID);
            } else {
                this.groupNew = false;
            }
            for (int i = 0; i < this.wordsToMove.size(); ++i) {
                Word word = this.wordsToMove.get(i);
                successful = wordDAO.setWordGroup(word.getWordID(), this.wordGroup.getWordGroupID(), true);
            }
            this.wordGroup = wordGroupDAO.getWordGroup(this.wordGroup.getWordGroupID());
            if (successful) {
                CurrentProject.getInstance().getKnowledgeBase().commit();
                KnowledgeBaseEventsReceiver.getInstance().fireEvents();
                UndoStack.addEdit(this);
            } else {
                CurrentProject.getInstance().getKnowledgeBase().rollback();
                this.errorMessage = "An error happened";
            }
        }
        catch (KnowledgeBaseException e) {
            CurrentProject.getInstance().getKnowledgeBase().rollback();
            successful = false;
            this.errorMessage = "An exception happened.";
            throw e;
        }
        return successful;
    }

    @Override
    public void undo() throws CannotUndoException {
        super.undo();
        boolean successful = true;
        try {
            WordGroupDAO wordGroupDAO = CurrentProject.getInstance().getFactoryDAO().getWordGroupDAO();
            WordDAO wordDAO = CurrentProject.getInstance().getFactoryDAO().getWordDAO();
            for (int i = 0; i < this.wordsToMove.size(); ++i) {
                successful = wordDAO.setWordGroup(this.wordsToMove.get(i).getWordID(), null, true);
            }
            if (this.groupNew) {
                successful = wordGroupDAO.removeWordGroup(this.wordGroup.getWordGroupID(), true);
            }
            if (successful) {
                CurrentProject.getInstance().getKnowledgeBase().commit();
                KnowledgeBaseEventsReceiver.getInstance().fireEvents();
            } else {
                CurrentProject.getInstance().getKnowledgeBase().rollback();
            }
        }
        catch (KnowledgeBaseException e) {
            e.printStackTrace(System.err);
            try {
                CurrentProject.getInstance().getKnowledgeBase().rollback();
            }
            catch (KnowledgeBaseException e2) {
                e2.printStackTrace(System.err);
            }
        }
    }

    @Override
    public void redo() throws CannotUndoException {
        super.redo();
        boolean successful = true;
        try {
            WordGroupDAO wordGroupDAO = CurrentProject.getInstance().getFactoryDAO().getWordGroupDAO();
            WordDAO wordDAO = CurrentProject.getInstance().getFactoryDAO().getWordDAO();
            if (this.groupNew) {
                successful = wordGroupDAO.addWordGroup(this.wordGroup, true);
            }
            for (int i = 0; i < this.wordsToMove.size(); ++i) {
                successful = wordDAO.setWordGroup(this.wordsToMove.get(i).getWordID(), this.wordGroup.getWordGroupID(), true);
            }
            if (successful) {
                CurrentProject.getInstance().getKnowledgeBase().commit();
                KnowledgeBaseEventsReceiver.getInstance().fireEvents();
            } else {
                CurrentProject.getInstance().getKnowledgeBase().rollback();
            }
        }
        catch (KnowledgeBaseException e) {
            e.printStackTrace(System.err);
            try {
                CurrentProject.getInstance().getKnowledgeBase().rollback();
            }
            catch (KnowledgeBaseException e2) {
                e2.printStackTrace(System.err);
            }
        }
    }
}

