/*
 * Decompiled with CFR 0.152.
 */
package scimat.gui.commands.edit.move;

import java.util.ArrayList;
import javax.swing.undo.CannotUndoException;
import scimat.gui.commands.edit.KnowledgeBaseEdit;
import scimat.gui.undostack.UndoStack;
import scimat.knowledgebaseevents.KnowledgeBaseEventsReceiver;
import scimat.model.knowledgebase.dao.ReferenceDAO;
import scimat.model.knowledgebase.dao.ReferenceGroupDAO;
import scimat.model.knowledgebase.entity.Reference;
import scimat.model.knowledgebase.entity.ReferenceGroup;
import scimat.model.knowledgebase.exception.KnowledgeBaseException;
import scimat.project.CurrentProject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MoveReferencesToNewReferenceGroupEdit
extends KnowledgeBaseEdit {
    private ArrayList<Reference> referencesToMove;
    private String groupName;
    private ReferenceGroup referenceGroup;
    private boolean groupNew;

    public MoveReferencesToNewReferenceGroupEdit(ArrayList<Reference> referencesToMove, String groupName) {
        this.referencesToMove = referencesToMove;
        this.groupName = groupName;
    }

    @Override
    public boolean execute() throws KnowledgeBaseException {
        boolean successful = true;
        try {
            ReferenceGroupDAO referenceGroupDAO = CurrentProject.getInstance().getFactoryDAO().getReferenceGroupDAO();
            ReferenceDAO referenceDAO = CurrentProject.getInstance().getFactoryDAO().getReferenceDAO();
            this.referenceGroup = referenceGroupDAO.getReferenceGroup(this.groupName);
            if (this.referenceGroup == null) {
                this.groupNew = true;
                Integer referenceGroupID = referenceGroupDAO.addReferenceGroup(this.groupName, false, true);
                this.referenceGroup = referenceGroupDAO.getReferenceGroup(referenceGroupID);
            } else {
                this.groupNew = false;
            }
            for (int i = 0; i < this.referencesToMove.size(); ++i) {
                Reference reference = this.referencesToMove.get(i);
                successful = referenceDAO.setReferenceGroup(reference.getReferenceID(), this.referenceGroup.getReferenceGroupID(), true);
            }
            if (successful) {
                CurrentProject.getInstance().getKnowledgeBase().commit();
                KnowledgeBaseEventsReceiver.getInstance().fireEvents();
                UndoStack.addEdit(this);
            } else {
                CurrentProject.getInstance().getKnowledgeBase().rollback();
                this.errorMessage = "An error happened";
            }
        }
        catch (KnowledgeBaseException e) {
            CurrentProject.getInstance().getKnowledgeBase().rollback();
            successful = false;
            this.errorMessage = "An exception happened.";
            throw e;
        }
        return successful;
    }

    @Override
    public void undo() throws CannotUndoException {
        super.undo();
        boolean successful = true;
        try {
            ReferenceGroupDAO referenceGroupDAO = CurrentProject.getInstance().getFactoryDAO().getReferenceGroupDAO();
            ReferenceDAO referenceDAO = CurrentProject.getInstance().getFactoryDAO().getReferenceDAO();
            for (int i = 0; i < this.referencesToMove.size(); ++i) {
                successful = referenceDAO.setReferenceGroup(this.referencesToMove.get(i).getReferenceID(), null, true);
            }
            if (this.groupNew) {
                successful = referenceGroupDAO.removeReferenceGroup(this.referenceGroup.getReferenceGroupID(), true);
            }
            if (successful) {
                CurrentProject.getInstance().getKnowledgeBase().commit();
                KnowledgeBaseEventsReceiver.getInstance().fireEvents();
            } else {
                CurrentProject.getInstance().getKnowledgeBase().rollback();
            }
        }
        catch (KnowledgeBaseException e) {
            e.printStackTrace(System.err);
            try {
                CurrentProject.getInstance().getKnowledgeBase().rollback();
            }
            catch (KnowledgeBaseException e2) {
                e2.printStackTrace(System.err);
            }
        }
    }

    @Override
    public void redo() throws CannotUndoException {
        super.redo();
        boolean successful = true;
        try {
            ReferenceGroupDAO referenceGroupDAO = CurrentProject.getInstance().getFactoryDAO().getReferenceGroupDAO();
            ReferenceDAO referenceDAO = CurrentProject.getInstance().getFactoryDAO().getReferenceDAO();
            if (this.groupNew) {
                successful = referenceGroupDAO.addReferenceGroup(this.referenceGroup, true);
            }
            for (int i = 0; i < this.referencesToMove.size(); ++i) {
                successful = referenceDAO.setReferenceGroup(this.referencesToMove.get(i).getReferenceID(), this.referenceGroup.getReferenceGroupID(), true);
            }
            if (successful) {
                CurrentProject.getInstance().getKnowledgeBase().commit();
                KnowledgeBaseEventsReceiver.getInstance().fireEvents();
            } else {
                CurrentProject.getInstance().getKnowledgeBase().rollback();
            }
        }
        catch (KnowledgeBaseException e) {
            e.printStackTrace(System.err);
            try {
                CurrentProject.getInstance().getKnowledgeBase().rollback();
            }
            catch (KnowledgeBaseException e2) {
                e2.printStackTrace(System.err);
            }
        }
    }
}

