/*
 * Decompiled with CFR 0.152.
 */
package scimat.gui.commands.edit.move;

import java.util.ArrayList;
import javax.swing.undo.CannotUndoException;
import scimat.gui.commands.edit.KnowledgeBaseEdit;
import scimat.gui.undostack.UndoStack;
import scimat.knowledgebaseevents.KnowledgeBaseEventsReceiver;
import scimat.model.knowledgebase.dao.AuthorDAO;
import scimat.model.knowledgebase.dao.AuthorGroupDAO;
import scimat.model.knowledgebase.entity.Author;
import scimat.model.knowledgebase.entity.AuthorGroup;
import scimat.model.knowledgebase.exception.KnowledgeBaseException;
import scimat.project.CurrentProject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MoveAuthorToDifferentAuthorGroupEdit
extends KnowledgeBaseEdit {
    private ArrayList<Author> authorsToMove;
    private AuthorGroup[] authorGroups;
    private ArrayList<AuthorGroup> authorGroupsAdded;
    private boolean[] groupNew;

    public MoveAuthorToDifferentAuthorGroupEdit(ArrayList<Author> authorsToMove) {
        this.authorsToMove = authorsToMove;
    }

    @Override
    public boolean execute() throws KnowledgeBaseException {
        boolean successful = true;
        try {
            AuthorGroupDAO authorGroupDAO = CurrentProject.getInstance().getFactoryDAO().getAuthorGroupDAO();
            AuthorDAO authorDAO = CurrentProject.getInstance().getFactoryDAO().getAuthorDAO();
            this.authorGroups = new AuthorGroup[this.authorsToMove.size()];
            this.groupNew = new boolean[this.authorsToMove.size()];
            this.authorGroupsAdded = new ArrayList();
            for (int i = 0; i < this.authorsToMove.size(); ++i) {
                Author author = this.authorsToMove.get(i);
                AuthorGroup authorGroup = authorGroupDAO.getAuthorGroup(author.getAuthorName());
                if (authorGroup == null) {
                    this.groupNew[i] = true;
                    Integer authorGroupID = authorGroupDAO.addAuthorGroup(author.getAuthorName(), false, true);
                    authorGroup = authorGroupDAO.getAuthorGroup(authorGroupID);
                    this.authorGroupsAdded.add(authorGroup);
                } else {
                    this.groupNew[i] = false;
                }
                this.authorGroups[i] = authorGroup;
                successful = authorDAO.setAuthorGroup(author.getAuthorID(), authorGroup.getAuthorGroupID(), true);
            }
            if (successful) {
                CurrentProject.getInstance().getKnowledgeBase().commit();
                KnowledgeBaseEventsReceiver.getInstance().fireEvents();
                UndoStack.addEdit(this);
            } else {
                CurrentProject.getInstance().getKnowledgeBase().rollback();
                this.errorMessage = "An error happened";
            }
        }
        catch (KnowledgeBaseException e) {
            CurrentProject.getInstance().getKnowledgeBase().rollback();
            successful = false;
            this.errorMessage = "An exception happened.";
            throw e;
        }
        return successful;
    }

    @Override
    public void undo() throws CannotUndoException {
        super.undo();
        boolean successful = true;
        try {
            AuthorGroupDAO authorGroupDAO = CurrentProject.getInstance().getFactoryDAO().getAuthorGroupDAO();
            AuthorDAO authorDAO = CurrentProject.getInstance().getFactoryDAO().getAuthorDAO();
            for (int i = 0; i < this.authorsToMove.size(); ++i) {
                successful = authorDAO.setAuthorGroup(this.authorsToMove.get(i).getAuthorID(), null, true);
                if (!this.groupNew[i]) continue;
                successful = authorGroupDAO.removeAuthorGroup(this.authorGroups[i].getAuthorGroupID(), true);
            }
            if (successful) {
                CurrentProject.getInstance().getKnowledgeBase().commit();
                KnowledgeBaseEventsReceiver.getInstance().fireEvents();
            } else {
                CurrentProject.getInstance().getKnowledgeBase().rollback();
            }
        }
        catch (KnowledgeBaseException e) {
            e.printStackTrace(System.err);
            try {
                CurrentProject.getInstance().getKnowledgeBase().rollback();
            }
            catch (KnowledgeBaseException e2) {
                e2.printStackTrace(System.err);
            }
        }
    }

    @Override
    public void redo() throws CannotUndoException {
        super.redo();
        boolean successful = true;
        try {
            AuthorGroupDAO authorGroupDAO = CurrentProject.getInstance().getFactoryDAO().getAuthorGroupDAO();
            AuthorDAO authorDAO = CurrentProject.getInstance().getFactoryDAO().getAuthorDAO();
            for (int i = 0; i < this.authorsToMove.size(); ++i) {
                if (this.groupNew[i]) {
                    successful = authorGroupDAO.addAuthorGroup(this.authorGroups[i], true);
                }
                successful = authorDAO.setAuthorGroup(this.authorsToMove.get(i).getAuthorID(), this.authorGroups[i].getAuthorGroupID(), true);
            }
            if (successful) {
                CurrentProject.getInstance().getKnowledgeBase().commit();
                KnowledgeBaseEventsReceiver.getInstance().fireEvents();
            } else {
                CurrentProject.getInstance().getKnowledgeBase().rollback();
            }
        }
        catch (KnowledgeBaseException e) {
            e.printStackTrace(System.err);
            try {
                CurrentProject.getInstance().getKnowledgeBase().rollback();
            }
            catch (KnowledgeBaseException e2) {
                e2.printStackTrace(System.err);
            }
        }
    }
}

