/*
 * Decompiled with CFR 0.152.
 */
package scimat.gui.commands.edit.move;

import java.util.ArrayList;
import javax.swing.undo.CannotUndoException;
import scimat.gui.commands.edit.KnowledgeBaseEdit;
import scimat.gui.undostack.UndoStack;
import scimat.knowledgebaseevents.KnowledgeBaseEventsReceiver;
import scimat.model.knowledgebase.dao.AuthorReferenceDAO;
import scimat.model.knowledgebase.dao.AuthorReferenceGroupDAO;
import scimat.model.knowledgebase.entity.AuthorReference;
import scimat.model.knowledgebase.entity.AuthorReferenceGroup;
import scimat.model.knowledgebase.exception.KnowledgeBaseException;
import scimat.project.CurrentProject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MoveAuthorReferencesToNewAuthorReferenceGroupEdit
extends KnowledgeBaseEdit {
    private ArrayList<AuthorReference> authorReferencesToMove;
    private String groupName;
    private AuthorReferenceGroup authorReferenceGroup;
    private boolean groupNew;

    public MoveAuthorReferencesToNewAuthorReferenceGroupEdit(ArrayList<AuthorReference> authorReferencesToMove, String groupName) {
        this.authorReferencesToMove = authorReferencesToMove;
        this.groupName = groupName;
    }

    @Override
    public boolean execute() throws KnowledgeBaseException {
        boolean successful = true;
        try {
            AuthorReferenceGroupDAO authorReferenceGroupDAO = CurrentProject.getInstance().getFactoryDAO().getAuthorReferenceGroupDAO();
            AuthorReferenceDAO authorReferenceDAO = CurrentProject.getInstance().getFactoryDAO().getAuthorReferenceDAO();
            this.authorReferenceGroup = authorReferenceGroupDAO.getAuthorReferenceGroup(this.groupName);
            if (this.authorReferenceGroup == null) {
                this.groupNew = true;
                Integer authorReferenceGroupID = authorReferenceGroupDAO.addAuthorReferenceGroup(this.groupName, false, true);
                this.authorReferenceGroup = authorReferenceGroupDAO.getAuthorReferenceGroup(authorReferenceGroupID);
            } else {
                this.groupNew = false;
            }
            for (int i = 0; i < this.authorReferencesToMove.size(); ++i) {
                AuthorReference authorReference = this.authorReferencesToMove.get(i);
                successful = authorReferenceDAO.setAuthorReferenceGroup(authorReference.getAuthorReferenceID(), this.authorReferenceGroup.getAuthorReferenceGroupID(), true);
            }
            if (successful) {
                CurrentProject.getInstance().getKnowledgeBase().commit();
                KnowledgeBaseEventsReceiver.getInstance().fireEvents();
                UndoStack.addEdit(this);
            } else {
                CurrentProject.getInstance().getKnowledgeBase().rollback();
                this.errorMessage = "An error happened";
            }
        }
        catch (KnowledgeBaseException e) {
            CurrentProject.getInstance().getKnowledgeBase().rollback();
            successful = false;
            this.errorMessage = "An exception happened.";
            throw e;
        }
        return successful;
    }

    @Override
    public void undo() throws CannotUndoException {
        super.undo();
        boolean successful = true;
        try {
            AuthorReferenceGroupDAO authorReferenceGroupDAO = CurrentProject.getInstance().getFactoryDAO().getAuthorReferenceGroupDAO();
            AuthorReferenceDAO authorReferenceDAO = CurrentProject.getInstance().getFactoryDAO().getAuthorReferenceDAO();
            for (int i = 0; i < this.authorReferencesToMove.size(); ++i) {
                successful = authorReferenceDAO.setAuthorReferenceGroup(this.authorReferencesToMove.get(i).getAuthorReferenceID(), null, true);
            }
            if (this.groupNew) {
                successful = authorReferenceGroupDAO.removeAuthorReferenceGroup(this.authorReferenceGroup.getAuthorReferenceGroupID(), true);
            }
            if (successful) {
                CurrentProject.getInstance().getKnowledgeBase().commit();
                KnowledgeBaseEventsReceiver.getInstance().fireEvents();
            } else {
                CurrentProject.getInstance().getKnowledgeBase().rollback();
            }
        }
        catch (KnowledgeBaseException e) {
            e.printStackTrace(System.err);
            try {
                CurrentProject.getInstance().getKnowledgeBase().rollback();
            }
            catch (KnowledgeBaseException e2) {
                e2.printStackTrace(System.err);
            }
        }
    }

    @Override
    public void redo() throws CannotUndoException {
        super.redo();
        boolean successful = true;
        try {
            AuthorReferenceGroupDAO authorReferenceGroupDAO = CurrentProject.getInstance().getFactoryDAO().getAuthorReferenceGroupDAO();
            AuthorReferenceDAO authorReferenceDAO = CurrentProject.getInstance().getFactoryDAO().getAuthorReferenceDAO();
            if (this.groupNew) {
                successful = authorReferenceGroupDAO.addAuthorReferenceGroup(this.authorReferenceGroup, true);
            }
            for (int i = 0; i < this.authorReferencesToMove.size(); ++i) {
                successful = authorReferenceDAO.setAuthorReferenceGroup(this.authorReferencesToMove.get(i).getAuthorReferenceID(), this.authorReferenceGroup.getAuthorReferenceGroupID(), true);
            }
            if (successful) {
                CurrentProject.getInstance().getKnowledgeBase().commit();
                KnowledgeBaseEventsReceiver.getInstance().fireEvents();
            } else {
                CurrentProject.getInstance().getKnowledgeBase().rollback();
            }
        }
        catch (KnowledgeBaseException e) {
            e.printStackTrace(System.err);
            try {
                CurrentProject.getInstance().getKnowledgeBase().rollback();
            }
            catch (KnowledgeBaseException e2) {
                e2.printStackTrace(System.err);
            }
        }
    }
}

