/*
 * Decompiled with CFR 0.152.
 */
package scimat.gui.commands.edit.join;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.TreeSet;
import javax.swing.undo.CannotUndoException;
import scimat.gui.commands.edit.KnowledgeBaseEdit;
import scimat.gui.undostack.UndoStack;
import scimat.knowledgebaseevents.KnowledgeBaseEventsReceiver;
import scimat.model.knowledgebase.dao.WordDAO;
import scimat.model.knowledgebase.dao.WordGroupDAO;
import scimat.model.knowledgebase.entity.Word;
import scimat.model.knowledgebase.entity.WordGroup;
import scimat.model.knowledgebase.exception.KnowledgeBaseException;
import scimat.project.CurrentProject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JoinWordGroupEdit
extends KnowledgeBaseEdit {
    private ArrayList<WordGroup> wordGroupsToMove;
    private WordGroup targetWordGroup;
    private ArrayList<ArrayList<Word>> wordsOfSources = new ArrayList();
    private TreeSet<Word> wordsOfTarget = new TreeSet();

    public JoinWordGroupEdit(ArrayList<WordGroup> wordGroupsToMove, WordGroup targetWordGroup) {
        this.wordGroupsToMove = wordGroupsToMove;
        this.targetWordGroup = targetWordGroup;
    }

    @Override
    public boolean execute() throws KnowledgeBaseException {
        boolean successful = true;
        try {
            WordDAO wordDAO = CurrentProject.getInstance().getFactoryDAO().getWordDAO();
            WordGroupDAO wordGroupDAO = CurrentProject.getInstance().getFactoryDAO().getWordGroupDAO();
            this.wordsOfTarget = new TreeSet<Word>(wordGroupDAO.getWords(this.targetWordGroup.getWordGroupID()));
            for (int i = 0; i < this.wordGroupsToMove.size() && successful; ++i) {
                WordGroup wordGroup = this.wordGroupsToMove.get(i);
                ArrayList<Word> words = wordGroupDAO.getWords(wordGroup.getWordGroupID());
                this.wordsOfSources.add(words);
                successful = wordGroupDAO.removeWordGroup(wordGroup.getWordGroupID(), true);
                for (int j = 0; j < words.size() && successful; ++j) {
                    successful = wordDAO.setWordGroup(words.get(j).getWordID(), this.targetWordGroup.getWordGroupID(), true);
                }
            }
            if (successful) {
                CurrentProject.getInstance().getKnowledgeBase().commit();
                KnowledgeBaseEventsReceiver.getInstance().fireEvents();
                UndoStack.addEdit(this);
            } else {
                CurrentProject.getInstance().getKnowledgeBase().rollback();
                this.errorMessage = "An error happened";
            }
        }
        catch (KnowledgeBaseException e) {
            CurrentProject.getInstance().getKnowledgeBase().rollback();
            successful = false;
            this.errorMessage = "An exception happened.";
            throw e;
        }
        return successful;
    }

    @Override
    public void undo() throws CannotUndoException {
        super.undo();
        boolean successful = true;
        try {
            WordGroupDAO wordGroupDAO = CurrentProject.getInstance().getFactoryDAO().getWordGroupDAO();
            WordDAO wordDAO = CurrentProject.getInstance().getFactoryDAO().getWordDAO();
            TreeSet<Word> tmpWords = new TreeSet<Word>(wordGroupDAO.getWords(this.targetWordGroup.getWordGroupID()));
            tmpWords.removeAll(this.wordsOfTarget);
            Iterator<Word> itWord = tmpWords.iterator();
            while (itWord.hasNext() && successful) {
                successful = wordDAO.setWordGroup(itWord.next().getWordID(), null, true);
            }
            for (int i = 0; i < this.wordGroupsToMove.size() && successful; ++i) {
                WordGroup wordGroup = this.wordGroupsToMove.get(i);
                successful = wordGroupDAO.addWordGroup(wordGroup, true);
                for (int j = 0; j < this.wordsOfSources.get(i).size() && successful; ++j) {
                    Word word = this.wordsOfSources.get(i).get(j);
                    successful = wordDAO.setWordGroup(word.getWordID(), wordGroup.getWordGroupID(), true);
                }
            }
            if (successful) {
                CurrentProject.getInstance().getKnowledgeBase().commit();
                KnowledgeBaseEventsReceiver.getInstance().fireEvents();
            } else {
                CurrentProject.getInstance().getKnowledgeBase().rollback();
            }
        }
        catch (KnowledgeBaseException e) {
            e.printStackTrace(System.err);
            try {
                CurrentProject.getInstance().getKnowledgeBase().rollback();
            }
            catch (KnowledgeBaseException e2) {
                e2.printStackTrace(System.err);
            }
        }
    }

    @Override
    public void redo() throws CannotUndoException {
        super.redo();
        boolean successful = true;
        try {
            WordDAO wordDAO = CurrentProject.getInstance().getFactoryDAO().getWordDAO();
            WordGroupDAO wordGroupDAO = CurrentProject.getInstance().getFactoryDAO().getWordGroupDAO();
            for (int i = 0; i < this.wordGroupsToMove.size() && successful; ++i) {
                WordGroup wordGroup = this.wordGroupsToMove.get(i);
                ArrayList<Word> words = this.wordsOfSources.get(i);
                successful = wordGroupDAO.removeWordGroup(wordGroup.getWordGroupID(), true);
                for (int j = 0; j < words.size() && successful; ++j) {
                    successful = wordDAO.setWordGroup(words.get(j).getWordID(), this.targetWordGroup.getWordGroupID(), true);
                }
            }
            if (successful) {
                CurrentProject.getInstance().getKnowledgeBase().commit();
                KnowledgeBaseEventsReceiver.getInstance().fireEvents();
                UndoStack.addEdit(this);
            } else {
                CurrentProject.getInstance().getKnowledgeBase().rollback();
            }
        }
        catch (KnowledgeBaseException e) {
            e.printStackTrace(System.err);
            try {
                CurrentProject.getInstance().getKnowledgeBase().rollback();
            }
            catch (KnowledgeBaseException e2) {
                e2.printStackTrace(System.err);
            }
        }
    }
}

