/*
 * Decompiled with CFR 0.152.
 */
package scimat.gui.commands.edit.join;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.TreeSet;
import javax.swing.undo.CannotUndoException;
import scimat.gui.commands.edit.KnowledgeBaseEdit;
import scimat.gui.undostack.UndoStack;
import scimat.knowledgebaseevents.KnowledgeBaseEventsReceiver;
import scimat.model.knowledgebase.dao.DocumentWordDAO;
import scimat.model.knowledgebase.dao.WordDAO;
import scimat.model.knowledgebase.entity.DocumentWord;
import scimat.model.knowledgebase.entity.Word;
import scimat.model.knowledgebase.entity.WordGroup;
import scimat.model.knowledgebase.exception.KnowledgeBaseException;
import scimat.project.CurrentProject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JoinWordEdit
extends KnowledgeBaseEdit {
    private ArrayList<Word> wordsToMove;
    private Word targetWord;
    private ArrayList<ArrayList<DocumentWord>> documentWordOfSources = new ArrayList();
    private ArrayList<WordGroup> wordGroupOfSources = new ArrayList();
    private TreeSet<DocumentWord> documentWordOfTarget = new TreeSet();

    public JoinWordEdit(ArrayList<Word> wordsToMove, Word targetWord) {
        this.wordsToMove = wordsToMove;
        this.targetWord = targetWord;
    }

    @Override
    public boolean execute() throws KnowledgeBaseException {
        boolean successful = true;
        try {
            WordDAO wordDAO = CurrentProject.getInstance().getFactoryDAO().getWordDAO();
            DocumentWordDAO documentWordDAO = CurrentProject.getInstance().getFactoryDAO().getDocumentWordDAO();
            this.documentWordOfTarget = new TreeSet<DocumentWord>(wordDAO.getDocumentWords(this.targetWord.getWordID()));
            for (int i = 0; i < this.wordsToMove.size() && successful; ++i) {
                Word word = this.wordsToMove.get(i);
                ArrayList<DocumentWord> documentWords = wordDAO.getDocumentWords(word.getWordID());
                this.documentWordOfSources.add(documentWords);
                this.wordGroupOfSources.add(wordDAO.getWordGroup(word.getWordID()));
                successful = wordDAO.removeWord(word.getWordID(), true);
                for (int j = 0; j < documentWords.size() && successful; ++j) {
                    DocumentWord documentWord = documentWords.get(j);
                    if (documentWordDAO.checkDocumentWord(documentWord.getDocument().getDocumentID(), this.targetWord.getWordID())) continue;
                    successful = documentWordDAO.addDocumentWord(documentWord.getDocument().getDocumentID(), this.targetWord.getWordID(), documentWord.isAuthorKeyword(), documentWord.isSourceKeyword(), documentWord.isAddedKeyword(), true);
                }
            }
            if (successful) {
                CurrentProject.getInstance().getKnowledgeBase().commit();
                KnowledgeBaseEventsReceiver.getInstance().fireEvents();
                UndoStack.addEdit(this);
            } else {
                CurrentProject.getInstance().getKnowledgeBase().rollback();
                this.errorMessage = "An error happened";
            }
        }
        catch (KnowledgeBaseException e) {
            CurrentProject.getInstance().getKnowledgeBase().rollback();
            successful = false;
            this.errorMessage = "An exception happened.";
            throw e;
        }
        return successful;
    }

    @Override
    public void undo() throws CannotUndoException {
        super.undo();
        boolean successful = true;
        try {
            WordDAO wordDAO = CurrentProject.getInstance().getFactoryDAO().getWordDAO();
            DocumentWordDAO documentWordDAO = CurrentProject.getInstance().getFactoryDAO().getDocumentWordDAO();
            TreeSet<DocumentWord> tmpDocumentWords = new TreeSet<DocumentWord>(wordDAO.getDocumentWords(this.targetWord.getWordID()));
            tmpDocumentWords.removeAll(this.documentWordOfTarget);
            Iterator<DocumentWord> itDocumentWord = tmpDocumentWords.iterator();
            while (itDocumentWord.hasNext() && successful) {
                successful = documentWordDAO.removeDocumentWord(itDocumentWord.next().getDocument().getDocumentID(), this.targetWord.getWordID(), true);
            }
            for (int i = 0; i < this.wordsToMove.size() && successful; ++i) {
                Word word = this.wordsToMove.get(i);
                successful = wordDAO.addWord(word, true);
                for (int j = 0; j < this.documentWordOfSources.get(i).size() && successful; ++j) {
                    DocumentWord documentWord = this.documentWordOfSources.get(i).get(j);
                    successful = documentWordDAO.addDocumentWord(documentWord.getDocument().getDocumentID(), word.getWordID(), documentWord.isAuthorKeyword(), documentWord.isSourceKeyword(), documentWord.isAddedKeyword(), true);
                }
                if (this.wordGroupOfSources.get(i) == null || !successful) continue;
                successful = wordDAO.setWordGroup(word.getWordID(), this.wordGroupOfSources.get(i).getWordGroupID(), true);
            }
            if (successful) {
                CurrentProject.getInstance().getKnowledgeBase().commit();
                KnowledgeBaseEventsReceiver.getInstance().fireEvents();
            } else {
                CurrentProject.getInstance().getKnowledgeBase().rollback();
            }
        }
        catch (KnowledgeBaseException e) {
            e.printStackTrace(System.err);
            try {
                CurrentProject.getInstance().getKnowledgeBase().rollback();
            }
            catch (KnowledgeBaseException e2) {
                e2.printStackTrace(System.err);
            }
        }
    }

    @Override
    public void redo() throws CannotUndoException {
        super.redo();
        boolean successful = true;
        try {
            WordDAO wordDAO = CurrentProject.getInstance().getFactoryDAO().getWordDAO();
            DocumentWordDAO documentWordDAO = CurrentProject.getInstance().getFactoryDAO().getDocumentWordDAO();
            for (int i = 0; i < this.wordsToMove.size() && successful; ++i) {
                Word word = this.wordsToMove.get(i);
                ArrayList<DocumentWord> documentWords = this.documentWordOfSources.get(i);
                successful = wordDAO.removeWord(word.getWordID(), true);
                for (int j = 0; j < documentWords.size() && successful; ++j) {
                    DocumentWord documentWord = documentWords.get(j);
                    if (documentWordDAO.checkDocumentWord(documentWord.getDocument().getDocumentID(), this.targetWord.getWordID())) continue;
                    successful = documentWordDAO.addDocumentWord(documentWord.getDocument().getDocumentID(), this.targetWord.getWordID(), documentWord.isAuthorKeyword(), documentWord.isSourceKeyword(), documentWord.isAddedKeyword(), true);
                }
            }
            if (successful) {
                CurrentProject.getInstance().getKnowledgeBase().commit();
                KnowledgeBaseEventsReceiver.getInstance().fireEvents();
            } else {
                CurrentProject.getInstance().getKnowledgeBase().rollback();
            }
        }
        catch (KnowledgeBaseException e) {
            e.printStackTrace(System.err);
            try {
                CurrentProject.getInstance().getKnowledgeBase().rollback();
            }
            catch (KnowledgeBaseException e2) {
                e2.printStackTrace(System.err);
            }
        }
    }
}

