/*
 * Decompiled with CFR 0.152.
 */
package scimat.gui.commands.edit.join;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.TreeSet;
import javax.swing.undo.CannotUndoException;
import scimat.gui.commands.edit.KnowledgeBaseEdit;
import scimat.gui.undostack.UndoStack;
import scimat.knowledgebaseevents.KnowledgeBaseEventsReceiver;
import scimat.model.knowledgebase.dao.JournalSubjectCategoryPublishDateDAO;
import scimat.model.knowledgebase.dao.SubjectCategoryDAO;
import scimat.model.knowledgebase.entity.JournalSubjectCategoryPublishDate;
import scimat.model.knowledgebase.entity.SubjectCategory;
import scimat.model.knowledgebase.exception.KnowledgeBaseException;
import scimat.project.CurrentProject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JoinSubjectCategoryEdit
extends KnowledgeBaseEdit {
    private ArrayList<SubjectCategory> subjectCategoriesToMove;
    private SubjectCategory targetSubjectCategory;
    private ArrayList<ArrayList<JournalSubjectCategoryPublishDate>> journalSubjectCategoryPublishDatesOfSources = new ArrayList();
    private TreeSet<JournalSubjectCategoryPublishDate> journalSubjectCategoryPublishDatesOfTarget = new TreeSet();

    public JoinSubjectCategoryEdit(ArrayList<SubjectCategory> subjectCategoriesToMove, SubjectCategory targetSubjectCategory) {
        this.subjectCategoriesToMove = subjectCategoriesToMove;
        this.targetSubjectCategory = targetSubjectCategory;
    }

    @Override
    public boolean execute() throws KnowledgeBaseException {
        boolean successful = true;
        try {
            SubjectCategoryDAO subjectCategoryDAO = CurrentProject.getInstance().getFactoryDAO().getSubjectCategoryDAO();
            JournalSubjectCategoryPublishDateDAO journalSubjectCategoryPublishDateDAO = CurrentProject.getInstance().getFactoryDAO().getJournalSubjectCategoryPublishDateDAO();
            this.journalSubjectCategoryPublishDatesOfTarget = new TreeSet<JournalSubjectCategoryPublishDate>(subjectCategoryDAO.getJournals(this.targetSubjectCategory.getSubjectCategoryID()));
            for (int i = 0; i < this.subjectCategoriesToMove.size() && successful; ++i) {
                SubjectCategory subjectCategory = this.subjectCategoriesToMove.get(i);
                ArrayList<JournalSubjectCategoryPublishDate> journalSubjectCategoryPublishDates = subjectCategoryDAO.getJournals(subjectCategory.getSubjectCategoryID());
                this.journalSubjectCategoryPublishDatesOfSources.add(journalSubjectCategoryPublishDates);
                successful = subjectCategoryDAO.removeSubjectCategory(subjectCategory.getSubjectCategoryID(), true);
                for (int j = 0; j < journalSubjectCategoryPublishDates.size() && successful; ++j) {
                    JournalSubjectCategoryPublishDate journalSubjectCategoryPublishDate = journalSubjectCategoryPublishDates.get(j);
                    if (journalSubjectCategoryPublishDateDAO.checkJournalSubjectCategoryPublishDate(journalSubjectCategoryPublishDate.getJournal().getJournalID(), this.targetSubjectCategory.getSubjectCategoryID(), journalSubjectCategoryPublishDate.getPublishDate().getPublishDateID())) continue;
                    successful = journalSubjectCategoryPublishDateDAO.addSubjectCategoryToJournal(journalSubjectCategoryPublishDate.getJournal().getJournalID(), this.targetSubjectCategory.getSubjectCategoryID(), journalSubjectCategoryPublishDate.getPublishDate().getPublishDateID(), true);
                }
            }
            if (successful) {
                CurrentProject.getInstance().getKnowledgeBase().commit();
                KnowledgeBaseEventsReceiver.getInstance().fireEvents();
                UndoStack.addEdit(this);
            } else {
                CurrentProject.getInstance().getKnowledgeBase().rollback();
                this.errorMessage = "An error happened";
            }
        }
        catch (KnowledgeBaseException e) {
            CurrentProject.getInstance().getKnowledgeBase().rollback();
            successful = false;
            this.errorMessage = "An exception happened.";
            throw e;
        }
        return successful;
    }

    @Override
    public void undo() throws CannotUndoException {
        super.undo();
        boolean successful = true;
        try {
            JournalSubjectCategoryPublishDate journalSubjectCategoryPublishDate;
            SubjectCategoryDAO subjectCategoryDAO = CurrentProject.getInstance().getFactoryDAO().getSubjectCategoryDAO();
            JournalSubjectCategoryPublishDateDAO journalSubjectCategoryPublishDateDAO = CurrentProject.getInstance().getFactoryDAO().getJournalSubjectCategoryPublishDateDAO();
            TreeSet<JournalSubjectCategoryPublishDate> tmpJournalSubjectCategoryPublishDates = new TreeSet<JournalSubjectCategoryPublishDate>(subjectCategoryDAO.getJournals(this.targetSubjectCategory.getSubjectCategoryID()));
            tmpJournalSubjectCategoryPublishDates.removeAll(this.journalSubjectCategoryPublishDatesOfTarget);
            Iterator<JournalSubjectCategoryPublishDate> itJournalSubjectCategoryPublishDate = tmpJournalSubjectCategoryPublishDates.iterator();
            while (itJournalSubjectCategoryPublishDate.hasNext() && successful) {
                journalSubjectCategoryPublishDate = itJournalSubjectCategoryPublishDate.next();
                successful = journalSubjectCategoryPublishDateDAO.removeSubjectCategoryFromJournal(this.targetSubjectCategory.getSubjectCategoryID(), journalSubjectCategoryPublishDate.getJournal().getJournalID(), journalSubjectCategoryPublishDate.getPublishDate().getPublishDateID(), true);
            }
            for (int i = 0; i < this.subjectCategoriesToMove.size() && successful; ++i) {
                SubjectCategory subjectCategory = this.subjectCategoriesToMove.get(i);
                successful = subjectCategoryDAO.addSubjectCategory(subjectCategory, true);
                for (int j = 0; j < this.journalSubjectCategoryPublishDatesOfSources.get(i).size() && successful; ++j) {
                    journalSubjectCategoryPublishDate = this.journalSubjectCategoryPublishDatesOfSources.get(i).get(j);
                    successful = journalSubjectCategoryPublishDateDAO.addSubjectCategoryToJournal(subjectCategory.getSubjectCategoryID(), journalSubjectCategoryPublishDate.getJournal().getJournalID(), journalSubjectCategoryPublishDate.getPublishDate().getPublishDateID(), true);
                }
            }
            if (successful) {
                CurrentProject.getInstance().getKnowledgeBase().commit();
                KnowledgeBaseEventsReceiver.getInstance().fireEvents();
            } else {
                CurrentProject.getInstance().getKnowledgeBase().rollback();
            }
        }
        catch (KnowledgeBaseException e) {
            e.printStackTrace(System.err);
            try {
                CurrentProject.getInstance().getKnowledgeBase().rollback();
            }
            catch (KnowledgeBaseException e2) {
                e2.printStackTrace(System.err);
            }
        }
    }

    @Override
    public void redo() throws CannotUndoException {
        super.redo();
        boolean successful = true;
        try {
            SubjectCategoryDAO subjectCategoryDAO = CurrentProject.getInstance().getFactoryDAO().getSubjectCategoryDAO();
            JournalSubjectCategoryPublishDateDAO journalSubjectCategoryPublishDateDAO = CurrentProject.getInstance().getFactoryDAO().getJournalSubjectCategoryPublishDateDAO();
            for (int i = 0; i < this.subjectCategoriesToMove.size() && successful; ++i) {
                SubjectCategory subjectCategory = this.subjectCategoriesToMove.get(i);
                ArrayList<JournalSubjectCategoryPublishDate> journalSubjectCategoryPublishDates = this.journalSubjectCategoryPublishDatesOfSources.get(i);
                successful = subjectCategoryDAO.removeSubjectCategory(subjectCategory.getSubjectCategoryID(), true);
                for (int j = 0; j < journalSubjectCategoryPublishDates.size() && successful; ++j) {
                    JournalSubjectCategoryPublishDate journalSubjectCategoryPublishDate = journalSubjectCategoryPublishDates.get(j);
                    if (journalSubjectCategoryPublishDateDAO.checkJournalSubjectCategoryPublishDate(journalSubjectCategoryPublishDate.getJournal().getJournalID(), this.targetSubjectCategory.getSubjectCategoryID(), journalSubjectCategoryPublishDate.getPublishDate().getPublishDateID())) continue;
                    successful = journalSubjectCategoryPublishDateDAO.addSubjectCategoryToJournal(journalSubjectCategoryPublishDate.getJournal().getJournalID(), this.targetSubjectCategory.getSubjectCategoryID(), journalSubjectCategoryPublishDate.getPublishDate().getPublishDateID(), true);
                }
            }
            if (successful) {
                CurrentProject.getInstance().getKnowledgeBase().commit();
            } else {
                CurrentProject.getInstance().getKnowledgeBase().rollback();
            }
        }
        catch (KnowledgeBaseException e) {
            e.printStackTrace(System.err);
            try {
                CurrentProject.getInstance().getKnowledgeBase().rollback();
            }
            catch (KnowledgeBaseException e2) {
                e2.printStackTrace(System.err);
            }
        }
    }
}

