/*
 * Decompiled with CFR 0.152.
 */
package scimat.gui.commands.edit.join;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.TreeSet;
import javax.swing.undo.CannotUndoException;
import scimat.gui.commands.edit.KnowledgeBaseEdit;
import scimat.gui.undostack.UndoStack;
import scimat.knowledgebaseevents.KnowledgeBaseEventsReceiver;
import scimat.model.knowledgebase.dao.ReferenceSourceDAO;
import scimat.model.knowledgebase.dao.ReferenceSourceGroupDAO;
import scimat.model.knowledgebase.entity.ReferenceSource;
import scimat.model.knowledgebase.entity.ReferenceSourceGroup;
import scimat.model.knowledgebase.exception.KnowledgeBaseException;
import scimat.project.CurrentProject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JoinReferenceSourceGroupEdit
extends KnowledgeBaseEdit {
    private ArrayList<ReferenceSourceGroup> referenceSourceGroupsToMove;
    private ReferenceSourceGroup targetReferenceSourceGroup;
    private ArrayList<ArrayList<ReferenceSource>> referenceSourcesOfSources = new ArrayList();
    private TreeSet<ReferenceSource> referenceSourcesOfTarget = new TreeSet();

    public JoinReferenceSourceGroupEdit(ArrayList<ReferenceSourceGroup> referenceSourceGroupsToMove, ReferenceSourceGroup targetReferenceSourceGroup) {
        this.referenceSourceGroupsToMove = referenceSourceGroupsToMove;
        this.targetReferenceSourceGroup = targetReferenceSourceGroup;
    }

    @Override
    public boolean execute() throws KnowledgeBaseException {
        boolean successful = true;
        try {
            ReferenceSourceDAO referenceSourceDAO = CurrentProject.getInstance().getFactoryDAO().getReferenceSourceDAO();
            ReferenceSourceGroupDAO referenceSourceGroupDAO = CurrentProject.getInstance().getFactoryDAO().getReferenceSourceGroupDAO();
            this.referenceSourcesOfTarget = new TreeSet<ReferenceSource>(referenceSourceGroupDAO.getReferenceSources(this.targetReferenceSourceGroup.getReferenceSourceGroupID()));
            for (int i = 0; i < this.referenceSourceGroupsToMove.size() && successful; ++i) {
                ReferenceSourceGroup referenceSourceGroup = this.referenceSourceGroupsToMove.get(i);
                ArrayList<ReferenceSource> referenceSources = referenceSourceGroupDAO.getReferenceSources(referenceSourceGroup.getReferenceSourceGroupID());
                this.referenceSourcesOfSources.add(referenceSources);
                successful = referenceSourceGroupDAO.removeReferenceSourceGroup(referenceSourceGroup.getReferenceSourceGroupID(), true);
                for (int j = 0; j < referenceSources.size() && successful; ++j) {
                    successful = referenceSourceDAO.setReferenceSourceGroup(referenceSources.get(j).getReferenceSourceID(), this.targetReferenceSourceGroup.getReferenceSourceGroupID(), true);
                }
            }
            if (successful) {
                CurrentProject.getInstance().getKnowledgeBase().commit();
                KnowledgeBaseEventsReceiver.getInstance().fireEvents();
                UndoStack.addEdit(this);
            } else {
                CurrentProject.getInstance().getKnowledgeBase().rollback();
                this.errorMessage = "An error happened";
            }
        }
        catch (KnowledgeBaseException e) {
            CurrentProject.getInstance().getKnowledgeBase().rollback();
            successful = false;
            this.errorMessage = "An exception happened.";
            throw e;
        }
        return successful;
    }

    @Override
    public void undo() throws CannotUndoException {
        super.undo();
        boolean successful = true;
        try {
            ReferenceSourceGroupDAO referenceSourceGroupDAO = CurrentProject.getInstance().getFactoryDAO().getReferenceSourceGroupDAO();
            ReferenceSourceDAO referenceSourceDAO = CurrentProject.getInstance().getFactoryDAO().getReferenceSourceDAO();
            TreeSet<ReferenceSource> tmpReferenceSources = new TreeSet<ReferenceSource>(referenceSourceGroupDAO.getReferenceSources(this.targetReferenceSourceGroup.getReferenceSourceGroupID()));
            tmpReferenceSources.removeAll(this.referenceSourcesOfTarget);
            Iterator<ReferenceSource> itReferenceSource = tmpReferenceSources.iterator();
            while (itReferenceSource.hasNext() && successful) {
                successful = referenceSourceDAO.setReferenceSourceGroup(itReferenceSource.next().getReferenceSourceID(), null, true);
            }
            for (int i = 0; i < this.referenceSourceGroupsToMove.size() && successful; ++i) {
                ReferenceSourceGroup referenceSourceGroup = this.referenceSourceGroupsToMove.get(i);
                successful = referenceSourceGroupDAO.addReferenceSourceGroup(referenceSourceGroup, true);
                for (int j = 0; j < this.referenceSourcesOfSources.get(i).size() && successful; ++j) {
                    ReferenceSource referenceSource = this.referenceSourcesOfSources.get(i).get(j);
                    successful = referenceSourceDAO.setReferenceSourceGroup(referenceSource.getReferenceSourceID(), referenceSourceGroup.getReferenceSourceGroupID(), true);
                }
            }
            if (successful) {
                CurrentProject.getInstance().getKnowledgeBase().commit();
                KnowledgeBaseEventsReceiver.getInstance().fireEvents();
            } else {
                CurrentProject.getInstance().getKnowledgeBase().rollback();
            }
        }
        catch (KnowledgeBaseException e) {
            e.printStackTrace(System.err);
            try {
                CurrentProject.getInstance().getKnowledgeBase().rollback();
            }
            catch (KnowledgeBaseException e2) {
                e2.printStackTrace(System.err);
            }
        }
    }

    @Override
    public void redo() throws CannotUndoException {
        super.redo();
        boolean successful = true;
        try {
            ReferenceSourceDAO referenceSourceDAO = CurrentProject.getInstance().getFactoryDAO().getReferenceSourceDAO();
            ReferenceSourceGroupDAO referenceSourceGroupDAO = CurrentProject.getInstance().getFactoryDAO().getReferenceSourceGroupDAO();
            for (int i = 0; i < this.referenceSourceGroupsToMove.size() && successful; ++i) {
                ReferenceSourceGroup referenceSourceGroup = this.referenceSourceGroupsToMove.get(i);
                ArrayList<ReferenceSource> referenceSources = this.referenceSourcesOfSources.get(i);
                successful = referenceSourceGroupDAO.removeReferenceSourceGroup(referenceSourceGroup.getReferenceSourceGroupID(), true);
                for (int j = 0; j < referenceSources.size() && successful; ++j) {
                    successful = referenceSourceDAO.setReferenceSourceGroup(referenceSources.get(j).getReferenceSourceID(), this.targetReferenceSourceGroup.getReferenceSourceGroupID(), true);
                }
            }
            if (successful) {
                CurrentProject.getInstance().getKnowledgeBase().commit();
                KnowledgeBaseEventsReceiver.getInstance().fireEvents();
                UndoStack.addEdit(this);
            } else {
                CurrentProject.getInstance().getKnowledgeBase().rollback();
            }
        }
        catch (KnowledgeBaseException e) {
            e.printStackTrace(System.err);
            try {
                CurrentProject.getInstance().getKnowledgeBase().rollback();
            }
            catch (KnowledgeBaseException e2) {
                e2.printStackTrace(System.err);
            }
        }
    }
}

