/*
 * Decompiled with CFR 0.152.
 */
package scimat.gui.commands.edit.join;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.TreeSet;
import javax.swing.undo.CannotUndoException;
import scimat.gui.commands.edit.KnowledgeBaseEdit;
import scimat.gui.undostack.UndoStack;
import scimat.knowledgebaseevents.KnowledgeBaseEventsReceiver;
import scimat.model.knowledgebase.dao.ReferenceDAO;
import scimat.model.knowledgebase.dao.ReferenceSourceDAO;
import scimat.model.knowledgebase.entity.Reference;
import scimat.model.knowledgebase.entity.ReferenceSource;
import scimat.model.knowledgebase.entity.ReferenceSourceGroup;
import scimat.model.knowledgebase.exception.KnowledgeBaseException;
import scimat.project.CurrentProject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JoinReferenceSourceEdit
extends KnowledgeBaseEdit {
    private ArrayList<ReferenceSource> referenceSourcesToMove;
    private ReferenceSource targetReferenceSource;
    private ArrayList<ReferenceSourceGroup> referenceSourceGroupOfSources = new ArrayList();
    private ArrayList<ArrayList<Reference>> referencesOfSources = new ArrayList();
    private TreeSet<Reference> referencesOfTarget = new TreeSet();

    public JoinReferenceSourceEdit(ArrayList<ReferenceSource> referenceSourcesToMove, ReferenceSource targetReferenceSource) {
        this.referenceSourcesToMove = referenceSourcesToMove;
        this.targetReferenceSource = targetReferenceSource;
    }

    @Override
    public boolean execute() throws KnowledgeBaseException {
        boolean successful = true;
        try {
            ReferenceSourceDAO referenceSourceDAO = CurrentProject.getInstance().getFactoryDAO().getReferenceSourceDAO();
            ReferenceDAO referenceDAO = CurrentProject.getInstance().getFactoryDAO().getReferenceDAO();
            this.referencesOfTarget = new TreeSet<Reference>(referenceSourceDAO.getReferences(this.targetReferenceSource.getReferenceSourceID()));
            for (int i = 0; i < this.referenceSourcesToMove.size() && successful; ++i) {
                ReferenceSource referenceSource = this.referenceSourcesToMove.get(i);
                ArrayList<Reference> references = referenceSourceDAO.getReferences(referenceSource.getReferenceSourceID());
                this.referenceSourceGroupOfSources.add(referenceSourceDAO.getReferenceSourceGroup(referenceSource.getReferenceSourceID()));
                successful = referenceSourceDAO.removeReferenceSource(referenceSource.getReferenceSourceID(), true);
                for (int j = 0; j < references.size() && successful; ++j) {
                    successful = referenceDAO.setReferenceSource(references.get(j).getReferenceID(), this.targetReferenceSource.getReferenceSourceID(), true);
                }
            }
            if (successful) {
                CurrentProject.getInstance().getKnowledgeBase().commit();
                KnowledgeBaseEventsReceiver.getInstance().fireEvents();
                UndoStack.addEdit(this);
            } else {
                CurrentProject.getInstance().getKnowledgeBase().rollback();
                this.errorMessage = "An error happened";
            }
        }
        catch (KnowledgeBaseException e) {
            CurrentProject.getInstance().getKnowledgeBase().rollback();
            successful = false;
            this.errorMessage = "An exception happened.";
            throw e;
        }
        return successful;
    }

    @Override
    public void undo() throws CannotUndoException {
        super.undo();
        boolean successful = true;
        try {
            ReferenceSourceDAO referenceSourceDAO = CurrentProject.getInstance().getFactoryDAO().getReferenceSourceDAO();
            ReferenceDAO referenceDAO = CurrentProject.getInstance().getFactoryDAO().getReferenceDAO();
            TreeSet<Reference> tmpReference = new TreeSet<Reference>(referenceSourceDAO.getReferences(this.targetReferenceSource.getReferenceSourceID()));
            tmpReference.removeAll(this.referencesOfTarget);
            Iterator<Reference> itReference = tmpReference.iterator();
            while (itReference.hasNext() && successful) {
                successful = referenceDAO.setReferenceSource(itReference.next().getReferenceID(), null, true);
            }
            for (int i = 0; i < this.referenceSourcesToMove.size() && successful; ++i) {
                ReferenceSource referenceSource = this.referenceSourcesToMove.get(i);
                successful = referenceSourceDAO.addReferenceSource(referenceSource, true);
                for (int j = 0; j < this.referencesOfSources.get(i).size() && successful; ++j) {
                    Reference reference = this.referencesOfSources.get(i).get(j);
                    successful = referenceDAO.setReferenceSource(reference.getReferenceID(), referenceSource.getReferenceSourceID(), true);
                }
                if (this.referenceSourceGroupOfSources.get(i) == null || !successful) continue;
                successful = referenceSourceDAO.setReferenceSourceGroup(referenceSource.getReferenceSourceID(), this.referenceSourceGroupOfSources.get(i).getReferenceSourceGroupID(), true);
            }
            if (successful) {
                CurrentProject.getInstance().getKnowledgeBase().commit();
                KnowledgeBaseEventsReceiver.getInstance().fireEvents();
            } else {
                CurrentProject.getInstance().getKnowledgeBase().rollback();
            }
        }
        catch (KnowledgeBaseException e) {
            e.printStackTrace(System.err);
            try {
                CurrentProject.getInstance().getKnowledgeBase().rollback();
            }
            catch (KnowledgeBaseException e2) {
                e2.printStackTrace(System.err);
            }
        }
    }

    @Override
    public void redo() throws CannotUndoException {
        super.redo();
        boolean successful = true;
        try {
            ReferenceSourceDAO referenceSourceDAO = CurrentProject.getInstance().getFactoryDAO().getReferenceSourceDAO();
            ReferenceDAO referenceDAO = CurrentProject.getInstance().getFactoryDAO().getReferenceDAO();
            for (int i = 0; i < this.referenceSourcesToMove.size() && successful; ++i) {
                ReferenceSource referenceSource = this.referenceSourcesToMove.get(i);
                ArrayList<Reference> references = this.referencesOfSources.get(i);
                successful = referenceSourceDAO.removeReferenceSource(referenceSource.getReferenceSourceID(), true);
                for (int j = 0; j < references.size() && successful; ++j) {
                    successful = referenceDAO.setReferenceSource(references.get(j).getReferenceID(), this.targetReferenceSource.getReferenceSourceID(), true);
                }
            }
            if (successful) {
                CurrentProject.getInstance().getKnowledgeBase().commit();
                KnowledgeBaseEventsReceiver.getInstance().fireEvents();
            } else {
                CurrentProject.getInstance().getKnowledgeBase().rollback();
            }
        }
        catch (KnowledgeBaseException e) {
            e.printStackTrace(System.err);
            try {
                CurrentProject.getInstance().getKnowledgeBase().rollback();
            }
            catch (KnowledgeBaseException e2) {
                e2.printStackTrace(System.err);
            }
        }
    }
}

