/*
 * Decompiled with CFR 0.152.
 */
package scimat.gui.commands.edit.join;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.TreeSet;
import javax.swing.undo.CannotUndoException;
import scimat.gui.commands.edit.KnowledgeBaseEdit;
import scimat.gui.undostack.UndoStack;
import scimat.knowledgebaseevents.KnowledgeBaseEventsReceiver;
import scimat.model.knowledgebase.dao.ReferenceDAO;
import scimat.model.knowledgebase.dao.ReferenceGroupDAO;
import scimat.model.knowledgebase.entity.Reference;
import scimat.model.knowledgebase.entity.ReferenceGroup;
import scimat.model.knowledgebase.exception.KnowledgeBaseException;
import scimat.project.CurrentProject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JoinReferenceGroupEdit
extends KnowledgeBaseEdit {
    private ArrayList<ReferenceGroup> referenceGroupsToMove;
    private ReferenceGroup targetReferenceGroup;
    private ArrayList<ArrayList<Reference>> referencesOfSources = new ArrayList();
    private TreeSet<Reference> referencesOfTarget = new TreeSet();

    public JoinReferenceGroupEdit(ArrayList<ReferenceGroup> referenceGroupsToMove, ReferenceGroup targetReferenceGroup) {
        this.referenceGroupsToMove = referenceGroupsToMove;
        this.targetReferenceGroup = targetReferenceGroup;
    }

    @Override
    public boolean execute() throws KnowledgeBaseException {
        boolean successful = true;
        try {
            ReferenceDAO referenceDAO = CurrentProject.getInstance().getFactoryDAO().getReferenceDAO();
            ReferenceGroupDAO referenceGroupDAO = CurrentProject.getInstance().getFactoryDAO().getReferenceGroupDAO();
            this.referencesOfTarget = new TreeSet<Reference>(referenceGroupDAO.getReferences(this.targetReferenceGroup.getReferenceGroupID()));
            for (int i = 0; i < this.referenceGroupsToMove.size() && successful; ++i) {
                ReferenceGroup referenceGroup = this.referenceGroupsToMove.get(i);
                ArrayList<Reference> references = referenceGroupDAO.getReferences(referenceGroup.getReferenceGroupID());
                this.referencesOfSources.add(references);
                successful = referenceGroupDAO.removeReferenceGroup(referenceGroup.getReferenceGroupID(), true);
                for (int j = 0; j < references.size() && successful; ++j) {
                    successful = referenceDAO.setReferenceGroup(references.get(j).getReferenceID(), this.targetReferenceGroup.getReferenceGroupID(), true);
                }
            }
            if (successful) {
                CurrentProject.getInstance().getKnowledgeBase().commit();
                KnowledgeBaseEventsReceiver.getInstance().fireEvents();
                UndoStack.addEdit(this);
            } else {
                CurrentProject.getInstance().getKnowledgeBase().rollback();
                this.errorMessage = "An error happened";
            }
        }
        catch (KnowledgeBaseException e) {
            CurrentProject.getInstance().getKnowledgeBase().rollback();
            successful = false;
            this.errorMessage = "An exception happened.";
            throw e;
        }
        return successful;
    }

    @Override
    public void undo() throws CannotUndoException {
        super.undo();
        boolean successful = true;
        try {
            ReferenceGroupDAO referenceGroupDAO = CurrentProject.getInstance().getFactoryDAO().getReferenceGroupDAO();
            ReferenceDAO referenceDAO = CurrentProject.getInstance().getFactoryDAO().getReferenceDAO();
            TreeSet<Reference> tmpReferences = new TreeSet<Reference>(referenceGroupDAO.getReferences(this.targetReferenceGroup.getReferenceGroupID()));
            tmpReferences.removeAll(this.referencesOfTarget);
            Iterator<Reference> itReference = tmpReferences.iterator();
            while (itReference.hasNext() && successful) {
                successful = referenceDAO.setReferenceGroup(itReference.next().getReferenceID(), null, true);
            }
            for (int i = 0; i < this.referenceGroupsToMove.size() && successful; ++i) {
                ReferenceGroup referenceGroup = this.referenceGroupsToMove.get(i);
                successful = referenceGroupDAO.addReferenceGroup(referenceGroup, true);
                for (int j = 0; j < this.referencesOfSources.get(i).size() && successful; ++j) {
                    Reference reference = this.referencesOfSources.get(i).get(j);
                    successful = referenceDAO.setReferenceGroup(reference.getReferenceID(), referenceGroup.getReferenceGroupID(), true);
                }
            }
            if (successful) {
                CurrentProject.getInstance().getKnowledgeBase().commit();
                KnowledgeBaseEventsReceiver.getInstance().fireEvents();
            } else {
                CurrentProject.getInstance().getKnowledgeBase().rollback();
            }
        }
        catch (KnowledgeBaseException e) {
            e.printStackTrace(System.err);
            try {
                CurrentProject.getInstance().getKnowledgeBase().rollback();
            }
            catch (KnowledgeBaseException e2) {
                e2.printStackTrace(System.err);
            }
        }
    }

    @Override
    public void redo() throws CannotUndoException {
        super.redo();
        boolean successful = true;
        try {
            ReferenceDAO referenceDAO = CurrentProject.getInstance().getFactoryDAO().getReferenceDAO();
            ReferenceGroupDAO referenceGroupDAO = CurrentProject.getInstance().getFactoryDAO().getReferenceGroupDAO();
            for (int i = 0; i < this.referenceGroupsToMove.size() && successful; ++i) {
                ReferenceGroup referenceGroup = this.referenceGroupsToMove.get(i);
                ArrayList<Reference> references = this.referencesOfSources.get(i);
                successful = referenceGroupDAO.removeReferenceGroup(referenceGroup.getReferenceGroupID(), true);
                for (int j = 0; j < references.size() && successful; ++j) {
                    successful = referenceDAO.setReferenceGroup(references.get(j).getReferenceID(), this.targetReferenceGroup.getReferenceGroupID(), true);
                }
            }
            if (successful) {
                CurrentProject.getInstance().getKnowledgeBase().commit();
                KnowledgeBaseEventsReceiver.getInstance().fireEvents();
                UndoStack.addEdit(this);
            } else {
                CurrentProject.getInstance().getKnowledgeBase().rollback();
            }
        }
        catch (KnowledgeBaseException e) {
            e.printStackTrace(System.err);
            try {
                CurrentProject.getInstance().getKnowledgeBase().rollback();
            }
            catch (KnowledgeBaseException e2) {
                e2.printStackTrace(System.err);
            }
        }
    }
}

