/*
 * Decompiled with CFR 0.152.
 */
package scimat.gui.commands.edit.join;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.TreeSet;
import javax.swing.undo.CannotUndoException;
import scimat.gui.commands.edit.KnowledgeBaseEdit;
import scimat.gui.undostack.UndoStack;
import scimat.knowledgebaseevents.KnowledgeBaseEventsReceiver;
import scimat.model.knowledgebase.dao.AuthorReferenceReferenceDAO;
import scimat.model.knowledgebase.dao.DocumentReferenceDAO;
import scimat.model.knowledgebase.dao.ReferenceDAO;
import scimat.model.knowledgebase.entity.AuthorReferenceReference;
import scimat.model.knowledgebase.entity.Document;
import scimat.model.knowledgebase.entity.Reference;
import scimat.model.knowledgebase.entity.ReferenceGroup;
import scimat.model.knowledgebase.entity.ReferenceSource;
import scimat.model.knowledgebase.exception.KnowledgeBaseException;
import scimat.project.CurrentProject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JoinReferenceEdit
extends KnowledgeBaseEdit {
    private ArrayList<Reference> referencesToMove;
    private Reference targetReference;
    private ArrayList<ArrayList<AuthorReferenceReference>> authorReferenceReferencesOfSources = new ArrayList();
    private ArrayList<ArrayList<Document>> documentsOfSources = new ArrayList();
    private ArrayList<ReferenceGroup> referenceGroupOfSources = new ArrayList();
    private ArrayList<ReferenceSource> referenceSourceOfSources = new ArrayList();
    private TreeSet<AuthorReferenceReference> authorReferenceReferencesOfTarget = new TreeSet();
    private TreeSet<Document> documentsOfTarget = new TreeSet();

    public JoinReferenceEdit(ArrayList<Reference> referencesToMove, Reference targetReference) {
        this.referencesToMove = referencesToMove;
        this.targetReference = targetReference;
    }

    @Override
    public boolean execute() throws KnowledgeBaseException {
        boolean successful = true;
        try {
            ReferenceDAO referenceDAO = CurrentProject.getInstance().getFactoryDAO().getReferenceDAO();
            AuthorReferenceReferenceDAO authorReferenceReferenceDAO = CurrentProject.getInstance().getFactoryDAO().getAuthorReferenceReferenceDAO();
            DocumentReferenceDAO documentReferenceDAO = CurrentProject.getInstance().getFactoryDAO().getDocumentReferenceDAO();
            this.authorReferenceReferencesOfTarget = new TreeSet<AuthorReferenceReference>(referenceDAO.getAuthorReferenceReferences(this.targetReference.getReferenceID()));
            this.documentsOfTarget = new TreeSet<Document>(referenceDAO.getDocuments(this.targetReference.getReferenceID()));
            for (int i = 0; i < this.referencesToMove.size() && successful; ++i) {
                int j;
                Reference reference = this.referencesToMove.get(i);
                ArrayList<AuthorReferenceReference> authorReferenceReferences = referenceDAO.getAuthorReferenceReferences(reference.getReferenceID());
                this.authorReferenceReferencesOfSources.add(authorReferenceReferences);
                ArrayList<Document> documents = referenceDAO.getDocuments(reference.getReferenceID());
                this.documentsOfSources.add(documents);
                this.referenceGroupOfSources.add(referenceDAO.getReferenceGroup(reference.getReferenceID()));
                this.referenceSourceOfSources.add(referenceDAO.getReferenceSource(reference.getReferenceID()));
                successful = referenceDAO.removeReference(reference.getReferenceID(), true);
                for (j = 0; j < authorReferenceReferences.size() && successful; ++j) {
                    AuthorReferenceReference authorReferenceReference = authorReferenceReferences.get(j);
                    if (authorReferenceReferenceDAO.checkAuthorReferenceReference(authorReferenceReference.getAuthorReference().getAuthorReferenceID(), this.targetReference.getReferenceID())) continue;
                    successful = authorReferenceReferenceDAO.addAuthorReferenceReference(this.targetReference.getReferenceID(), authorReferenceReference.getAuthorReference().getAuthorReferenceID(), authorReferenceReference.getPosition(), true);
                }
                for (j = 0; j < documents.size() && successful; ++j) {
                    Document document = documents.get(j);
                    if (documentReferenceDAO.checkDocumentReference(document.getDocumentID(), this.targetReference.getReferenceID())) continue;
                    successful = documentReferenceDAO.addDocumentReference(document.getDocumentID(), this.targetReference.getReferenceID(), true);
                }
            }
            if (successful) {
                CurrentProject.getInstance().getKnowledgeBase().commit();
                KnowledgeBaseEventsReceiver.getInstance().fireEvents();
                UndoStack.addEdit(this);
            } else {
                CurrentProject.getInstance().getKnowledgeBase().rollback();
                this.errorMessage = "An error happened";
            }
        }
        catch (KnowledgeBaseException e) {
            CurrentProject.getInstance().getKnowledgeBase().rollback();
            successful = false;
            this.errorMessage = "An exception happened.";
            throw e;
        }
        return successful;
    }

    @Override
    public void undo() throws CannotUndoException {
        super.undo();
        boolean successful = true;
        try {
            ReferenceDAO referenceDAO = CurrentProject.getInstance().getFactoryDAO().getReferenceDAO();
            AuthorReferenceReferenceDAO authorReferenceReferenceDAO = CurrentProject.getInstance().getFactoryDAO().getAuthorReferenceReferenceDAO();
            DocumentReferenceDAO documentReferenceDAO = CurrentProject.getInstance().getFactoryDAO().getDocumentReferenceDAO();
            TreeSet<AuthorReferenceReference> tmpAuthorReferenceReferences = new TreeSet<AuthorReferenceReference>(referenceDAO.getAuthorReferenceReferences(this.targetReference.getReferenceID()));
            tmpAuthorReferenceReferences.removeAll(this.authorReferenceReferencesOfTarget);
            Iterator<AuthorReferenceReference> itAuthorReferenceReference = tmpAuthorReferenceReferences.iterator();
            while (itAuthorReferenceReference.hasNext() && successful) {
                successful = authorReferenceReferenceDAO.removeAuthorReferenceReference(this.targetReference.getReferenceID(), itAuthorReferenceReference.next().getAuthorReference().getAuthorReferenceID(), true);
            }
            TreeSet<Document> tmpDocuments = new TreeSet<Document>(referenceDAO.getDocuments(this.targetReference.getReferenceID()));
            tmpDocuments.removeAll(this.documentsOfTarget);
            Iterator<Document> itDocument = tmpDocuments.iterator();
            while (itDocument.hasNext() && successful) {
                successful = documentReferenceDAO.removeDocumentReference(itDocument.next().getDocumentID(), this.targetReference.getReferenceID(), true);
            }
            for (int i = 0; i < this.referencesToMove.size() && successful; ++i) {
                int j;
                Reference reference = this.referencesToMove.get(i);
                successful = referenceDAO.addReference(reference, true);
                for (j = 0; j < this.authorReferenceReferencesOfSources.get(i).size() && successful; ++j) {
                    AuthorReferenceReference authorReferenceReference = this.authorReferenceReferencesOfSources.get(i).get(j);
                    successful = authorReferenceReferenceDAO.addAuthorReferenceReference(reference.getReferenceID(), authorReferenceReference.getAuthorReference().getAuthorReferenceID(), authorReferenceReference.getPosition(), true);
                }
                for (j = 0; j < this.documentsOfSources.get(i).size() && successful; ++j) {
                    successful = documentReferenceDAO.addDocumentReference(this.documentsOfSources.get(i).get(j).getDocumentID(), reference.getReferenceID(), true);
                }
                if (this.referenceGroupOfSources.get(i) != null && successful) {
                    successful = referenceDAO.setReferenceGroup(reference.getReferenceID(), this.referenceGroupOfSources.get(i).getReferenceGroupID(), true);
                }
                if (this.referenceSourceOfSources.get(i) == null || !successful) continue;
                successful = referenceDAO.setReferenceSource(reference.getReferenceID(), this.referenceSourceOfSources.get(i).getReferenceSourceID(), true);
            }
            if (successful) {
                CurrentProject.getInstance().getKnowledgeBase().commit();
                KnowledgeBaseEventsReceiver.getInstance().fireEvents();
            } else {
                CurrentProject.getInstance().getKnowledgeBase().rollback();
            }
        }
        catch (KnowledgeBaseException e) {
            e.printStackTrace(System.err);
            try {
                CurrentProject.getInstance().getKnowledgeBase().rollback();
            }
            catch (KnowledgeBaseException e2) {
                e2.printStackTrace(System.err);
            }
        }
    }

    @Override
    public void redo() throws CannotUndoException {
        super.redo();
        boolean successful = true;
        try {
            ReferenceDAO referenceDAO = CurrentProject.getInstance().getFactoryDAO().getReferenceDAO();
            AuthorReferenceReferenceDAO authorReferenceReferenceDAO = CurrentProject.getInstance().getFactoryDAO().getAuthorReferenceReferenceDAO();
            DocumentReferenceDAO documentReferenceDAO = CurrentProject.getInstance().getFactoryDAO().getDocumentReferenceDAO();
            for (int i = 0; i < this.referencesToMove.size() && successful; ++i) {
                int j;
                Reference reference = this.referencesToMove.get(i);
                ArrayList<AuthorReferenceReference> authorReferenceReferences = this.authorReferenceReferencesOfSources.get(i);
                ArrayList<Document> documents = this.documentsOfSources.get(i);
                successful = referenceDAO.removeReference(reference.getReferenceID(), true);
                for (j = 0; j < authorReferenceReferences.size() && successful; ++j) {
                    AuthorReferenceReference authorReferenceReference = authorReferenceReferences.get(j);
                    if (authorReferenceReferenceDAO.checkAuthorReferenceReference(authorReferenceReference.getAuthorReference().getAuthorReferenceID(), this.targetReference.getReferenceID())) continue;
                    successful = authorReferenceReferenceDAO.addAuthorReferenceReference(this.targetReference.getReferenceID(), authorReferenceReference.getAuthorReference().getAuthorReferenceID(), authorReferenceReference.getPosition(), true);
                }
                for (j = 0; j < documents.size() && successful; ++j) {
                    Document document = documents.get(j);
                    if (documentReferenceDAO.checkDocumentReference(document.getDocumentID(), this.targetReference.getReferenceID())) continue;
                    successful = documentReferenceDAO.addDocumentReference(document.getDocumentID(), this.targetReference.getReferenceID(), true);
                }
            }
            if (successful) {
                CurrentProject.getInstance().getKnowledgeBase().commit();
                KnowledgeBaseEventsReceiver.getInstance().fireEvents();
            } else {
                CurrentProject.getInstance().getKnowledgeBase().rollback();
            }
        }
        catch (KnowledgeBaseException e) {
            e.printStackTrace(System.err);
            try {
                CurrentProject.getInstance().getKnowledgeBase().rollback();
            }
            catch (KnowledgeBaseException e2) {
                e2.printStackTrace(System.err);
            }
        }
    }
}

