/*
 * Decompiled with CFR 0.152.
 */
package scimat.gui.commands.edit.join;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.TreeSet;
import javax.swing.undo.CannotUndoException;
import scimat.gui.commands.edit.KnowledgeBaseEdit;
import scimat.gui.undostack.UndoStack;
import scimat.knowledgebaseevents.KnowledgeBaseEventsReceiver;
import scimat.model.knowledgebase.dao.DocumentDAO;
import scimat.model.knowledgebase.dao.JournalSubjectCategoryPublishDateDAO;
import scimat.model.knowledgebase.dao.PublishDateDAO;
import scimat.model.knowledgebase.dao.PublishDatePeriodDAO;
import scimat.model.knowledgebase.entity.Document;
import scimat.model.knowledgebase.entity.JournalSubjectCategoryPublishDate;
import scimat.model.knowledgebase.entity.Period;
import scimat.model.knowledgebase.entity.PublishDate;
import scimat.model.knowledgebase.exception.KnowledgeBaseException;
import scimat.project.CurrentProject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JoinPublishDateEdit
extends KnowledgeBaseEdit {
    private ArrayList<PublishDate> publishDatesToMove;
    private PublishDate targetPublishDate;
    private ArrayList<ArrayList<Document>> documentsOfSources = new ArrayList();
    private ArrayList<ArrayList<Period>> periodsOfSources = new ArrayList();
    private ArrayList<ArrayList<JournalSubjectCategoryPublishDate>> journalSubjectCategoryPublishDatesOfSources = new ArrayList();
    private TreeSet<Document> documentsOfTarget = new TreeSet();
    private TreeSet<Period> periodsOfTarget = new TreeSet();
    private TreeSet<JournalSubjectCategoryPublishDate> journalSubjectCategoryPublishDatesOfTarget = new TreeSet();

    public JoinPublishDateEdit(ArrayList<PublishDate> publishDatesToMove, PublishDate targetPublishDate) {
        this.publishDatesToMove = publishDatesToMove;
        this.targetPublishDate = targetPublishDate;
    }

    @Override
    public boolean execute() throws KnowledgeBaseException {
        boolean successful = true;
        try {
            PublishDateDAO publishDateDAO = CurrentProject.getInstance().getFactoryDAO().getPublishDateDAO();
            DocumentDAO documentDAO = CurrentProject.getInstance().getFactoryDAO().getDocumentDAO();
            JournalSubjectCategoryPublishDateDAO journalSubjectCategoryPublishDateDAO = CurrentProject.getInstance().getFactoryDAO().getJournalSubjectCategoryPublishDateDAO();
            PublishDatePeriodDAO publishDatePeriodDAO = CurrentProject.getInstance().getFactoryDAO().getPublishDatePeriodDAO();
            this.documentsOfTarget = new TreeSet<Document>(publishDateDAO.getDocuments(this.targetPublishDate.getPublishDateID()));
            this.journalSubjectCategoryPublishDatesOfTarget = new TreeSet<JournalSubjectCategoryPublishDate>(publishDateDAO.getSubjectCategories(this.targetPublishDate.getPublishDateID()));
            this.periodsOfTarget = new TreeSet<Period>(publishDateDAO.getPeriods(this.targetPublishDate.getPublishDateID()));
            for (int i = 0; i < this.publishDatesToMove.size() && successful; ++i) {
                int j;
                PublishDate publishDate = this.publishDatesToMove.get(i);
                ArrayList<JournalSubjectCategoryPublishDate> journalSubjectCategoryPublishDates = publishDateDAO.getSubjectCategories(publishDate.getPublishDateID());
                this.journalSubjectCategoryPublishDatesOfSources.add(journalSubjectCategoryPublishDates);
                ArrayList<Document> documents = publishDateDAO.getDocuments(publishDate.getPublishDateID());
                this.documentsOfSources.add(documents);
                ArrayList<Period> periods = publishDateDAO.getPeriods(publishDate.getPublishDateID());
                this.documentsOfSources.add(documents);
                successful = publishDateDAO.removePublishDate(publishDate.getPublishDateID(), true);
                for (j = 0; j < journalSubjectCategoryPublishDates.size() && successful; ++j) {
                    JournalSubjectCategoryPublishDate journalSubjectCategoryPublishDate = journalSubjectCategoryPublishDates.get(j);
                    if (journalSubjectCategoryPublishDateDAO.checkJournalSubjectCategoryPublishDate(journalSubjectCategoryPublishDate.getJournal().getJournalID(), journalSubjectCategoryPublishDate.getSubjectCategory().getSubjectCategoryID(), this.targetPublishDate.getPublishDateID())) continue;
                    successful = journalSubjectCategoryPublishDateDAO.addSubjectCategoryToJournal(journalSubjectCategoryPublishDate.getJournal().getJournalID(), journalSubjectCategoryPublishDate.getSubjectCategory().getSubjectCategoryID(), this.targetPublishDate.getPublishDateID(), true);
                }
                for (j = 0; j < documents.size() && successful; ++j) {
                    successful = documentDAO.setPublishDate(documents.get(j).getDocumentID(), this.targetPublishDate.getPublishDateID(), true);
                }
                for (j = 0; j < periods.size() && successful; ++j) {
                    Period period = periods.get(j);
                    if (publishDatePeriodDAO.checkPublishDatePeriod(this.targetPublishDate.getPublishDateID(), period.getPeriodID())) continue;
                    successful = publishDatePeriodDAO.addPublishDatePeriod(period.getPeriodID(), this.targetPublishDate.getPublishDateID(), true);
                }
            }
            if (successful) {
                CurrentProject.getInstance().getKnowledgeBase().commit();
                KnowledgeBaseEventsReceiver.getInstance().fireEvents();
                UndoStack.addEdit(this);
            } else {
                CurrentProject.getInstance().getKnowledgeBase().rollback();
                this.errorMessage = "An error happened";
            }
        }
        catch (KnowledgeBaseException e) {
            CurrentProject.getInstance().getKnowledgeBase().rollback();
            successful = false;
            this.errorMessage = "An exception happened.";
            throw e;
        }
        return successful;
    }

    @Override
    public void undo() throws CannotUndoException {
        super.undo();
        boolean successful = true;
        try {
            JournalSubjectCategoryPublishDate journalSubjectCategoryPublishDate;
            PublishDateDAO publishDateDAO = CurrentProject.getInstance().getFactoryDAO().getPublishDateDAO();
            DocumentDAO documentDAO = CurrentProject.getInstance().getFactoryDAO().getDocumentDAO();
            JournalSubjectCategoryPublishDateDAO journalSubjectCategoryPublishDateDAO = CurrentProject.getInstance().getFactoryDAO().getJournalSubjectCategoryPublishDateDAO();
            PublishDatePeriodDAO publishDatePeriodDAO = CurrentProject.getInstance().getFactoryDAO().getPublishDatePeriodDAO();
            TreeSet<Document> tmpDocuments = new TreeSet<Document>(publishDateDAO.getDocuments(this.targetPublishDate.getPublishDateID()));
            tmpDocuments.removeAll(this.documentsOfTarget);
            Iterator<Document> itDocument = tmpDocuments.iterator();
            while (itDocument.hasNext() && successful) {
                successful = documentDAO.setPublishDate(itDocument.next().getDocumentID(), null, true);
            }
            TreeSet<JournalSubjectCategoryPublishDate> tmpJournalSubjectCategoryPublishDates = new TreeSet<JournalSubjectCategoryPublishDate>(publishDateDAO.getSubjectCategories(this.targetPublishDate.getPublishDateID()));
            tmpJournalSubjectCategoryPublishDates.removeAll(this.journalSubjectCategoryPublishDatesOfTarget);
            Iterator<JournalSubjectCategoryPublishDate> itJournalSubjectCategoryPublishDate = tmpJournalSubjectCategoryPublishDates.iterator();
            while (itJournalSubjectCategoryPublishDate.hasNext() && successful) {
                journalSubjectCategoryPublishDate = itJournalSubjectCategoryPublishDate.next();
                successful = journalSubjectCategoryPublishDateDAO.removeSubjectCategoryFromJournal(journalSubjectCategoryPublishDate.getSubjectCategory().getSubjectCategoryID(), journalSubjectCategoryPublishDate.getJournal().getJournalID(), this.targetPublishDate.getPublishDateID(), true);
            }
            TreeSet<Period> tmpPeriods = new TreeSet<Period>(publishDateDAO.getPeriods(this.targetPublishDate.getPublishDateID()));
            tmpPeriods.removeAll(this.periodsOfTarget);
            Iterator<Period> itPeriod = tmpPeriods.iterator();
            while (itPeriod.hasNext() && successful) {
                successful = publishDatePeriodDAO.removePublishDatePeriod(itPeriod.next().getPeriodID(), this.targetPublishDate.getPublishDateID(), true);
            }
            for (int i = 0; i < this.publishDatesToMove.size() && successful; ++i) {
                int j;
                PublishDate publishDate = this.publishDatesToMove.get(i);
                successful = publishDateDAO.addPublishDate(publishDate, true);
                for (j = 0; j < this.journalSubjectCategoryPublishDatesOfSources.get(i).size() && successful; ++j) {
                    journalSubjectCategoryPublishDate = this.journalSubjectCategoryPublishDatesOfSources.get(i).get(j);
                    successful = journalSubjectCategoryPublishDateDAO.addSubjectCategoryToJournal(journalSubjectCategoryPublishDate.getSubjectCategory().getSubjectCategoryID(), journalSubjectCategoryPublishDate.getJournal().getJournalID(), publishDate.getPublishDateID(), true);
                }
                for (j = 0; j < this.periodsOfSources.get(i).size() && successful; ++j) {
                    successful = publishDatePeriodDAO.addPublishDatePeriod(this.periodsOfSources.get(i).get(j).getPeriodID(), publishDate.getPublishDateID(), true);
                }
                for (j = 0; j < this.documentsOfSources.get(i).size() && successful; ++j) {
                    Document document = this.documentsOfSources.get(i).get(j);
                    successful = documentDAO.setPublishDate(document.getDocumentID(), publishDate.getPublishDateID(), true);
                }
            }
            if (successful) {
                CurrentProject.getInstance().getKnowledgeBase().commit();
                KnowledgeBaseEventsReceiver.getInstance().fireEvents();
            } else {
                CurrentProject.getInstance().getKnowledgeBase().rollback();
            }
        }
        catch (KnowledgeBaseException e) {
            e.printStackTrace(System.err);
            try {
                CurrentProject.getInstance().getKnowledgeBase().rollback();
            }
            catch (KnowledgeBaseException e2) {
                e2.printStackTrace(System.err);
            }
        }
    }

    @Override
    public void redo() throws CannotUndoException {
        super.redo();
        boolean successful = true;
        try {
            PublishDateDAO publishDateDAO = CurrentProject.getInstance().getFactoryDAO().getPublishDateDAO();
            DocumentDAO documentDAO = CurrentProject.getInstance().getFactoryDAO().getDocumentDAO();
            JournalSubjectCategoryPublishDateDAO journalSubjectCategoryPublishDateDAO = CurrentProject.getInstance().getFactoryDAO().getJournalSubjectCategoryPublishDateDAO();
            PublishDatePeriodDAO publishDatePeriodDAO = CurrentProject.getInstance().getFactoryDAO().getPublishDatePeriodDAO();
            for (int i = 0; i < this.publishDatesToMove.size() && successful; ++i) {
                int j;
                PublishDate publishDate = this.publishDatesToMove.get(i);
                ArrayList<JournalSubjectCategoryPublishDate> journalSubjectCategoryPublishDates = this.journalSubjectCategoryPublishDatesOfSources.get(i);
                ArrayList<Document> documents = this.documentsOfSources.get(i);
                ArrayList<Period> periods = this.periodsOfSources.get(i);
                successful = publishDateDAO.removePublishDate(publishDate.getPublishDateID(), true);
                for (j = 0; j < journalSubjectCategoryPublishDates.size() && successful; ++j) {
                    JournalSubjectCategoryPublishDate journalSubjectCategoryPublishDate = journalSubjectCategoryPublishDates.get(j);
                    if (journalSubjectCategoryPublishDateDAO.checkJournalSubjectCategoryPublishDate(journalSubjectCategoryPublishDate.getJournal().getJournalID(), journalSubjectCategoryPublishDate.getSubjectCategory().getSubjectCategoryID(), this.targetPublishDate.getPublishDateID())) continue;
                    successful = journalSubjectCategoryPublishDateDAO.addSubjectCategoryToJournal(journalSubjectCategoryPublishDate.getJournal().getJournalID(), journalSubjectCategoryPublishDate.getSubjectCategory().getSubjectCategoryID(), this.targetPublishDate.getPublishDateID(), true);
                }
                for (j = 0; j < documents.size() && successful; ++j) {
                    successful = documentDAO.setPublishDate(documents.get(j).getDocumentID(), this.targetPublishDate.getPublishDateID(), true);
                }
                for (j = 0; j < periods.size() && successful; ++j) {
                    Period period = periods.get(j);
                    if (publishDatePeriodDAO.checkPublishDatePeriod(this.targetPublishDate.getPublishDateID(), period.getPeriodID())) continue;
                    successful = publishDatePeriodDAO.addPublishDatePeriod(period.getPeriodID(), this.targetPublishDate.getPublishDateID(), true);
                }
            }
            if (successful) {
                CurrentProject.getInstance().getKnowledgeBase().commit();
                KnowledgeBaseEventsReceiver.getInstance().fireEvents();
            } else {
                CurrentProject.getInstance().getKnowledgeBase().rollback();
            }
        }
        catch (KnowledgeBaseException e) {
            e.printStackTrace(System.err);
            try {
                CurrentProject.getInstance().getKnowledgeBase().rollback();
            }
            catch (KnowledgeBaseException e2) {
                e2.printStackTrace(System.err);
            }
        }
    }
}

