/*
 * Decompiled with CFR 0.152.
 */
package scimat.gui.commands.edit.join;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.TreeSet;
import javax.swing.undo.CannotUndoException;
import scimat.gui.commands.edit.KnowledgeBaseEdit;
import scimat.gui.undostack.UndoStack;
import scimat.knowledgebaseevents.KnowledgeBaseEventsReceiver;
import scimat.model.knowledgebase.dao.PeriodDAO;
import scimat.model.knowledgebase.dao.PublishDatePeriodDAO;
import scimat.model.knowledgebase.entity.Period;
import scimat.model.knowledgebase.entity.PublishDate;
import scimat.model.knowledgebase.exception.KnowledgeBaseException;
import scimat.project.CurrentProject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JoinPeriodEdit
extends KnowledgeBaseEdit {
    private ArrayList<Period> periodsToMove;
    private Period targetPeriod;
    private ArrayList<ArrayList<PublishDate>> publishDatesOfSources = new ArrayList();
    private TreeSet<PublishDate> publishDatesOfTarget = new TreeSet();

    public JoinPeriodEdit(ArrayList<Period> periodsToMove, Period targetPeriod) {
        this.periodsToMove = periodsToMove;
        this.targetPeriod = targetPeriod;
    }

    @Override
    public boolean execute() throws KnowledgeBaseException {
        boolean successful = true;
        try {
            PeriodDAO periodDAO = CurrentProject.getInstance().getFactoryDAO().getPeriodDAO();
            PublishDatePeriodDAO publishDatePeriodDAO = CurrentProject.getInstance().getFactoryDAO().getPublishDatePeriodDAO();
            this.publishDatesOfTarget = new TreeSet<PublishDate>(periodDAO.getPublishDates(this.targetPeriod.getPeriodID()));
            for (int i = 0; i < this.periodsToMove.size() && successful; ++i) {
                Period period = this.periodsToMove.get(i);
                ArrayList<PublishDate> publishDates = periodDAO.getPublishDates(period.getPeriodID());
                this.publishDatesOfSources.add(publishDates);
                successful = periodDAO.removePeriod(period.getPeriodID(), true);
                for (int j = 0; j < publishDates.size() && successful; ++j) {
                    PublishDate publishDate = publishDates.get(j);
                    if (publishDatePeriodDAO.checkPublishDatePeriod(publishDate.getPublishDateID(), this.targetPeriod.getPeriodID())) continue;
                    successful = publishDatePeriodDAO.addPublishDatePeriod(this.targetPeriod.getPeriodID(), publishDate.getPublishDateID(), true);
                }
            }
            if (successful) {
                CurrentProject.getInstance().getKnowledgeBase().commit();
                KnowledgeBaseEventsReceiver.getInstance().fireEvents();
                UndoStack.addEdit(this);
            } else {
                CurrentProject.getInstance().getKnowledgeBase().rollback();
                this.errorMessage = "An error happened";
            }
        }
        catch (KnowledgeBaseException e) {
            CurrentProject.getInstance().getKnowledgeBase().rollback();
            successful = false;
            this.errorMessage = "An exception happened.";
            throw e;
        }
        return successful;
    }

    @Override
    public void undo() throws CannotUndoException {
        super.undo();
        boolean successful = true;
        try {
            PeriodDAO periodDAO = CurrentProject.getInstance().getFactoryDAO().getPeriodDAO();
            PublishDatePeriodDAO publishDatePeriodDAO = CurrentProject.getInstance().getFactoryDAO().getPublishDatePeriodDAO();
            TreeSet<PublishDate> tmpPublishDates = new TreeSet<PublishDate>(periodDAO.getPublishDates(this.targetPeriod.getPeriodID()));
            tmpPublishDates.removeAll(this.publishDatesOfTarget);
            Iterator<PublishDate> itPublishDate = tmpPublishDates.iterator();
            while (itPublishDate.hasNext() && successful) {
                successful = publishDatePeriodDAO.removePublishDatePeriod(this.targetPeriod.getPeriodID(), itPublishDate.next().getPublishDateID(), true);
            }
            for (int i = 0; i < this.periodsToMove.size() && successful; ++i) {
                Period period = this.periodsToMove.get(i);
                successful = periodDAO.addPeriod(period, true);
                for (int j = 0; j < this.publishDatesOfSources.get(i).size() && successful; ++j) {
                    successful = publishDatePeriodDAO.addPublishDatePeriod(period.getPeriodID(), this.publishDatesOfSources.get(i).get(j).getPublishDateID(), true);
                }
            }
            if (successful) {
                CurrentProject.getInstance().getKnowledgeBase().commit();
                KnowledgeBaseEventsReceiver.getInstance().fireEvents();
            } else {
                CurrentProject.getInstance().getKnowledgeBase().rollback();
            }
        }
        catch (KnowledgeBaseException e) {
            e.printStackTrace(System.err);
            try {
                CurrentProject.getInstance().getKnowledgeBase().rollback();
            }
            catch (KnowledgeBaseException e2) {
                e2.printStackTrace(System.err);
            }
        }
    }

    @Override
    public void redo() throws CannotUndoException {
        super.redo();
        boolean successful = true;
        try {
            PeriodDAO periodDAO = CurrentProject.getInstance().getFactoryDAO().getPeriodDAO();
            PublishDatePeriodDAO publishDatePeriodDAO = CurrentProject.getInstance().getFactoryDAO().getPublishDatePeriodDAO();
            for (int i = 0; i < this.periodsToMove.size() && successful; ++i) {
                Period period = this.periodsToMove.get(i);
                ArrayList<PublishDate> publishDates = this.publishDatesOfSources.get(i);
                successful = periodDAO.removePeriod(period.getPeriodID(), true);
                for (int j = 0; j < publishDates.size() && successful; ++j) {
                    PublishDate publishDate = publishDates.get(j);
                    if (publishDatePeriodDAO.checkPublishDatePeriod(publishDate.getPublishDateID(), this.targetPeriod.getPeriodID())) continue;
                    successful = publishDatePeriodDAO.addPublishDatePeriod(this.targetPeriod.getPeriodID(), publishDate.getPublishDateID(), true);
                }
            }
            if (successful) {
                CurrentProject.getInstance().getKnowledgeBase().commit();
                KnowledgeBaseEventsReceiver.getInstance().fireEvents();
            } else {
                CurrentProject.getInstance().getKnowledgeBase().rollback();
            }
        }
        catch (KnowledgeBaseException e) {
            e.printStackTrace(System.err);
            try {
                CurrentProject.getInstance().getKnowledgeBase().rollback();
            }
            catch (KnowledgeBaseException e2) {
                e2.printStackTrace(System.err);
            }
        }
    }
}

