/*
 * Decompiled with CFR 0.152.
 */
package scimat.gui.commands.edit.join;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.TreeSet;
import javax.swing.undo.CannotUndoException;
import scimat.gui.commands.edit.KnowledgeBaseEdit;
import scimat.gui.undostack.UndoStack;
import scimat.knowledgebaseevents.KnowledgeBaseEventsReceiver;
import scimat.model.knowledgebase.dao.DocumentDAO;
import scimat.model.knowledgebase.dao.JournalDAO;
import scimat.model.knowledgebase.dao.JournalSubjectCategoryPublishDateDAO;
import scimat.model.knowledgebase.entity.Document;
import scimat.model.knowledgebase.entity.Journal;
import scimat.model.knowledgebase.entity.JournalSubjectCategoryPublishDate;
import scimat.model.knowledgebase.exception.KnowledgeBaseException;
import scimat.project.CurrentProject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JoinJournalEdit
extends KnowledgeBaseEdit {
    private ArrayList<Journal> journalsToMove;
    private Journal targetJournal;
    private ArrayList<ArrayList<Document>> documentsOfSources = new ArrayList();
    private ArrayList<ArrayList<JournalSubjectCategoryPublishDate>> journalSubjectCategoryPublishDatesOfSources = new ArrayList();
    private TreeSet<Document> documentsOfTarget = new TreeSet();
    private TreeSet<JournalSubjectCategoryPublishDate> journalSubjectCategoryPublishDatesOfTarget = new TreeSet();

    public JoinJournalEdit(ArrayList<Journal> journalsToMove, Journal targetJournal) {
        this.journalsToMove = journalsToMove;
        this.targetJournal = targetJournal;
    }

    @Override
    public boolean execute() throws KnowledgeBaseException {
        boolean successful = true;
        try {
            JournalDAO journalDAO = CurrentProject.getInstance().getFactoryDAO().getJournalDAO();
            DocumentDAO documentDAO = CurrentProject.getInstance().getFactoryDAO().getDocumentDAO();
            JournalSubjectCategoryPublishDateDAO journalSubjectCategoryPublishDateDAO = CurrentProject.getInstance().getFactoryDAO().getJournalSubjectCategoryPublishDateDAO();
            this.documentsOfTarget = new TreeSet<Document>(journalDAO.getDocuments(this.targetJournal.getJournalID()));
            this.journalSubjectCategoryPublishDatesOfTarget = new TreeSet<JournalSubjectCategoryPublishDate>(journalDAO.getJournalSubjectCategoryPublishDates(this.targetJournal.getJournalID()));
            for (int i = 0; i < this.journalsToMove.size() && successful; ++i) {
                int j;
                Journal journal = this.journalsToMove.get(i);
                ArrayList<JournalSubjectCategoryPublishDate> journalSubjectCategoryPublishDates = journalDAO.getJournalSubjectCategoryPublishDates(journal.getJournalID());
                this.journalSubjectCategoryPublishDatesOfSources.add(journalSubjectCategoryPublishDates);
                ArrayList<Document> documents = journalDAO.getDocuments(journal.getJournalID());
                this.documentsOfSources.add(documents);
                successful = journalDAO.removeJournal(journal.getJournalID(), true);
                for (j = 0; j < journalSubjectCategoryPublishDates.size() && successful; ++j) {
                    JournalSubjectCategoryPublishDate journalSubjectCategoryPublishDate = journalSubjectCategoryPublishDates.get(j);
                    if (journalSubjectCategoryPublishDateDAO.checkJournalSubjectCategoryPublishDate(this.targetJournal.getJournalID(), journalSubjectCategoryPublishDate.getSubjectCategory().getSubjectCategoryID(), journalSubjectCategoryPublishDate.getPublishDate().getPublishDateID())) continue;
                    successful = journalSubjectCategoryPublishDateDAO.addSubjectCategoryToJournal(this.targetJournal.getJournalID(), journalSubjectCategoryPublishDate.getSubjectCategory().getSubjectCategoryID(), journalSubjectCategoryPublishDate.getPublishDate().getPublishDateID(), true);
                }
                for (j = 0; j < documents.size() && successful; ++j) {
                    successful = documentDAO.setJournal(documents.get(j).getDocumentID(), this.targetJournal.getJournalID(), true);
                }
            }
            if (successful) {
                CurrentProject.getInstance().getKnowledgeBase().commit();
                UndoStack.addEdit(this);
            } else {
                CurrentProject.getInstance().getKnowledgeBase().rollback();
                this.errorMessage = "An error happened";
            }
        }
        catch (KnowledgeBaseException e) {
            CurrentProject.getInstance().getKnowledgeBase().rollback();
            successful = false;
            this.errorMessage = "An exception happened.";
            throw e;
        }
        return successful;
    }

    @Override
    public void undo() throws CannotUndoException {
        super.undo();
        boolean successful = true;
        try {
            JournalSubjectCategoryPublishDate journalSubjectCategoryPublishDate;
            JournalDAO journalDAO = CurrentProject.getInstance().getFactoryDAO().getJournalDAO();
            DocumentDAO documentDAO = CurrentProject.getInstance().getFactoryDAO().getDocumentDAO();
            JournalSubjectCategoryPublishDateDAO journalSubjectCategoryPublishDateDAO = CurrentProject.getInstance().getFactoryDAO().getJournalSubjectCategoryPublishDateDAO();
            TreeSet<Document> tmpDocuments = new TreeSet<Document>(journalDAO.getDocuments(this.targetJournal.getJournalID()));
            tmpDocuments.removeAll(this.documentsOfTarget);
            Iterator<Document> itDocument = tmpDocuments.iterator();
            while (itDocument.hasNext() && successful) {
                successful = documentDAO.setJournal(itDocument.next().getDocumentID(), null, true);
            }
            TreeSet<JournalSubjectCategoryPublishDate> tmpJournalSubjectCategoryPublishDates = new TreeSet<JournalSubjectCategoryPublishDate>(journalDAO.getJournalSubjectCategoryPublishDates(this.targetJournal.getJournalID()));
            tmpJournalSubjectCategoryPublishDates.removeAll(this.journalSubjectCategoryPublishDatesOfTarget);
            Iterator<JournalSubjectCategoryPublishDate> itJournalSubjectCategoryPublishDate = tmpJournalSubjectCategoryPublishDates.iterator();
            while (itJournalSubjectCategoryPublishDate.hasNext() && successful) {
                journalSubjectCategoryPublishDate = itJournalSubjectCategoryPublishDate.next();
                successful = journalSubjectCategoryPublishDateDAO.removeSubjectCategoryFromJournal(journalSubjectCategoryPublishDate.getSubjectCategory().getSubjectCategoryID(), this.targetJournal.getJournalID(), journalSubjectCategoryPublishDate.getPublishDate().getPublishDateID(), true);
            }
            for (int i = 0; i < this.journalsToMove.size() && successful; ++i) {
                int j;
                Journal journal = this.journalsToMove.get(i);
                successful = journalDAO.addJournal(journal, true);
                for (j = 0; j < this.journalSubjectCategoryPublishDatesOfSources.get(i).size() && successful; ++j) {
                    journalSubjectCategoryPublishDate = this.journalSubjectCategoryPublishDatesOfSources.get(i).get(j);
                    successful = journalSubjectCategoryPublishDateDAO.addSubjectCategoryToJournal(journalSubjectCategoryPublishDate.getSubjectCategory().getSubjectCategoryID(), journal.getJournalID(), journalSubjectCategoryPublishDate.getPublishDate().getPublishDateID(), true);
                }
                for (j = 0; j < this.documentsOfSources.get(i).size() && successful; ++j) {
                    Document document = this.documentsOfSources.get(i).get(j);
                    successful = documentDAO.setJournal(document.getDocumentID(), journal.getJournalID(), true);
                }
            }
            if (successful) {
                CurrentProject.getInstance().getKnowledgeBase().commit();
                KnowledgeBaseEventsReceiver.getInstance().fireEvents();
            } else {
                CurrentProject.getInstance().getKnowledgeBase().rollback();
            }
        }
        catch (KnowledgeBaseException e) {
            e.printStackTrace(System.err);
            try {
                CurrentProject.getInstance().getKnowledgeBase().rollback();
            }
            catch (KnowledgeBaseException e2) {
                e2.printStackTrace(System.err);
            }
        }
    }

    @Override
    public void redo() throws CannotUndoException {
        super.redo();
        boolean successful = true;
        try {
            JournalDAO journalDAO = CurrentProject.getInstance().getFactoryDAO().getJournalDAO();
            DocumentDAO documentDAO = CurrentProject.getInstance().getFactoryDAO().getDocumentDAO();
            JournalSubjectCategoryPublishDateDAO journalSubjectCategoryPublishDateDAO = CurrentProject.getInstance().getFactoryDAO().getJournalSubjectCategoryPublishDateDAO();
            for (int i = 0; i < this.journalsToMove.size() && successful; ++i) {
                int j;
                Journal journal = this.journalsToMove.get(i);
                ArrayList<JournalSubjectCategoryPublishDate> journalSubjectCategoryPublishDates = this.journalSubjectCategoryPublishDatesOfSources.get(i);
                ArrayList<Document> documents = this.documentsOfSources.get(i);
                successful = journalDAO.removeJournal(journal.getJournalID(), true);
                for (j = 0; j < journalSubjectCategoryPublishDates.size() && successful; ++j) {
                    JournalSubjectCategoryPublishDate journalSubjectCategoryPublishDate = journalSubjectCategoryPublishDates.get(j);
                    if (journalSubjectCategoryPublishDateDAO.checkJournalSubjectCategoryPublishDate(this.targetJournal.getJournalID(), journalSubjectCategoryPublishDate.getSubjectCategory().getSubjectCategoryID(), journalSubjectCategoryPublishDate.getPublishDate().getPublishDateID())) continue;
                    successful = journalSubjectCategoryPublishDateDAO.addSubjectCategoryToJournal(this.targetJournal.getJournalID(), journalSubjectCategoryPublishDate.getSubjectCategory().getSubjectCategoryID(), journalSubjectCategoryPublishDate.getPublishDate().getPublishDateID(), true);
                }
                for (j = 0; j < documents.size() && successful; ++j) {
                    successful = documentDAO.setJournal(documents.get(j).getDocumentID(), this.targetJournal.getJournalID(), true);
                }
            }
            if (successful) {
                CurrentProject.getInstance().getKnowledgeBase().commit();
                KnowledgeBaseEventsReceiver.getInstance().fireEvents();
            } else {
                CurrentProject.getInstance().getKnowledgeBase().rollback();
            }
        }
        catch (KnowledgeBaseException e) {
            e.printStackTrace(System.err);
            try {
                CurrentProject.getInstance().getKnowledgeBase().rollback();
            }
            catch (KnowledgeBaseException e2) {
                e2.printStackTrace(System.err);
            }
        }
    }
}

