/*
 * Decompiled with CFR 0.152.
 */
package scimat.gui.commands.edit.join;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.TreeSet;
import javax.swing.undo.CannotUndoException;
import scimat.gui.commands.edit.KnowledgeBaseEdit;
import scimat.gui.undostack.UndoStack;
import scimat.knowledgebaseevents.KnowledgeBaseEventsReceiver;
import scimat.model.knowledgebase.dao.DocumentAffiliationDAO;
import scimat.model.knowledgebase.dao.DocumentAuthorDAO;
import scimat.model.knowledgebase.dao.DocumentDAO;
import scimat.model.knowledgebase.dao.DocumentReferenceDAO;
import scimat.model.knowledgebase.dao.DocumentWordDAO;
import scimat.model.knowledgebase.entity.Affiliation;
import scimat.model.knowledgebase.entity.Document;
import scimat.model.knowledgebase.entity.DocumentAuthor;
import scimat.model.knowledgebase.entity.DocumentWord;
import scimat.model.knowledgebase.entity.Journal;
import scimat.model.knowledgebase.entity.PublishDate;
import scimat.model.knowledgebase.entity.Reference;
import scimat.model.knowledgebase.exception.KnowledgeBaseException;
import scimat.project.CurrentProject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JoinDocumentEdit
extends KnowledgeBaseEdit {
    private ArrayList<Document> documentsToMove;
    private Document targetDocument;
    private ArrayList<ArrayList<DocumentAuthor>> documentAuthorsOfSources = new ArrayList();
    private ArrayList<ArrayList<DocumentWord>> documentWordsOfSources = new ArrayList();
    private ArrayList<ArrayList<Affiliation>> affiliationsOfSources = new ArrayList();
    private ArrayList<ArrayList<Reference>> referencesOfSources = new ArrayList();
    private ArrayList<Journal> journalOfSources = new ArrayList();
    private ArrayList<PublishDate> publishDateOfSources = new ArrayList();
    private TreeSet<DocumentAuthor> documentAuthorsOfTarget = new TreeSet();
    private TreeSet<DocumentWord> documentWordsOfTarget = new TreeSet();
    private TreeSet<Affiliation> affiliationsOfTarget = new TreeSet();
    private TreeSet<Reference> referencesOfTarget = new TreeSet();

    public JoinDocumentEdit(ArrayList<Document> documentsToMove, Document targetDocument) {
        this.documentsToMove = documentsToMove;
        this.targetDocument = targetDocument;
    }

    @Override
    public boolean execute() throws KnowledgeBaseException {
        boolean successful = true;
        try {
            DocumentDAO documentDAO = CurrentProject.getInstance().getFactoryDAO().getDocumentDAO();
            DocumentAuthorDAO documentAuthorDAO = CurrentProject.getInstance().getFactoryDAO().getDocumentAuthorDAO();
            DocumentAffiliationDAO documentAffiliationDAO = CurrentProject.getInstance().getFactoryDAO().getDocumentAffiliationDAO();
            DocumentWordDAO documentWordDAO = CurrentProject.getInstance().getFactoryDAO().getDocumentWordDAO();
            DocumentReferenceDAO documentReferenceDAO = CurrentProject.getInstance().getFactoryDAO().getDocumentReferenceDAO();
            this.documentAuthorsOfTarget = new TreeSet<DocumentAuthor>(documentDAO.getDocumentAuthors(this.targetDocument.getDocumentID()));
            this.documentWordsOfTarget = new TreeSet<DocumentWord>(documentDAO.getDocumentWords(this.targetDocument.getDocumentID()));
            this.affiliationsOfTarget = new TreeSet<Affiliation>(documentDAO.getAffiliations(this.targetDocument.getDocumentID()));
            this.referencesOfTarget = new TreeSet<Reference>(documentDAO.getReferences(this.targetDocument.getDocumentID()));
            for (int i = 0; i < this.documentsToMove.size() && successful; ++i) {
                int j;
                Document document = this.documentsToMove.get(i);
                ArrayList<DocumentWord> documentWords = documentDAO.getDocumentWords(document.getDocumentID());
                this.documentWordsOfSources.add(documentWords);
                ArrayList<DocumentAuthor> documentAuthors = documentDAO.getDocumentAuthors(document.getDocumentID());
                this.documentAuthorsOfSources.add(documentAuthors);
                ArrayList<Affiliation> affiliations = documentDAO.getAffiliations(document.getDocumentID());
                this.affiliationsOfSources.add(affiliations);
                ArrayList<Reference> references = documentDAO.getReferences(document.getDocumentID());
                this.referencesOfSources.add(references);
                this.journalOfSources.add(documentDAO.getJournal(document.getDocumentID()));
                this.publishDateOfSources.add(documentDAO.getPublishDate(document.getDocumentID()));
                successful = documentDAO.removeDocument(document.getDocumentID(), true);
                for (j = 0; j < documentWords.size() && successful; ++j) {
                    DocumentWord documentWord = documentWords.get(j);
                    if (documentWordDAO.checkDocumentWord(this.targetDocument.getDocumentID(), documentWord.getWord().getWordID())) continue;
                    successful = documentWordDAO.addDocumentWord(this.targetDocument.getDocumentID(), documentWord.getWord().getWordID(), documentWord.isAuthorKeyword(), documentWord.isSourceKeyword(), documentWord.isAddedKeyword(), true);
                }
                for (j = 0; j < documentAuthors.size() && successful; ++j) {
                    DocumentAuthor documentAuthor = documentAuthors.get(j);
                    if (documentAuthorDAO.checkDocumentAuthor(this.targetDocument.getDocumentID(), documentAuthor.getAuthor().getAuthorID())) continue;
                    successful = documentAuthorDAO.addDocumentAuthor(this.targetDocument.getDocumentID(), documentAuthor.getAuthor().getAuthorID(), documentAuthor.getPosition(), true);
                }
                for (j = 0; j < affiliations.size() && successful; ++j) {
                    if (documentAffiliationDAO.checkDocumentAffiliation(this.targetDocument.getDocumentID(), affiliations.get(j).getAffiliationID())) continue;
                    successful = documentAffiliationDAO.addDocumentAffiliation(this.targetDocument.getDocumentID(), affiliations.get(j).getAffiliationID(), true);
                }
                for (j = 0; j < references.size() && successful; ++j) {
                    if (documentReferenceDAO.checkDocumentReference(this.targetDocument.getDocumentID(), references.get(j).getReferenceID())) continue;
                    successful = documentReferenceDAO.addDocumentReference(this.targetDocument.getDocumentID(), references.get(j).getReferenceID(), true);
                }
            }
            if (successful) {
                CurrentProject.getInstance().getKnowledgeBase().commit();
                KnowledgeBaseEventsReceiver.getInstance().fireEvents();
                UndoStack.addEdit(this);
            } else {
                CurrentProject.getInstance().getKnowledgeBase().rollback();
                this.errorMessage = "An error happened";
            }
        }
        catch (KnowledgeBaseException e) {
            CurrentProject.getInstance().getKnowledgeBase().rollback();
            successful = false;
            this.errorMessage = "An exception happened.";
            throw e;
        }
        return successful;
    }

    @Override
    public void undo() throws CannotUndoException {
        super.undo();
        boolean successful = true;
        try {
            DocumentDAO documentDAO = CurrentProject.getInstance().getFactoryDAO().getDocumentDAO();
            DocumentAffiliationDAO documentAffiliationDAO = CurrentProject.getInstance().getFactoryDAO().getDocumentAffiliationDAO();
            DocumentAuthorDAO documentAuthorDAO = CurrentProject.getInstance().getFactoryDAO().getDocumentAuthorDAO();
            DocumentWordDAO documentWordDAO = CurrentProject.getInstance().getFactoryDAO().getDocumentWordDAO();
            DocumentReferenceDAO documentReferenceDAO = CurrentProject.getInstance().getFactoryDAO().getDocumentReferenceDAO();
            TreeSet<DocumentAuthor> tmpDocumentAuthors = new TreeSet<DocumentAuthor>(documentDAO.getDocumentAuthors(this.targetDocument.getDocumentID()));
            tmpDocumentAuthors.removeAll(this.documentAuthorsOfTarget);
            Iterator<DocumentAuthor> itDocumentAuthor = tmpDocumentAuthors.iterator();
            while (itDocumentAuthor.hasNext() && successful) {
                successful = documentAuthorDAO.removeDocumentAuthor(this.targetDocument.getDocumentID(), itDocumentAuthor.next().getAuthor().getAuthorID(), true);
            }
            TreeSet<DocumentWord> tmpDocumentWords = new TreeSet<DocumentWord>(documentDAO.getDocumentWords(this.targetDocument.getDocumentID()));
            tmpDocumentWords.removeAll(this.documentWordsOfTarget);
            Iterator<DocumentWord> itDocumentWord = tmpDocumentWords.iterator();
            while (itDocumentWord.hasNext() && successful) {
                successful = documentWordDAO.removeDocumentWord(this.targetDocument.getDocumentID(), itDocumentWord.next().getWord().getWordID(), true);
            }
            TreeSet<Affiliation> tmpAffiliations = new TreeSet<Affiliation>(documentDAO.getAffiliations(this.targetDocument.getDocumentID()));
            tmpAffiliations.removeAll(this.affiliationsOfTarget);
            Iterator<Affiliation> itAffiliation = tmpAffiliations.iterator();
            while (itAffiliation.hasNext() && successful) {
                successful = documentAffiliationDAO.removeDocumentAffiliation(this.targetDocument.getDocumentID(), itAffiliation.next().getAffiliationID(), true);
            }
            TreeSet<Reference> tmpReferences = new TreeSet<Reference>(documentDAO.getReferences(this.targetDocument.getDocumentID()));
            tmpReferences.removeAll(this.referencesOfTarget);
            Iterator<Reference> itReference = tmpReferences.iterator();
            while (itReference.hasNext() && successful) {
                successful = documentReferenceDAO.removeDocumentReference(this.targetDocument.getDocumentID(), itReference.next().getReferenceID(), true);
            }
            for (int i = 0; i < this.documentsToMove.size() && successful; ++i) {
                int j;
                Document document = this.documentsToMove.get(i);
                successful = documentDAO.addDocument(document, true);
                for (j = 0; j < this.documentWordsOfSources.get(i).size() && successful; ++j) {
                    DocumentWord documentWord = this.documentWordsOfSources.get(i).get(j);
                    successful = documentWordDAO.addDocumentWord(document.getDocumentID(), documentWord.getWord().getWordID(), documentWord.isAuthorKeyword(), documentWord.isSourceKeyword(), documentWord.isAddedKeyword(), true);
                }
                for (j = 0; j < this.documentAuthorsOfSources.get(i).size() && successful; ++j) {
                    DocumentAuthor documentAuthor = this.documentAuthorsOfSources.get(i).get(j);
                    successful = documentAuthorDAO.addDocumentAuthor(document.getDocumentID(), documentAuthor.getAuthor().getAuthorID(), documentAuthor.getPosition(), true);
                }
                for (j = 0; j < this.affiliationsOfSources.get(i).size() && successful; ++j) {
                    successful = documentAffiliationDAO.addDocumentAffiliation(document.getDocumentID(), this.affiliationsOfSources.get(i).get(j).getAffiliationID(), true);
                }
                for (j = 0; j < this.referencesOfSources.get(i).size() && successful; ++j) {
                    successful = documentReferenceDAO.addDocumentReference(document.getDocumentID(), this.referencesOfSources.get(i).get(j).getReferenceID(), true);
                }
                if (this.journalOfSources.get(i) != null && successful) {
                    successful = documentDAO.setJournal(document.getDocumentID(), this.journalOfSources.get(i).getJournalID(), true);
                }
                if (this.publishDateOfSources.get(i) == null || !successful) continue;
                successful = documentDAO.setPublishDate(document.getDocumentID(), this.publishDateOfSources.get(i).getPublishDateID(), true);
            }
            if (successful) {
                CurrentProject.getInstance().getKnowledgeBase().commit();
                KnowledgeBaseEventsReceiver.getInstance().fireEvents();
            } else {
                CurrentProject.getInstance().getKnowledgeBase().rollback();
            }
        }
        catch (KnowledgeBaseException e) {
            e.printStackTrace(System.err);
            try {
                CurrentProject.getInstance().getKnowledgeBase().rollback();
            }
            catch (KnowledgeBaseException e2) {
                e2.printStackTrace(System.err);
            }
        }
    }

    @Override
    public void redo() throws CannotUndoException {
        super.redo();
        boolean successful = true;
        try {
            DocumentDAO documentDAO = CurrentProject.getInstance().getFactoryDAO().getDocumentDAO();
            DocumentAuthorDAO documentAuthorDAO = CurrentProject.getInstance().getFactoryDAO().getDocumentAuthorDAO();
            DocumentAffiliationDAO documentAffiliationDAO = CurrentProject.getInstance().getFactoryDAO().getDocumentAffiliationDAO();
            DocumentWordDAO documentWordDAO = CurrentProject.getInstance().getFactoryDAO().getDocumentWordDAO();
            DocumentReferenceDAO documentReferenceDAO = CurrentProject.getInstance().getFactoryDAO().getDocumentReferenceDAO();
            for (int i = 0; i < this.documentsToMove.size() && successful; ++i) {
                int j;
                Document document = this.documentsToMove.get(i);
                ArrayList<DocumentWord> documentWords = this.documentWordsOfSources.get(i);
                ArrayList<DocumentAuthor> documentAuthors = this.documentAuthorsOfSources.get(i);
                ArrayList<Affiliation> affiliations = this.affiliationsOfSources.get(i);
                ArrayList<Reference> references = this.referencesOfSources.get(i);
                successful = documentDAO.removeDocument(document.getDocumentID(), true);
                for (j = 0; j < documentWords.size() && successful; ++j) {
                    DocumentWord documentWord = documentWords.get(j);
                    if (documentWordDAO.checkDocumentWord(this.targetDocument.getDocumentID(), documentWord.getWord().getWordID())) continue;
                    successful = documentWordDAO.addDocumentWord(this.targetDocument.getDocumentID(), documentWord.getWord().getWordID(), documentWord.isAuthorKeyword(), documentWord.isSourceKeyword(), documentWord.isAddedKeyword(), true);
                }
                for (j = 0; j < documentAuthors.size() && successful; ++j) {
                    DocumentAuthor documentAuthor = documentAuthors.get(j);
                    if (documentAuthorDAO.checkDocumentAuthor(this.targetDocument.getDocumentID(), documentAuthor.getAuthor().getAuthorID())) continue;
                    successful = documentAuthorDAO.addDocumentAuthor(this.targetDocument.getDocumentID(), documentAuthor.getAuthor().getAuthorID(), documentAuthor.getPosition(), true);
                }
                for (j = 0; j < affiliations.size() && successful; ++j) {
                    if (documentAffiliationDAO.checkDocumentAffiliation(this.targetDocument.getDocumentID(), affiliations.get(j).getAffiliationID())) continue;
                    successful = documentAffiliationDAO.addDocumentAffiliation(this.targetDocument.getDocumentID(), affiliations.get(j).getAffiliationID(), true);
                }
                for (j = 0; j < references.size() && successful; ++j) {
                    if (documentReferenceDAO.checkDocumentReference(this.targetDocument.getDocumentID(), references.get(j).getReferenceID())) continue;
                    successful = documentReferenceDAO.addDocumentReference(this.targetDocument.getDocumentID(), references.get(j).getReferenceID(), true);
                }
            }
            if (successful) {
                CurrentProject.getInstance().getKnowledgeBase().commit();
                KnowledgeBaseEventsReceiver.getInstance().fireEvents();
            } else {
                CurrentProject.getInstance().getKnowledgeBase().rollback();
            }
        }
        catch (KnowledgeBaseException e) {
            e.printStackTrace(System.err);
            try {
                CurrentProject.getInstance().getKnowledgeBase().rollback();
            }
            catch (KnowledgeBaseException e2) {
                e2.printStackTrace(System.err);
            }
        }
    }
}

