/*
 * Decompiled with CFR 0.152.
 */
package scimat.gui.commands.edit.join;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.TreeSet;
import javax.swing.undo.CannotUndoException;
import scimat.gui.commands.edit.KnowledgeBaseEdit;
import scimat.gui.undostack.UndoStack;
import scimat.knowledgebaseevents.KnowledgeBaseEventsReceiver;
import scimat.model.knowledgebase.dao.AuthorReferenceDAO;
import scimat.model.knowledgebase.dao.AuthorReferenceGroupDAO;
import scimat.model.knowledgebase.entity.AuthorReference;
import scimat.model.knowledgebase.entity.AuthorReferenceGroup;
import scimat.model.knowledgebase.exception.KnowledgeBaseException;
import scimat.project.CurrentProject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JoinAuthorReferenceGroupEdit
extends KnowledgeBaseEdit {
    private ArrayList<AuthorReferenceGroup> authorReferenceGroupsToMove;
    private AuthorReferenceGroup targetAuthorReferenceGroup;
    private ArrayList<ArrayList<AuthorReference>> authorReferencesOfSources = new ArrayList();
    private TreeSet<AuthorReference> authorReferencesOfTarget = new TreeSet();

    public JoinAuthorReferenceGroupEdit(ArrayList<AuthorReferenceGroup> authorReferenceGroupsToMove, AuthorReferenceGroup targetAuthorReferenceGroup) {
        this.authorReferenceGroupsToMove = authorReferenceGroupsToMove;
        this.targetAuthorReferenceGroup = targetAuthorReferenceGroup;
    }

    @Override
    public boolean execute() throws KnowledgeBaseException {
        boolean successful = true;
        try {
            AuthorReferenceDAO authorReferenceDAO = CurrentProject.getInstance().getFactoryDAO().getAuthorReferenceDAO();
            AuthorReferenceGroupDAO authorReferenceGroupDAO = CurrentProject.getInstance().getFactoryDAO().getAuthorReferenceGroupDAO();
            this.authorReferencesOfTarget = new TreeSet<AuthorReference>(authorReferenceGroupDAO.getAuthorReferences(this.targetAuthorReferenceGroup.getAuthorReferenceGroupID()));
            for (int i = 0; i < this.authorReferenceGroupsToMove.size() && successful; ++i) {
                AuthorReferenceGroup authorReferenceGroup = this.authorReferenceGroupsToMove.get(i);
                ArrayList<AuthorReference> authorReferences = authorReferenceGroupDAO.getAuthorReferences(authorReferenceGroup.getAuthorReferenceGroupID());
                this.authorReferencesOfSources.add(authorReferences);
                successful = authorReferenceGroupDAO.removeAuthorReferenceGroup(authorReferenceGroup.getAuthorReferenceGroupID(), true);
                for (int j = 0; j < authorReferences.size() && successful; ++j) {
                    successful = authorReferenceDAO.setAuthorReferenceGroup(authorReferences.get(j).getAuthorReferenceID(), this.targetAuthorReferenceGroup.getAuthorReferenceGroupID(), true);
                }
            }
            if (successful) {
                CurrentProject.getInstance().getKnowledgeBase().commit();
                KnowledgeBaseEventsReceiver.getInstance().fireEvents();
                UndoStack.addEdit(this);
            } else {
                CurrentProject.getInstance().getKnowledgeBase().rollback();
                this.errorMessage = "An error happened";
            }
        }
        catch (KnowledgeBaseException e) {
            CurrentProject.getInstance().getKnowledgeBase().rollback();
            successful = false;
            this.errorMessage = "An exception happened.";
            throw e;
        }
        return successful;
    }

    @Override
    public void undo() throws CannotUndoException {
        super.undo();
        boolean successful = true;
        try {
            AuthorReferenceGroupDAO authorReferenceGroupDAO = CurrentProject.getInstance().getFactoryDAO().getAuthorReferenceGroupDAO();
            AuthorReferenceDAO authorReferenceDAO = CurrentProject.getInstance().getFactoryDAO().getAuthorReferenceDAO();
            TreeSet<AuthorReference> tmpAuthorReferences = new TreeSet<AuthorReference>(authorReferenceGroupDAO.getAuthorReferences(this.targetAuthorReferenceGroup.getAuthorReferenceGroupID()));
            tmpAuthorReferences.removeAll(this.authorReferencesOfTarget);
            Iterator<AuthorReference> itAuthorReference = tmpAuthorReferences.iterator();
            while (itAuthorReference.hasNext() && successful) {
                successful = authorReferenceDAO.setAuthorReferenceGroup(itAuthorReference.next().getAuthorReferenceID(), null, true);
            }
            for (int i = 0; i < this.authorReferenceGroupsToMove.size() && successful; ++i) {
                AuthorReferenceGroup authorReferenceGroup = this.authorReferenceGroupsToMove.get(i);
                successful = authorReferenceGroupDAO.addAuthorReferenceGroup(authorReferenceGroup, true);
                for (int j = 0; j < this.authorReferencesOfSources.get(i).size() && successful; ++j) {
                    AuthorReference authorReference = this.authorReferencesOfSources.get(i).get(j);
                    successful = authorReferenceDAO.setAuthorReferenceGroup(authorReference.getAuthorReferenceID(), authorReferenceGroup.getAuthorReferenceGroupID(), true);
                }
            }
            if (successful) {
                CurrentProject.getInstance().getKnowledgeBase().commit();
                KnowledgeBaseEventsReceiver.getInstance().fireEvents();
            } else {
                CurrentProject.getInstance().getKnowledgeBase().rollback();
            }
        }
        catch (KnowledgeBaseException e) {
            e.printStackTrace(System.err);
            try {
                CurrentProject.getInstance().getKnowledgeBase().rollback();
            }
            catch (KnowledgeBaseException e2) {
                e2.printStackTrace(System.err);
            }
        }
    }

    @Override
    public void redo() throws CannotUndoException {
        super.redo();
        boolean successful = true;
        try {
            AuthorReferenceDAO authorReferenceDAO = CurrentProject.getInstance().getFactoryDAO().getAuthorReferenceDAO();
            AuthorReferenceGroupDAO authorReferenceGroupDAO = CurrentProject.getInstance().getFactoryDAO().getAuthorReferenceGroupDAO();
            for (int i = 0; i < this.authorReferenceGroupsToMove.size() && successful; ++i) {
                AuthorReferenceGroup authorReferenceGroup = this.authorReferenceGroupsToMove.get(i);
                ArrayList<AuthorReference> authorReferences = this.authorReferencesOfSources.get(i);
                successful = authorReferenceGroupDAO.removeAuthorReferenceGroup(authorReferenceGroup.getAuthorReferenceGroupID(), true);
                for (int j = 0; j < authorReferences.size() && successful; ++j) {
                    successful = authorReferenceDAO.setAuthorReferenceGroup(authorReferences.get(j).getAuthorReferenceID(), this.targetAuthorReferenceGroup.getAuthorReferenceGroupID(), true);
                }
            }
            if (successful) {
                CurrentProject.getInstance().getKnowledgeBase().commit();
                KnowledgeBaseEventsReceiver.getInstance().fireEvents();
                UndoStack.addEdit(this);
            } else {
                CurrentProject.getInstance().getKnowledgeBase().rollback();
            }
        }
        catch (KnowledgeBaseException e) {
            e.printStackTrace(System.err);
            try {
                CurrentProject.getInstance().getKnowledgeBase().rollback();
            }
            catch (KnowledgeBaseException e2) {
                e2.printStackTrace(System.err);
            }
        }
    }
}

