/*
 * Decompiled with CFR 0.152.
 */
package scimat.gui.commands.edit.join;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.TreeSet;
import javax.swing.undo.CannotUndoException;
import scimat.gui.commands.edit.KnowledgeBaseEdit;
import scimat.gui.undostack.UndoStack;
import scimat.knowledgebaseevents.KnowledgeBaseEventsReceiver;
import scimat.model.knowledgebase.dao.AuthorReferenceDAO;
import scimat.model.knowledgebase.dao.AuthorReferenceReferenceDAO;
import scimat.model.knowledgebase.entity.Author;
import scimat.model.knowledgebase.entity.AuthorReference;
import scimat.model.knowledgebase.entity.AuthorReferenceGroup;
import scimat.model.knowledgebase.entity.AuthorReferenceReference;
import scimat.model.knowledgebase.exception.KnowledgeBaseException;
import scimat.project.CurrentProject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JoinAuthorReferenceEdit
extends KnowledgeBaseEdit {
    private ArrayList<AuthorReference> authorReferencesToMove;
    private AuthorReference targetAuthorReference;
    private ArrayList<ArrayList<AuthorReferenceReference>> authorReferenceReferenceOfSources = new ArrayList();
    private ArrayList<AuthorReferenceGroup> authorReferenceGroupOfSources = new ArrayList();
    private ArrayList<Author> authorOfSources = new ArrayList();
    private TreeSet<AuthorReferenceReference> authorReferenceReferenceOfTarget = new TreeSet();

    public JoinAuthorReferenceEdit(ArrayList<AuthorReference> authorReferencesToMove, AuthorReference targetAuthorReference) {
        this.authorReferencesToMove = authorReferencesToMove;
        this.targetAuthorReference = targetAuthorReference;
    }

    @Override
    public boolean execute() throws KnowledgeBaseException {
        boolean successful = true;
        try {
            AuthorReferenceDAO authorReferenceDAO = CurrentProject.getInstance().getFactoryDAO().getAuthorReferenceDAO();
            AuthorReferenceReferenceDAO authorReferenceReferenceDAO = CurrentProject.getInstance().getFactoryDAO().getAuthorReferenceReferenceDAO();
            this.authorReferenceReferenceOfTarget = new TreeSet<AuthorReferenceReference>(authorReferenceDAO.getReferences(this.targetAuthorReference.getAuthorReferenceID()));
            for (int i = 0; i < this.authorReferencesToMove.size() && successful; ++i) {
                AuthorReference authorReference = this.authorReferencesToMove.get(i);
                ArrayList<AuthorReferenceReference> authorReferenceReferences = authorReferenceDAO.getReferences(authorReference.getAuthorReferenceID());
                this.authorReferenceReferenceOfSources.add(authorReferenceReferences);
                this.authorReferenceGroupOfSources.add(authorReferenceDAO.getAuthorReferenceGroup(authorReference.getAuthorReferenceID()));
                this.authorOfSources.add(authorReferenceDAO.getAuthor(authorReference.getAuthorReferenceID()));
                successful = authorReferenceDAO.removeAuthorReference(authorReference.getAuthorReferenceID(), true);
                for (int j = 0; j < authorReferenceReferences.size() && successful; ++j) {
                    AuthorReferenceReference authorReferenceReference = authorReferenceReferences.get(j);
                    if (authorReferenceReferenceDAO.checkAuthorReferenceReference(this.targetAuthorReference.getAuthorReferenceID(), authorReferenceReference.getAuthorReference().getAuthorReferenceID())) continue;
                    successful = authorReferenceReferenceDAO.addAuthorReferenceReference(authorReferenceReference.getAuthorReference().getAuthorReferenceID(), this.targetAuthorReference.getAuthorReferenceID(), authorReferenceReference.getPosition(), true);
                }
            }
            if (successful) {
                CurrentProject.getInstance().getKnowledgeBase().commit();
                KnowledgeBaseEventsReceiver.getInstance().fireEvents();
                UndoStack.addEdit(this);
            } else {
                CurrentProject.getInstance().getKnowledgeBase().rollback();
                this.errorMessage = "An error happened";
            }
        }
        catch (KnowledgeBaseException e) {
            CurrentProject.getInstance().getKnowledgeBase().rollback();
            successful = false;
            this.errorMessage = "An exception happened.";
            throw e;
        }
        return successful;
    }

    @Override
    public void undo() throws CannotUndoException {
        super.undo();
        boolean successful = true;
        try {
            AuthorReferenceReferenceDAO authorReferenceReferenceDAO = CurrentProject.getInstance().getFactoryDAO().getAuthorReferenceReferenceDAO();
            AuthorReferenceDAO authorReferenceDAO = CurrentProject.getInstance().getFactoryDAO().getAuthorReferenceDAO();
            TreeSet<AuthorReferenceReference> tmpAuthorReferenceReferences = new TreeSet<AuthorReferenceReference>(authorReferenceDAO.getReferences(this.targetAuthorReference.getAuthorReferenceID()));
            tmpAuthorReferenceReferences.removeAll(this.authorReferenceReferenceOfTarget);
            Iterator<AuthorReferenceReference> itAuthorReferenceReference = tmpAuthorReferenceReferences.iterator();
            while (itAuthorReferenceReference.hasNext() && successful) {
                successful = authorReferenceReferenceDAO.removeAuthorReferenceReference(itAuthorReferenceReference.next().getAuthorReference().getAuthorReferenceID(), this.targetAuthorReference.getAuthorReferenceID(), true);
            }
            for (int i = 0; i < this.authorReferencesToMove.size() && successful; ++i) {
                AuthorReference authorReference = this.authorReferencesToMove.get(i);
                successful = authorReferenceDAO.addAuthorReference(authorReference, true);
                for (int j = 0; j < this.authorReferenceReferenceOfSources.get(i).size() && successful; ++j) {
                    AuthorReferenceReference authorReferenceReference = this.authorReferenceReferenceOfSources.get(i).get(j);
                    successful = authorReferenceReferenceDAO.addAuthorReferenceReference(authorReferenceReference.getAuthorReference().getAuthorReferenceID(), authorReference.getAuthorReferenceID(), authorReferenceReference.getPosition(), true);
                }
                if (this.authorReferenceGroupOfSources.get(i) != null && successful) {
                    successful = authorReferenceDAO.setAuthorReferenceGroup(authorReference.getAuthorReferenceID(), this.authorReferenceGroupOfSources.get(i).getAuthorReferenceGroupID(), true);
                }
                if (this.authorOfSources.get(i) == null || !successful) continue;
                successful = authorReferenceDAO.setAuthor(authorReference.getAuthorReferenceID(), this.authorOfSources.get(i).getAuthorID(), true);
            }
            if (successful) {
                CurrentProject.getInstance().getKnowledgeBase().commit();
                KnowledgeBaseEventsReceiver.getInstance().fireEvents();
            } else {
                CurrentProject.getInstance().getKnowledgeBase().rollback();
            }
        }
        catch (KnowledgeBaseException e) {
            e.printStackTrace(System.err);
            try {
                CurrentProject.getInstance().getKnowledgeBase().rollback();
            }
            catch (KnowledgeBaseException e2) {
                e2.printStackTrace(System.err);
            }
        }
    }

    @Override
    public void redo() throws CannotUndoException {
        super.redo();
        boolean successful = true;
        try {
            AuthorReferenceDAO authorReferenceDAO = CurrentProject.getInstance().getFactoryDAO().getAuthorReferenceDAO();
            AuthorReferenceReferenceDAO authorReferenceReferenceDAO = CurrentProject.getInstance().getFactoryDAO().getAuthorReferenceReferenceDAO();
            for (int i = 0; i < this.authorReferencesToMove.size() && successful; ++i) {
                AuthorReference authorReference = this.authorReferencesToMove.get(i);
                ArrayList<AuthorReferenceReference> authorReferenceReferences = this.authorReferenceReferenceOfSources.get(i);
                successful = authorReferenceDAO.removeAuthorReference(authorReference.getAuthorReferenceID(), true);
                for (int j = 0; j < authorReferenceReferences.size() && successful; ++j) {
                    AuthorReferenceReference authorReferenceReference = authorReferenceReferences.get(j);
                    if (authorReferenceReferenceDAO.checkAuthorReferenceReference(this.targetAuthorReference.getAuthorReferenceID(), authorReferenceReference.getAuthorReference().getAuthorReferenceID())) continue;
                    successful = authorReferenceReferenceDAO.addAuthorReferenceReference(authorReferenceReference.getAuthorReference().getAuthorReferenceID(), this.targetAuthorReference.getAuthorReferenceID(), authorReferenceReference.getPosition(), true);
                }
            }
            if (successful) {
                CurrentProject.getInstance().getKnowledgeBase().commit();
                KnowledgeBaseEventsReceiver.getInstance().fireEvents();
            } else {
                CurrentProject.getInstance().getKnowledgeBase().rollback();
            }
        }
        catch (KnowledgeBaseException e) {
            e.printStackTrace(System.err);
            try {
                CurrentProject.getInstance().getKnowledgeBase().rollback();
            }
            catch (KnowledgeBaseException e2) {
                e2.printStackTrace(System.err);
            }
        }
    }
}

