/*
 * Decompiled with CFR 0.152.
 */
package scimat.gui.commands.edit.join;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.TreeSet;
import javax.swing.undo.CannotUndoException;
import scimat.gui.commands.edit.KnowledgeBaseEdit;
import scimat.gui.undostack.UndoStack;
import scimat.knowledgebaseevents.KnowledgeBaseEventsReceiver;
import scimat.model.knowledgebase.dao.AuthorDAO;
import scimat.model.knowledgebase.dao.AuthorGroupDAO;
import scimat.model.knowledgebase.entity.Author;
import scimat.model.knowledgebase.entity.AuthorGroup;
import scimat.model.knowledgebase.exception.KnowledgeBaseException;
import scimat.project.CurrentProject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JoinAuthorGroupEdit
extends KnowledgeBaseEdit {
    private ArrayList<AuthorGroup> authorGroupsToMove;
    private AuthorGroup targetAuthorGroup;
    private ArrayList<ArrayList<Author>> authorsOfSources = new ArrayList();
    private TreeSet<Author> authorsOfTarget = new TreeSet();

    public JoinAuthorGroupEdit(ArrayList<AuthorGroup> authorGroupsToMove, AuthorGroup targetAuthorGroup) {
        this.authorGroupsToMove = authorGroupsToMove;
        this.targetAuthorGroup = targetAuthorGroup;
    }

    @Override
    public boolean execute() throws KnowledgeBaseException {
        boolean successful = true;
        try {
            AuthorDAO authorDAO = CurrentProject.getInstance().getFactoryDAO().getAuthorDAO();
            AuthorGroupDAO authorGroupDAO = CurrentProject.getInstance().getFactoryDAO().getAuthorGroupDAO();
            this.authorsOfTarget = new TreeSet<Author>(authorGroupDAO.getAuthors(this.targetAuthorGroup.getAuthorGroupID()));
            for (int i = 0; i < this.authorGroupsToMove.size() && successful; ++i) {
                AuthorGroup authorGroup = this.authorGroupsToMove.get(i);
                ArrayList<Author> authors = authorGroupDAO.getAuthors(authorGroup.getAuthorGroupID());
                this.authorsOfSources.add(authors);
                successful = authorGroupDAO.removeAuthorGroup(authorGroup.getAuthorGroupID(), true);
                for (int j = 0; j < authors.size() && successful; ++j) {
                    successful = authorDAO.setAuthorGroup(authors.get(j).getAuthorID(), this.targetAuthorGroup.getAuthorGroupID(), true);
                }
            }
            if (successful) {
                CurrentProject.getInstance().getKnowledgeBase().commit();
                KnowledgeBaseEventsReceiver.getInstance().fireEvents();
                UndoStack.addEdit(this);
            } else {
                CurrentProject.getInstance().getKnowledgeBase().rollback();
                this.errorMessage = "An error happened";
            }
        }
        catch (KnowledgeBaseException e) {
            CurrentProject.getInstance().getKnowledgeBase().rollback();
            successful = false;
            this.errorMessage = "An exception happened.";
            throw e;
        }
        return successful;
    }

    @Override
    public void undo() throws CannotUndoException {
        super.undo();
        boolean successful = true;
        try {
            AuthorGroupDAO authorGroupDAO = CurrentProject.getInstance().getFactoryDAO().getAuthorGroupDAO();
            AuthorDAO authorDAO = CurrentProject.getInstance().getFactoryDAO().getAuthorDAO();
            TreeSet<Author> tmpAuthors = new TreeSet<Author>(authorGroupDAO.getAuthors(this.targetAuthorGroup.getAuthorGroupID()));
            tmpAuthors.removeAll(this.authorsOfTarget);
            Iterator<Author> itAuthor = tmpAuthors.iterator();
            while (itAuthor.hasNext() && successful) {
                successful = authorDAO.setAuthorGroup(itAuthor.next().getAuthorID(), null, true);
            }
            for (int i = 0; i < this.authorGroupsToMove.size() && successful; ++i) {
                AuthorGroup authorGroup = this.authorGroupsToMove.get(i);
                successful = authorGroupDAO.addAuthorGroup(authorGroup, true);
                for (int j = 0; j < this.authorsOfSources.get(i).size() && successful; ++j) {
                    Author author = this.authorsOfSources.get(i).get(j);
                    successful = authorDAO.setAuthorGroup(author.getAuthorID(), authorGroup.getAuthorGroupID(), true);
                }
            }
            if (successful) {
                CurrentProject.getInstance().getKnowledgeBase().commit();
                KnowledgeBaseEventsReceiver.getInstance().fireEvents();
            } else {
                CurrentProject.getInstance().getKnowledgeBase().rollback();
            }
        }
        catch (KnowledgeBaseException e) {
            e.printStackTrace(System.err);
            try {
                CurrentProject.getInstance().getKnowledgeBase().rollback();
            }
            catch (KnowledgeBaseException e2) {
                e2.printStackTrace(System.err);
            }
        }
    }

    @Override
    public void redo() throws CannotUndoException {
        super.redo();
        boolean successful = true;
        try {
            AuthorDAO authorDAO = CurrentProject.getInstance().getFactoryDAO().getAuthorDAO();
            AuthorGroupDAO authorGroupDAO = CurrentProject.getInstance().getFactoryDAO().getAuthorGroupDAO();
            for (int i = 0; i < this.authorGroupsToMove.size() && successful; ++i) {
                AuthorGroup authorGroup = this.authorGroupsToMove.get(i);
                ArrayList<Author> authors = this.authorsOfSources.get(i);
                successful = authorGroupDAO.removeAuthorGroup(authorGroup.getAuthorGroupID(), true);
                for (int j = 0; j < authors.size() && successful; ++j) {
                    successful = authorDAO.setAuthorGroup(authors.get(j).getAuthorID(), this.targetAuthorGroup.getAuthorGroupID(), true);
                }
            }
            if (successful) {
                CurrentProject.getInstance().getKnowledgeBase().commit();
                KnowledgeBaseEventsReceiver.getInstance().fireEvents();
                UndoStack.addEdit(this);
            } else {
                CurrentProject.getInstance().getKnowledgeBase().rollback();
            }
        }
        catch (KnowledgeBaseException e) {
            e.printStackTrace(System.err);
            try {
                CurrentProject.getInstance().getKnowledgeBase().rollback();
            }
            catch (KnowledgeBaseException e2) {
                e2.printStackTrace(System.err);
            }
        }
    }
}

