/*
 * Decompiled with CFR 0.152.
 */
package scimat.gui.commands.edit.join;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.TreeSet;
import javax.swing.undo.CannotUndoException;
import scimat.gui.commands.edit.KnowledgeBaseEdit;
import scimat.gui.undostack.UndoStack;
import scimat.knowledgebaseevents.KnowledgeBaseEventsReceiver;
import scimat.model.knowledgebase.dao.AuthorAffiliationDAO;
import scimat.model.knowledgebase.dao.AuthorDAO;
import scimat.model.knowledgebase.dao.AuthorReferenceDAO;
import scimat.model.knowledgebase.dao.DocumentAuthorDAO;
import scimat.model.knowledgebase.entity.Affiliation;
import scimat.model.knowledgebase.entity.Author;
import scimat.model.knowledgebase.entity.AuthorGroup;
import scimat.model.knowledgebase.entity.AuthorReference;
import scimat.model.knowledgebase.entity.DocumentAuthor;
import scimat.model.knowledgebase.exception.KnowledgeBaseException;
import scimat.project.CurrentProject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JoinAuthorEdit
extends KnowledgeBaseEdit {
    private ArrayList<Author> authorsToMove;
    private Author targetAuthor;
    private ArrayList<ArrayList<Affiliation>> affiliationOfSources = new ArrayList();
    private ArrayList<ArrayList<DocumentAuthor>> documentAuthorOfSources = new ArrayList();
    private ArrayList<AuthorGroup> authorGroupOfSources = new ArrayList();
    private ArrayList<AuthorReference> authorReferenceOfSources = new ArrayList();
    private TreeSet<Affiliation> affiliationOfTarget = new TreeSet();
    private TreeSet<DocumentAuthor> documentAuthorOfTarget = new TreeSet();

    public JoinAuthorEdit(ArrayList<Author> authorsToMove, Author targetAuthor) {
        this.authorsToMove = authorsToMove;
        this.targetAuthor = targetAuthor;
    }

    @Override
    public boolean execute() throws KnowledgeBaseException {
        boolean successful = true;
        try {
            AuthorDAO authorDAO = CurrentProject.getInstance().getFactoryDAO().getAuthorDAO();
            AuthorAffiliationDAO authorAffiliationDAO = CurrentProject.getInstance().getFactoryDAO().getAuthorAffiliationDAO();
            DocumentAuthorDAO documentAuthorDAO = CurrentProject.getInstance().getFactoryDAO().getDocumentAuthorDAO();
            AuthorReferenceDAO authorReferenceDAO = CurrentProject.getInstance().getFactoryDAO().getAuthorReferenceDAO();
            this.affiliationOfTarget = new TreeSet<Affiliation>(authorDAO.getAffiliations(this.targetAuthor.getAuthorID()));
            this.documentAuthorOfTarget = new TreeSet<DocumentAuthor>(authorDAO.getDocumentAuthors(this.targetAuthor.getAuthorID()));
            for (int i = 0; i < this.authorsToMove.size() && successful; ++i) {
                int j;
                Author author = this.authorsToMove.get(i);
                ArrayList<Affiliation> affiliations = authorDAO.getAffiliations(author.getAuthorID());
                this.affiliationOfSources.add(affiliations);
                ArrayList<DocumentAuthor> documentAuthors = authorDAO.getDocumentAuthors(author.getAuthorID());
                this.documentAuthorOfSources.add(documentAuthors);
                this.authorGroupOfSources.add(authorDAO.getAuthorGroup(author.getAuthorID()));
                AuthorReference authorReference = authorDAO.getAuthorReference(author.getAuthorID());
                this.authorReferenceOfSources.add(authorReference);
                successful = authorDAO.removeAuthor(author.getAuthorID(), true);
                for (j = 0; j < affiliations.size() && successful; ++j) {
                    if (authorAffiliationDAO.checkAuthorAffiliation(this.targetAuthor.getAuthorID(), affiliations.get(j).getAffiliationID())) continue;
                    successful = authorAffiliationDAO.addAuthorAffiliation(this.targetAuthor.getAuthorID(), affiliations.get(j).getAffiliationID(), true);
                }
                for (j = 0; j < documentAuthors.size() && successful; ++j) {
                    DocumentAuthor documentAuthor = documentAuthors.get(j);
                    if (documentAuthorDAO.checkDocumentAuthor(documentAuthor.getDocument().getDocumentID(), this.targetAuthor.getAuthorID())) continue;
                    successful = documentAuthorDAO.addDocumentAuthor(documentAuthor.getDocument().getDocumentID(), this.targetAuthor.getAuthorID(), documentAuthor.getPosition(), true);
                }
                if (authorReference == null || !successful) continue;
                successful = authorReferenceDAO.setAuthor(authorReference.getAuthorReferenceID(), this.targetAuthor.getAuthorID(), true);
            }
            if (successful) {
                CurrentProject.getInstance().getKnowledgeBase().commit();
                KnowledgeBaseEventsReceiver.getInstance().fireEvents();
                UndoStack.addEdit(this);
            } else {
                CurrentProject.getInstance().getKnowledgeBase().rollback();
                this.errorMessage = "An error happened";
            }
        }
        catch (KnowledgeBaseException e) {
            CurrentProject.getInstance().getKnowledgeBase().rollback();
            successful = false;
            this.errorMessage = "An exception happened.";
            throw e;
        }
        return successful;
    }

    @Override
    public void undo() throws CannotUndoException {
        super.undo();
        boolean successful = true;
        try {
            AuthorDAO authorDAO = CurrentProject.getInstance().getFactoryDAO().getAuthorDAO();
            AuthorAffiliationDAO authorAffiliationDAO = CurrentProject.getInstance().getFactoryDAO().getAuthorAffiliationDAO();
            DocumentAuthorDAO documentAuthorDAO = CurrentProject.getInstance().getFactoryDAO().getDocumentAuthorDAO();
            AuthorReferenceDAO authorReferenceDAO = CurrentProject.getInstance().getFactoryDAO().getAuthorReferenceDAO();
            TreeSet<Affiliation> tmpAffiliations = new TreeSet<Affiliation>(authorDAO.getAffiliations(this.targetAuthor.getAuthorID()));
            tmpAffiliations.removeAll(this.affiliationOfTarget);
            Iterator<Affiliation> itAffiliation = tmpAffiliations.iterator();
            while (itAffiliation.hasNext() && successful) {
                successful = authorAffiliationDAO.removeAuthorAffiliation(this.targetAuthor.getAuthorID(), itAffiliation.next().getAffiliationID(), true);
            }
            TreeSet<DocumentAuthor> tmpDocumentAuthors = new TreeSet<DocumentAuthor>(authorDAO.getDocumentAuthors(this.targetAuthor.getAuthorID()));
            tmpDocumentAuthors.removeAll(this.documentAuthorOfTarget);
            Iterator<DocumentAuthor> itDocumentAuthor = tmpDocumentAuthors.iterator();
            while (itDocumentAuthor.hasNext() && successful) {
                successful = documentAuthorDAO.removeDocumentAuthor(itDocumentAuthor.next().getDocument().getDocumentID(), this.targetAuthor.getAuthorID(), true);
            }
            for (int i = 0; i < this.authorsToMove.size() && successful; ++i) {
                int j;
                Author author = this.authorsToMove.get(i);
                successful = authorDAO.addAuthor(author, true);
                for (j = 0; j < this.documentAuthorOfSources.get(i).size() && successful; ++j) {
                    DocumentAuthor documentAuthor = this.documentAuthorOfSources.get(i).get(j);
                    successful = documentAuthorDAO.addDocumentAuthor(documentAuthor.getDocument().getDocumentID(), author.getAuthorID(), documentAuthor.getPosition(), true);
                }
                for (j = 0; j < this.affiliationOfSources.get(i).size() && successful; ++j) {
                    successful = authorAffiliationDAO.addAuthorAffiliation(author.getAuthorID(), this.affiliationOfSources.get(i).get(j).getAffiliationID(), true);
                }
                if (this.authorGroupOfSources.get(i) != null && successful) {
                    successful = authorDAO.setAuthorGroup(author.getAuthorID(), this.authorGroupOfSources.get(i).getAuthorGroupID(), true);
                }
                if (this.authorReferenceOfSources.get(i) == null || !successful) continue;
                successful = authorReferenceDAO.setAuthor(this.authorReferenceOfSources.get(i).getAuthorReferenceID(), author.getAuthorID(), true);
            }
            if (successful) {
                CurrentProject.getInstance().getKnowledgeBase().commit();
                KnowledgeBaseEventsReceiver.getInstance().fireEvents();
            } else {
                CurrentProject.getInstance().getKnowledgeBase().rollback();
            }
        }
        catch (KnowledgeBaseException e) {
            e.printStackTrace(System.err);
            try {
                CurrentProject.getInstance().getKnowledgeBase().rollback();
            }
            catch (KnowledgeBaseException e2) {
                e2.printStackTrace(System.err);
            }
        }
    }

    @Override
    public void redo() throws CannotUndoException {
        super.redo();
        boolean successful = true;
        try {
            AuthorDAO authorDAO = CurrentProject.getInstance().getFactoryDAO().getAuthorDAO();
            AuthorAffiliationDAO authorAffiliationDAO = CurrentProject.getInstance().getFactoryDAO().getAuthorAffiliationDAO();
            DocumentAuthorDAO documentAuthorDAO = CurrentProject.getInstance().getFactoryDAO().getDocumentAuthorDAO();
            AuthorReferenceDAO authorReferenceDAO = CurrentProject.getInstance().getFactoryDAO().getAuthorReferenceDAO();
            for (int i = 0; i < this.authorsToMove.size() && successful; ++i) {
                int j;
                Author author = this.authorsToMove.get(i);
                ArrayList<Affiliation> affiliations = this.affiliationOfSources.get(i);
                ArrayList<DocumentAuthor> documentAuthors = this.documentAuthorOfSources.get(i);
                AuthorReference authorReference = this.authorReferenceOfSources.get(i);
                successful = authorDAO.removeAuthor(author.getAuthorID(), true);
                for (j = 0; j < affiliations.size() && successful; ++j) {
                    if (authorAffiliationDAO.checkAuthorAffiliation(this.targetAuthor.getAuthorID(), affiliations.get(j).getAffiliationID())) continue;
                    successful = authorAffiliationDAO.addAuthorAffiliation(this.targetAuthor.getAuthorID(), affiliations.get(j).getAffiliationID(), true);
                }
                for (j = 0; j < documentAuthors.size() && successful; ++j) {
                    DocumentAuthor documentAuthor = documentAuthors.get(j);
                    if (documentAuthorDAO.checkDocumentAuthor(documentAuthor.getDocument().getDocumentID(), this.targetAuthor.getAuthorID())) continue;
                    successful = documentAuthorDAO.addDocumentAuthor(documentAuthor.getDocument().getDocumentID(), this.targetAuthor.getAuthorID(), documentAuthor.getPosition(), true);
                }
                if (authorReference == null || !successful) continue;
                successful = authorReferenceDAO.setAuthor(authorReference.getAuthorReferenceID(), this.targetAuthor.getAuthorID(), true);
            }
            if (successful) {
                CurrentProject.getInstance().getKnowledgeBase().commit();
                KnowledgeBaseEventsReceiver.getInstance().fireEvents();
            } else {
                CurrentProject.getInstance().getKnowledgeBase().rollback();
            }
        }
        catch (KnowledgeBaseException e) {
            e.printStackTrace(System.err);
            try {
                CurrentProject.getInstance().getKnowledgeBase().rollback();
            }
            catch (KnowledgeBaseException e2) {
                e2.printStackTrace(System.err);
            }
        }
    }
}

