/*
 * Decompiled with CFR 0.152.
 */
package scimat.gui.commands.edit.join;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.TreeSet;
import javax.swing.undo.CannotUndoException;
import scimat.gui.commands.edit.KnowledgeBaseEdit;
import scimat.gui.undostack.UndoStack;
import scimat.knowledgebaseevents.KnowledgeBaseEventsReceiver;
import scimat.model.knowledgebase.dao.AffiliationDAO;
import scimat.model.knowledgebase.dao.AuthorAffiliationDAO;
import scimat.model.knowledgebase.dao.DocumentAffiliationDAO;
import scimat.model.knowledgebase.entity.Affiliation;
import scimat.model.knowledgebase.entity.Author;
import scimat.model.knowledgebase.entity.Document;
import scimat.model.knowledgebase.exception.KnowledgeBaseException;
import scimat.project.CurrentProject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JoinAffiliationEdit
extends KnowledgeBaseEdit {
    private ArrayList<Affiliation> affiliationsToMove;
    private Affiliation targetAffiliation;
    private ArrayList<ArrayList<Author>> authorOfSources = new ArrayList();
    private ArrayList<ArrayList<Document>> documentOfSources = new ArrayList();
    private TreeSet<Author> authorsOfTarget = new TreeSet();
    private TreeSet<Document> documentsOfTarget = new TreeSet();

    public JoinAffiliationEdit(ArrayList<Affiliation> affiliationsToMove, Affiliation targetAffiliation) {
        this.affiliationsToMove = affiliationsToMove;
        this.targetAffiliation = targetAffiliation;
    }

    @Override
    public boolean execute() throws KnowledgeBaseException {
        boolean successful = true;
        try {
            AffiliationDAO affiliationDAO = CurrentProject.getInstance().getFactoryDAO().getAffiliationDAO();
            AuthorAffiliationDAO authorAffiliationDAO = CurrentProject.getInstance().getFactoryDAO().getAuthorAffiliationDAO();
            DocumentAffiliationDAO documentAffiliationDAO = CurrentProject.getInstance().getFactoryDAO().getDocumentAffiliationDAO();
            this.authorsOfTarget = new TreeSet<Author>(affiliationDAO.getAuthors(this.targetAffiliation.getAffiliationID()));
            this.documentsOfTarget = new TreeSet<Document>(affiliationDAO.getDocuments(this.targetAffiliation.getAffiliationID()));
            for (int i = 0; i < this.affiliationsToMove.size() && successful; ++i) {
                int j;
                Affiliation affiliation = this.affiliationsToMove.get(i);
                ArrayList<Author> authors = affiliationDAO.getAuthors(affiliation.getAffiliationID());
                this.authorOfSources.add(authors);
                ArrayList<Document> documents = affiliationDAO.getDocuments(affiliation.getAffiliationID());
                this.documentOfSources.add(documents);
                successful = affiliationDAO.removeAffiliation(affiliation.getAffiliationID(), true);
                for (j = 0; j < authors.size() && successful; ++j) {
                    if (authorAffiliationDAO.checkAuthorAffiliation(authors.get(j).getAuthorID(), this.targetAffiliation.getAffiliationID())) continue;
                    successful = authorAffiliationDAO.addAuthorAffiliation(authors.get(j).getAuthorID(), this.targetAffiliation.getAffiliationID(), true);
                }
                for (j = 0; j < documents.size() && successful; ++j) {
                    if (documentAffiliationDAO.checkDocumentAffiliation(documents.get(j).getDocumentID(), this.targetAffiliation.getAffiliationID())) continue;
                    successful = documentAffiliationDAO.addDocumentAffiliation(documents.get(j).getDocumentID(), this.targetAffiliation.getAffiliationID(), true);
                }
            }
            if (successful) {
                CurrentProject.getInstance().getKnowledgeBase().commit();
                KnowledgeBaseEventsReceiver.getInstance().fireEvents();
                UndoStack.addEdit(this);
            } else {
                CurrentProject.getInstance().getKnowledgeBase().rollback();
                this.errorMessage = "An error happened";
            }
        }
        catch (KnowledgeBaseException e) {
            CurrentProject.getInstance().getKnowledgeBase().rollback();
            successful = false;
            this.errorMessage = "An exception happened.";
            throw e;
        }
        return successful;
    }

    @Override
    public void undo() throws CannotUndoException {
        super.undo();
        boolean successful = true;
        try {
            AffiliationDAO affiliationDAO = CurrentProject.getInstance().getFactoryDAO().getAffiliationDAO();
            AuthorAffiliationDAO authorAffiliationDAO = CurrentProject.getInstance().getFactoryDAO().getAuthorAffiliationDAO();
            DocumentAffiliationDAO documentAffiliationDAO = CurrentProject.getInstance().getFactoryDAO().getDocumentAffiliationDAO();
            TreeSet<Author> tmpAuthors = new TreeSet<Author>(affiliationDAO.getAuthors(this.targetAffiliation.getAffiliationID()));
            tmpAuthors.removeAll(this.authorsOfTarget);
            Iterator<Author> itAuthor = tmpAuthors.iterator();
            while (itAuthor.hasNext() && successful) {
                successful = authorAffiliationDAO.removeAuthorAffiliation(itAuthor.next().getAuthorID(), this.targetAffiliation.getAffiliationID(), true);
            }
            TreeSet<Document> tmpDocuments = new TreeSet<Document>(affiliationDAO.getDocuments(this.targetAffiliation.getAffiliationID()));
            tmpDocuments.removeAll(this.documentsOfTarget);
            Iterator<Document> itDocument = tmpDocuments.iterator();
            while (itDocument.hasNext() && successful) {
                successful = documentAffiliationDAO.removeDocumentAffiliation(itDocument.next().getDocumentID(), this.targetAffiliation.getAffiliationID(), true);
            }
            for (int i = 0; i < this.affiliationsToMove.size() && successful; ++i) {
                int j;
                Affiliation affiliation = this.affiliationsToMove.get(i);
                successful = affiliationDAO.addAffiliation(affiliation, true);
                for (j = 0; j < this.documentOfSources.get(i).size() && successful; ++j) {
                    successful = documentAffiliationDAO.addDocumentAffiliation(this.documentOfSources.get(i).get(j).getDocumentID(), affiliation.getAffiliationID(), true);
                }
                for (j = 0; j < this.authorOfSources.get(i).size() && successful; ++j) {
                    successful = authorAffiliationDAO.addAuthorAffiliation(this.authorOfSources.get(i).get(j).getAuthorID(), affiliation.getAffiliationID(), true);
                }
            }
            if (successful) {
                CurrentProject.getInstance().getKnowledgeBase().commit();
                KnowledgeBaseEventsReceiver.getInstance().fireEvents();
            } else {
                CurrentProject.getInstance().getKnowledgeBase().rollback();
            }
        }
        catch (KnowledgeBaseException e) {
            e.printStackTrace(System.err);
            try {
                CurrentProject.getInstance().getKnowledgeBase().rollback();
            }
            catch (KnowledgeBaseException e2) {
                e2.printStackTrace(System.err);
            }
        }
    }

    @Override
    public void redo() throws CannotUndoException {
        super.redo();
        boolean successful = true;
        try {
            AffiliationDAO affiliationDAO = CurrentProject.getInstance().getFactoryDAO().getAffiliationDAO();
            AuthorAffiliationDAO authorAffiliationDAO = CurrentProject.getInstance().getFactoryDAO().getAuthorAffiliationDAO();
            DocumentAffiliationDAO documentAffiliationDAO = CurrentProject.getInstance().getFactoryDAO().getDocumentAffiliationDAO();
            for (int i = 0; i < this.affiliationsToMove.size() && successful; ++i) {
                int j;
                Affiliation affiliation = this.affiliationsToMove.get(i);
                ArrayList<Author> authors = this.authorOfSources.get(i);
                ArrayList<Document> documents = this.documentOfSources.get(i);
                successful = affiliationDAO.removeAffiliation(affiliation.getAffiliationID(), true);
                for (j = 0; j < authors.size() && successful; ++j) {
                    if (authorAffiliationDAO.checkAuthorAffiliation(authors.get(j).getAuthorID(), this.targetAffiliation.getAffiliationID())) continue;
                    successful = authorAffiliationDAO.addAuthorAffiliation(authors.get(j).getAuthorID(), this.targetAffiliation.getAffiliationID(), true);
                }
                for (j = 0; j < documents.size() && successful; ++j) {
                    if (documentAffiliationDAO.checkDocumentAffiliation(documents.get(j).getDocumentID(), this.targetAffiliation.getAffiliationID())) continue;
                    successful = documentAffiliationDAO.addDocumentAffiliation(documents.get(j).getDocumentID(), this.targetAffiliation.getAffiliationID(), true);
                }
            }
            if (successful) {
                CurrentProject.getInstance().getKnowledgeBase().commit();
                KnowledgeBaseEventsReceiver.getInstance().fireEvents();
            } else {
                CurrentProject.getInstance().getKnowledgeBase().rollback();
            }
        }
        catch (KnowledgeBaseException e) {
            e.printStackTrace(System.err);
            try {
                CurrentProject.getInstance().getKnowledgeBase().rollback();
            }
            catch (KnowledgeBaseException e2) {
                e2.printStackTrace(System.err);
            }
        }
    }
}

