/*
 * Decompiled with CFR 0.152.
 */
package scimat.gui.commands.edit.globalreplace;

import java.util.ArrayList;
import scimat.gui.commands.edit.KnowledgeBaseEdit;
import scimat.gui.commands.edit.join.JoinWordEdit;
import scimat.gui.commands.edit.update.UpdateWordEdit;
import scimat.model.knowledgebase.dao.WordDAO;
import scimat.model.knowledgebase.entity.Word;
import scimat.model.knowledgebase.exception.KnowledgeBaseException;
import scimat.project.CurrentProject;

public class GlobalReplaceWordsEdit
extends KnowledgeBaseEdit {
    private String findText;
    private String replaceText;
    private boolean findInWordName;

    public GlobalReplaceWordsEdit(String findText, String replaceText, boolean findInWordName) {
        this.findText = findText;
        this.replaceText = replaceText;
        this.findInWordName = findInWordName;
    }

    public boolean execute() throws KnowledgeBaseException {
        boolean successful = false;
        boolean joined = false;
        boolean updated = false;
        WordDAO wordDAO = CurrentProject.getInstance().getFactoryDAO().getWordDAO();
        try {
            ArrayList<Word> words = wordDAO.getWords();
            for (int i = 0; i < words.size(); ++i) {
                String wordName;
                Word word = words.get(i);
                if (this.findInWordName) {
                    wordName = word.getWordName().replaceAll(this.findText, this.replaceText);
                    updated = updated || !wordName.equals(word.getWordName());
                } else {
                    wordName = word.getWordName();
                    boolean bl = updated ? true : (updated = false);
                }
                if (updated && wordDAO.checkWord(wordName)) {
                    ArrayList<Word> tmpArray = new ArrayList<Word>();
                    tmpArray.add(word);
                    successful = new JoinWordEdit(tmpArray, wordDAO.getWord(wordName)).execute();
                    joined = true;
                }
                if (joined || !updated) continue;
                successful = new UpdateWordEdit(word.getWordID(), wordName).execute();
            }
        }
        catch (KnowledgeBaseException e) {
            successful = false;
            this.errorMessage = "An exception happened.";
            throw e;
        }
        return successful;
    }
}

