/*
 * Decompiled with CFR 0.152.
 */
package scimat.gui.commands.edit.globalreplace;

import java.util.ArrayList;
import scimat.gui.commands.edit.KnowledgeBaseEdit;
import scimat.gui.commands.edit.join.JoinWordGroupEdit;
import scimat.gui.commands.edit.update.UpdateWordGroupEdit;
import scimat.model.knowledgebase.dao.WordGroupDAO;
import scimat.model.knowledgebase.entity.WordGroup;
import scimat.model.knowledgebase.exception.KnowledgeBaseException;
import scimat.project.CurrentProject;

public class GlobalReplaceWordGroupsEdit
extends KnowledgeBaseEdit {
    private String findText;
    private String replaceText;
    private boolean findInGroupName;

    public GlobalReplaceWordGroupsEdit(String findText, String replaceText, boolean findInGroupName) {
        this.findText = findText;
        this.replaceText = replaceText;
        this.findInGroupName = findInGroupName;
    }

    public boolean execute() throws KnowledgeBaseException {
        boolean successful = false;
        boolean joined = false;
        boolean updated = false;
        WordGroupDAO wordGroupDAO = CurrentProject.getInstance().getFactoryDAO().getWordGroupDAO();
        try {
            ArrayList<WordGroup> wordGroups = wordGroupDAO.getWordGroups();
            for (int i = 0; i < wordGroups.size(); ++i) {
                String groupName;
                WordGroup wordGroup = wordGroups.get(i);
                if (this.findInGroupName) {
                    groupName = wordGroup.getGroupName().replaceAll(this.findText, this.replaceText);
                    updated = updated || !groupName.equals(wordGroup.getGroupName());
                } else {
                    groupName = wordGroup.getGroupName();
                    boolean bl = updated ? true : (updated = false);
                }
                if (updated && wordGroupDAO.checkWordGroup(groupName)) {
                    ArrayList<WordGroup> tmpArray = new ArrayList<WordGroup>();
                    tmpArray.add(wordGroup);
                    successful = new JoinWordGroupEdit(tmpArray, wordGroupDAO.getWordGroup(groupName)).execute();
                    joined = true;
                }
                if (joined || !updated) continue;
                successful = new UpdateWordGroupEdit(wordGroup.getWordGroupID(), groupName, wordGroup.isStopGroup()).execute();
            }
        }
        catch (KnowledgeBaseException e) {
            successful = false;
            this.errorMessage = "An exception happened.";
            throw e;
        }
        return successful;
    }
}

