/*
 * Decompiled with CFR 0.152.
 */
package scimat.gui.commands.edit.globalreplace;

import java.util.ArrayList;
import scimat.gui.commands.edit.KnowledgeBaseEdit;
import scimat.gui.commands.edit.join.JoinSubjectCategoryEdit;
import scimat.gui.commands.edit.update.UpdateSubjectCategoryEdit;
import scimat.model.knowledgebase.dao.SubjectCategoryDAO;
import scimat.model.knowledgebase.entity.SubjectCategory;
import scimat.model.knowledgebase.exception.KnowledgeBaseException;
import scimat.project.CurrentProject;

public class GlobalReplaceSubjectCategoriesEdit
extends KnowledgeBaseEdit {
    private String findText;
    private String replaceText;
    private boolean findInSubjectCategoryName;

    public GlobalReplaceSubjectCategoriesEdit(String findText, String replaceText, boolean findInSubjectCategoryName) {
        this.findText = findText;
        this.replaceText = replaceText;
        this.findInSubjectCategoryName = findInSubjectCategoryName;
    }

    public boolean execute() throws KnowledgeBaseException {
        boolean successful = false;
        boolean joined = false;
        boolean updated = false;
        SubjectCategoryDAO subjectCategoryDAO = CurrentProject.getInstance().getFactoryDAO().getSubjectCategoryDAO();
        try {
            ArrayList<SubjectCategory> subjectCategoryies = subjectCategoryDAO.getSubjectCategories();
            for (int i = 0; i < subjectCategoryies.size(); ++i) {
                String subjectCategoryName;
                SubjectCategory subjectCategory = subjectCategoryies.get(i);
                if (this.findInSubjectCategoryName) {
                    subjectCategoryName = subjectCategory.getSubjectCategoryName().replaceAll(this.findText, this.replaceText);
                    updated = updated || !subjectCategoryName.equals(subjectCategory.getSubjectCategoryName());
                } else {
                    subjectCategoryName = subjectCategory.getSubjectCategoryName();
                    boolean bl = updated ? true : (updated = false);
                }
                if (updated && subjectCategoryDAO.checkSubjectCategory(subjectCategoryName)) {
                    ArrayList<SubjectCategory> tmpArray = new ArrayList<SubjectCategory>();
                    tmpArray.add(subjectCategory);
                    successful = new JoinSubjectCategoryEdit(tmpArray, subjectCategoryDAO.getSubjectCategory(subjectCategoryName)).execute();
                    joined = true;
                }
                if (joined || !updated) continue;
                successful = new UpdateSubjectCategoryEdit(subjectCategory.getSubjectCategoryID(), subjectCategoryName).execute();
            }
        }
        catch (KnowledgeBaseException e) {
            successful = false;
            this.errorMessage = "An exception happened.";
            throw e;
        }
        return successful;
    }
}

