/*
 * Decompiled with CFR 0.152.
 */
package scimat.gui.commands.edit.globalreplace;

import java.util.ArrayList;
import scimat.gui.commands.edit.KnowledgeBaseEdit;
import scimat.gui.commands.edit.join.JoinReferenceEdit;
import scimat.gui.commands.edit.update.UpdateReferenceEdit;
import scimat.model.knowledgebase.dao.ReferenceDAO;
import scimat.model.knowledgebase.entity.Reference;
import scimat.model.knowledgebase.exception.KnowledgeBaseException;
import scimat.project.CurrentProject;

public class GlobalReplaceReferencesEdit
extends KnowledgeBaseEdit {
    private String findText;
    private String replaceText;
    private boolean findInFullReference;
    private boolean findInVolume;
    private boolean findInIssue;
    private boolean findInPage;
    private boolean findInDoi;
    private boolean findInFormat;
    private boolean findInYear;

    public GlobalReplaceReferencesEdit(String findText, String replaceText, boolean findInFullReference, boolean findInVolume, boolean findInIssue, boolean findInPage, boolean findInDoi, boolean findInFormat, boolean findInYear) {
        this.findText = findText;
        this.replaceText = replaceText;
        this.findInFullReference = findInFullReference;
        this.findInVolume = findInVolume;
        this.findInIssue = findInIssue;
        this.findInPage = findInPage;
        this.findInDoi = findInDoi;
        this.findInFormat = findInFormat;
        this.findInYear = findInYear;
    }

    public boolean execute() throws KnowledgeBaseException {
        boolean successful = false;
        boolean joined = false;
        boolean updated = false;
        ReferenceDAO referenceDAO = CurrentProject.getInstance().getFactoryDAO().getReferenceDAO();
        try {
            ArrayList<Reference> references = referenceDAO.getReferences();
            for (int i = 0; i < references.size(); ++i) {
                String year;
                String format;
                String doi;
                String page;
                String issue;
                String volume;
                String fullReference;
                Reference reference = references.get(i);
                if (this.findInFullReference) {
                    fullReference = reference.getFullReference().replaceAll(this.findText, this.replaceText);
                    updated = updated || !fullReference.equals(reference.getFullReference());
                } else {
                    fullReference = reference.getFullReference();
                    boolean bl = updated ? true : (updated = false);
                }
                if (updated && referenceDAO.checkReference(fullReference)) {
                    ArrayList<Reference> tmpArray = new ArrayList<Reference>();
                    tmpArray.add(reference);
                    successful = new JoinReferenceEdit(tmpArray, referenceDAO.getReference(fullReference)).execute();
                    joined = true;
                }
                if (!joined && this.findInVolume) {
                    volume = reference.getVolume().replaceAll(this.findText, this.replaceText);
                    updated = updated || !volume.equals(reference.getVolume());
                } else {
                    volume = reference.getVolume();
                    boolean bl = updated ? true : (updated = false);
                }
                if (!joined && this.findInIssue) {
                    issue = reference.getIssue().replaceAll(this.findText, this.replaceText);
                    updated = updated || !issue.equals(reference.getIssue());
                } else {
                    issue = reference.getIssue();
                    boolean bl = updated ? true : (updated = false);
                }
                if (!joined && this.findInPage) {
                    page = reference.getPage().replaceAll(this.findText, this.replaceText);
                    updated = updated || !page.equals(reference.getPage());
                } else {
                    page = reference.getPage();
                    boolean bl = updated ? true : (updated = false);
                }
                if (!joined && this.findInDoi) {
                    doi = reference.getDoi().replaceAll(this.findText, this.replaceText);
                    updated = updated || !doi.equals(reference.getDoi());
                } else {
                    doi = reference.getDoi();
                    boolean bl = updated ? true : (updated = false);
                }
                if (!joined && this.findInFormat) {
                    format = reference.getFormat().replaceAll(this.findText, this.replaceText);
                    updated = updated || !format.equals(reference.getFormat());
                } else {
                    format = reference.getFormat();
                    boolean bl = updated ? true : (updated = false);
                }
                if (!joined && this.findInYear) {
                    year = reference.getYear().replaceAll(this.findText, this.replaceText);
                    updated = updated || !year.equals(reference.getYear());
                } else {
                    year = reference.getYear();
                    boolean bl = updated ? true : (updated = false);
                }
                if (joined || !updated) continue;
                successful = new UpdateReferenceEdit(reference.getReferenceID(), fullReference, volume, issue, page, year, doi, format).execute();
            }
        }
        catch (KnowledgeBaseException e) {
            successful = false;
            this.errorMessage = "An exception happened.";
            throw e;
        }
        return successful;
    }
}

