/*
 * Decompiled with CFR 0.152.
 */
package scimat.gui.commands.edit.globalreplace;

import java.util.ArrayList;
import scimat.gui.commands.edit.KnowledgeBaseEdit;
import scimat.gui.commands.edit.join.JoinReferenceSourceEdit;
import scimat.gui.commands.edit.update.UpdateReferenceSourceEdit;
import scimat.model.knowledgebase.dao.ReferenceSourceDAO;
import scimat.model.knowledgebase.entity.ReferenceSource;
import scimat.model.knowledgebase.exception.KnowledgeBaseException;
import scimat.project.CurrentProject;

public class GlobalReplaceReferenceSourcesEdit
extends KnowledgeBaseEdit {
    private String findText;
    private String replaceText;
    private boolean findInSource;

    public GlobalReplaceReferenceSourcesEdit(String findText, String replaceText, boolean findInSource) {
        this.findText = findText;
        this.replaceText = replaceText;
        this.findInSource = findInSource;
    }

    public boolean execute() throws KnowledgeBaseException {
        boolean successful = false;
        boolean joined = false;
        boolean updated = false;
        ReferenceSourceDAO referenceSourceDAO = CurrentProject.getInstance().getFactoryDAO().getReferenceSourceDAO();
        try {
            ArrayList<ReferenceSource> referenceSources = referenceSourceDAO.getReferenceSources();
            for (int i = 0; i < referenceSources.size(); ++i) {
                String source;
                ReferenceSource referenceSource = referenceSources.get(i);
                if (this.findInSource) {
                    source = referenceSource.getSource().replaceAll(this.findText, this.replaceText);
                    updated = updated || !source.equals(referenceSource.getSource());
                } else {
                    source = referenceSource.getSource();
                    boolean bl = updated ? true : (updated = false);
                }
                if (updated && referenceSourceDAO.checkReferenceSource(source)) {
                    ArrayList<ReferenceSource> tmpArray = new ArrayList<ReferenceSource>();
                    tmpArray.add(referenceSource);
                    successful = new JoinReferenceSourceEdit(tmpArray, referenceSourceDAO.getReferenceSource(source)).execute();
                    joined = true;
                }
                if (joined || !updated) continue;
                successful = new UpdateReferenceSourceEdit(referenceSource.getReferenceSourceID(), source).execute();
            }
        }
        catch (KnowledgeBaseException e) {
            successful = false;
            this.errorMessage = "An exception happened.";
            throw e;
        }
        return successful;
    }
}

