/*
 * Decompiled with CFR 0.152.
 */
package scimat.gui.commands.edit.globalreplace;

import java.util.ArrayList;
import scimat.gui.commands.edit.KnowledgeBaseEdit;
import scimat.gui.commands.edit.join.JoinReferenceSourceGroupEdit;
import scimat.gui.commands.edit.update.UpdateReferenceSourceGroupEdit;
import scimat.model.knowledgebase.dao.ReferenceSourceGroupDAO;
import scimat.model.knowledgebase.entity.ReferenceSourceGroup;
import scimat.model.knowledgebase.exception.KnowledgeBaseException;
import scimat.project.CurrentProject;

public class GlobalReplaceReferenceSourceGroupsEdit
extends KnowledgeBaseEdit {
    private String findText;
    private String replaceText;
    private boolean findInGroupName;

    public GlobalReplaceReferenceSourceGroupsEdit(String findText, String replaceText, boolean findInGroupName) {
        this.findText = findText;
        this.replaceText = replaceText;
        this.findInGroupName = findInGroupName;
    }

    public boolean execute() throws KnowledgeBaseException {
        boolean successful = false;
        boolean joined = false;
        boolean updated = false;
        ReferenceSourceGroupDAO referenceSourceGroupDAO = CurrentProject.getInstance().getFactoryDAO().getReferenceSourceGroupDAO();
        try {
            ArrayList<ReferenceSourceGroup> referenceSourceGroups = referenceSourceGroupDAO.getReferenceSourceGroups();
            for (int i = 0; i < referenceSourceGroups.size(); ++i) {
                String groupName;
                ReferenceSourceGroup referenceSourceGroup = referenceSourceGroups.get(i);
                if (this.findInGroupName) {
                    groupName = referenceSourceGroup.getGroupName().replaceAll(this.findText, this.replaceText);
                    updated = updated || !groupName.equals(referenceSourceGroup.getGroupName());
                } else {
                    groupName = referenceSourceGroup.getGroupName();
                    boolean bl = updated ? true : (updated = false);
                }
                if (updated && referenceSourceGroupDAO.checkReferenceSourceGroup(groupName)) {
                    ArrayList<ReferenceSourceGroup> tmpArray = new ArrayList<ReferenceSourceGroup>();
                    tmpArray.add(referenceSourceGroup);
                    successful = new JoinReferenceSourceGroupEdit(tmpArray, referenceSourceGroupDAO.getReferenceSourceGroup(groupName)).execute();
                    joined = true;
                }
                if (joined || !updated) continue;
                successful = new UpdateReferenceSourceGroupEdit(referenceSourceGroup.getReferenceSourceGroupID(), groupName, referenceSourceGroup.isStopGroup()).execute();
            }
        }
        catch (KnowledgeBaseException e) {
            successful = false;
            this.errorMessage = "An exception happened.";
            throw e;
        }
        return successful;
    }
}

