/*
 * Decompiled with CFR 0.152.
 */
package scimat.gui.commands.edit.globalreplace;

import java.util.ArrayList;
import scimat.gui.commands.edit.KnowledgeBaseEdit;
import scimat.gui.commands.edit.join.JoinReferenceGroupEdit;
import scimat.gui.commands.edit.update.UpdateReferenceGroupEdit;
import scimat.model.knowledgebase.dao.ReferenceGroupDAO;
import scimat.model.knowledgebase.entity.ReferenceGroup;
import scimat.model.knowledgebase.exception.KnowledgeBaseException;
import scimat.project.CurrentProject;

public class GlobalReplaceReferenceGroupsEdit
extends KnowledgeBaseEdit {
    private String findText;
    private String replaceText;
    private boolean findInGroupName;

    public GlobalReplaceReferenceGroupsEdit(String findText, String replaceText, boolean findInGroupName) {
        this.findText = findText;
        this.replaceText = replaceText;
        this.findInGroupName = findInGroupName;
    }

    public boolean execute() throws KnowledgeBaseException {
        boolean successful = false;
        boolean joined = false;
        boolean updated = false;
        ReferenceGroupDAO referenceGroupDAO = CurrentProject.getInstance().getFactoryDAO().getReferenceGroupDAO();
        try {
            ArrayList<ReferenceGroup> referenceGroups = referenceGroupDAO.getReferenceGroups();
            for (int i = 0; i < referenceGroups.size(); ++i) {
                String groupName;
                ReferenceGroup referenceGroup = referenceGroups.get(i);
                if (this.findInGroupName) {
                    groupName = referenceGroup.getGroupName().replaceAll(this.findText, this.replaceText);
                    updated = updated || !groupName.equals(referenceGroup.getGroupName());
                } else {
                    groupName = referenceGroup.getGroupName();
                    boolean bl = updated ? true : (updated = false);
                }
                if (updated && referenceGroupDAO.checkReferenceGroup(groupName)) {
                    ArrayList<ReferenceGroup> tmpArray = new ArrayList<ReferenceGroup>();
                    tmpArray.add(referenceGroup);
                    successful = new JoinReferenceGroupEdit(tmpArray, referenceGroupDAO.getReferenceGroup(groupName)).execute();
                    joined = true;
                }
                if (joined || !updated) continue;
                successful = new UpdateReferenceGroupEdit(referenceGroup.getReferenceGroupID(), groupName, referenceGroup.isStopGroup()).execute();
            }
        }
        catch (KnowledgeBaseException e) {
            successful = false;
            this.errorMessage = "An exception happened.";
            throw e;
        }
        return successful;
    }
}

