/*
 * Decompiled with CFR 0.152.
 */
package scimat.gui.commands.edit.globalreplace;

import java.util.ArrayList;
import scimat.gui.commands.edit.KnowledgeBaseEdit;
import scimat.gui.commands.edit.join.JoinPublishDateEdit;
import scimat.gui.commands.edit.update.UpdatePublishDateEdit;
import scimat.model.knowledgebase.dao.PublishDateDAO;
import scimat.model.knowledgebase.entity.PublishDate;
import scimat.model.knowledgebase.exception.KnowledgeBaseException;
import scimat.project.CurrentProject;

public class GlobalReplacePublishDatesEdit
extends KnowledgeBaseEdit {
    private String findText;
    private String replaceText;
    private boolean findInYear;
    private boolean findInDate;

    public GlobalReplacePublishDatesEdit(String findText, String replaceText, boolean findInYear, boolean findInDate) {
        this.findText = findText;
        this.replaceText = replaceText;
        this.findInYear = findInYear;
        this.findInDate = findInDate;
    }

    public boolean execute() throws KnowledgeBaseException {
        boolean successful = false;
        boolean joined = false;
        boolean updated = false;
        PublishDateDAO publishDateDAO = CurrentProject.getInstance().getFactoryDAO().getPublishDateDAO();
        try {
            ArrayList<PublishDate> publishDates = publishDateDAO.getPublishDates();
            for (int i = 0; i < publishDates.size(); ++i) {
                String date;
                String year;
                PublishDate publishDate = publishDates.get(i);
                if (this.findInYear) {
                    year = publishDate.getYear().replaceAll(this.findText, this.replaceText);
                    updated = updated || !year.equals(publishDate.getYear());
                } else {
                    year = publishDate.getYear();
                    boolean bl = updated ? true : (updated = false);
                }
                if (this.findInDate) {
                    date = publishDate.getDate().replaceAll(this.findText, this.replaceText);
                    updated = updated || !date.equals(publishDate.getDate());
                } else {
                    date = publishDate.getDate();
                    boolean bl = updated ? true : (updated = false);
                }
                if (updated && publishDateDAO.checkPublishDate(year, date)) {
                    ArrayList<PublishDate> tmpArray = new ArrayList<PublishDate>();
                    tmpArray.add(publishDate);
                    successful = new JoinPublishDateEdit(tmpArray, publishDateDAO.getPublishDate(year, date)).execute();
                    joined = true;
                }
                if (joined || !updated) continue;
                successful = new UpdatePublishDateEdit(publishDate.getPublishDateID(), year, date).execute();
            }
        }
        catch (KnowledgeBaseException e) {
            successful = false;
            this.errorMessage = "An exception happened.";
            throw e;
        }
        return successful;
    }
}

