/*
 * Decompiled with CFR 0.152.
 */
package scimat.gui.commands.edit.globalreplace;

import java.util.ArrayList;
import scimat.gui.commands.edit.KnowledgeBaseEdit;
import scimat.gui.commands.edit.join.JoinPeriodEdit;
import scimat.gui.commands.edit.update.UpdatePeriodEdit;
import scimat.model.knowledgebase.dao.PeriodDAO;
import scimat.model.knowledgebase.entity.Period;
import scimat.model.knowledgebase.exception.KnowledgeBaseException;
import scimat.project.CurrentProject;

public class GlobalReplacePeriodsEdit
extends KnowledgeBaseEdit {
    private String findText;
    private String replaceText;
    private boolean findInName;

    public GlobalReplacePeriodsEdit(String findText, String replaceText, boolean findInName) {
        this.findText = findText;
        this.replaceText = replaceText;
        this.findInName = findInName;
    }

    public boolean execute() throws KnowledgeBaseException {
        boolean successful = false;
        boolean joined = false;
        boolean updated = false;
        PeriodDAO periodDAO = CurrentProject.getInstance().getFactoryDAO().getPeriodDAO();
        try {
            ArrayList<Period> periods = periodDAO.getPeriods();
            for (int i = 0; i < periods.size(); ++i) {
                String name;
                Period period = periods.get(i);
                if (this.findInName) {
                    name = period.getName().replaceAll(this.findText, this.replaceText);
                    updated = updated || !name.equals(period.getName());
                } else {
                    name = period.getName();
                    boolean bl = updated ? true : (updated = false);
                }
                if (updated && periodDAO.checkPeriod(name)) {
                    ArrayList<Period> tmpArray = new ArrayList<Period>();
                    tmpArray.add(period);
                    successful = new JoinPeriodEdit(tmpArray, periodDAO.getPeriod(name)).execute();
                    joined = true;
                }
                if (joined || !updated) continue;
                successful = new UpdatePeriodEdit(period.getPeriodID(), name, period.getPosition()).execute();
            }
        }
        catch (KnowledgeBaseException e) {
            successful = false;
            this.errorMessage = "An exception happened.";
            throw e;
        }
        return successful;
    }
}

