/*
 * Decompiled with CFR 0.152.
 */
package scimat.gui.commands.edit.globalreplace;

import java.util.ArrayList;
import scimat.gui.commands.edit.KnowledgeBaseEdit;
import scimat.gui.commands.edit.join.JoinJournalEdit;
import scimat.gui.commands.edit.update.UpdateJournalEdit;
import scimat.model.knowledgebase.dao.JournalDAO;
import scimat.model.knowledgebase.entity.Journal;
import scimat.model.knowledgebase.exception.KnowledgeBaseException;
import scimat.project.CurrentProject;

public class GlobalReplaceJournalsEdit
extends KnowledgeBaseEdit {
    private String findText;
    private String replaceText;
    private boolean findInSource;
    private boolean findInConferenceInformation;

    public GlobalReplaceJournalsEdit(String findText, String replaceText, boolean findInSource, boolean findInConferenceInformation) {
        this.findText = findText;
        this.replaceText = replaceText;
        this.findInSource = findInSource;
        this.findInConferenceInformation = findInConferenceInformation;
    }

    public boolean execute() throws KnowledgeBaseException {
        boolean successful = false;
        boolean joined = false;
        boolean updated = false;
        JournalDAO journalDAO = CurrentProject.getInstance().getFactoryDAO().getJournalDAO();
        try {
            ArrayList<Journal> journals = journalDAO.getJournals();
            for (int i = 0; i < journals.size(); ++i) {
                String conferenceInformation;
                String source;
                Journal journal = journals.get(i);
                if (this.findInSource) {
                    source = journal.getSource().replaceAll(this.findText, this.replaceText);
                    updated = updated || !source.equals(journal.getSource());
                } else {
                    source = journal.getSource();
                    boolean bl = updated ? true : (updated = false);
                }
                if (updated && journalDAO.checkJournal(source)) {
                    ArrayList<Journal> tmpArray = new ArrayList<Journal>();
                    tmpArray.add(journal);
                    successful = new JoinJournalEdit(tmpArray, journalDAO.getJournal(source)).execute();
                    joined = true;
                }
                if (!joined && this.findInConferenceInformation) {
                    conferenceInformation = journal.getConferenceInformation().replaceAll(this.findText, this.replaceText);
                    updated = updated || !conferenceInformation.equals(journal.getConferenceInformation());
                } else {
                    conferenceInformation = journal.getConferenceInformation();
                    boolean bl = updated ? true : (updated = false);
                }
                if (joined || !updated) continue;
                successful = new UpdateJournalEdit(journal.getJournalID(), source, conferenceInformation).execute();
            }
        }
        catch (KnowledgeBaseException e) {
            successful = false;
            this.errorMessage = "An exception happened.";
            throw e;
        }
        return successful;
    }
}

